/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <conexus/conexus.h>

#include <iostream>

void print_data(conexus::Data d);

int main() {
  conexus::init();
  conexus::PacketCapture::Devices devs = conexus::PacketCapture::get_all_devices();
  conexus::PacketCapture::Devices::iterator iter;
  conexus::Data d;
  for (iter = devs.begin(); iter != devs.end(); iter++) {
    std::cout << "Name: " << iter->name << "\tAddress: " << iter->addresses[conexus::PacketCapture::ADDRESS].get_address_string() << std::endl;
  }

  conexus::PacketCapture pc("lo");
  pc.connect_to_data(sigc::ptr_fun(&print_data));
  pc.start();

  // Set up a loop that will run for 20 seconds and print the time every 5
  // seconds. Since the server is threaded, the sleep(1) call will not effect
  // the servicing thread.
  std::cout << "Starting..." << std::endl;
  for (int i=1; i <= 20; i++) {
    if (i%5 == 0)
      std::cout << "Time: " << i << std::endl;
    sleep(1);
  }

  // Stop the server and prepare for shutdown
  pc.stop();
}

void print_data(conexus::Data d) {
  static conexus::Data sd;
  sd = d;
  std::cout << "<1> Received " << d.size << " bytes of data (" << *((uint64_t*)d.data.get()) << ") [" << d << "]\n";
}

