/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <conexus/conexus.h>
#include <unistd.h>
#include <iostream>

#include <netinet/in.h>

using namespace conexus;
using namespace std;

typedef struct datagram {
  uint8_t ihl:4;
  uint8_t version:4;
  uint8_t tos;
  uint16_t tl;
  uint16_t id;
  uint16_t fragoffset:13;
  uint8_t flags:3;
  uint8_t ttl;
  uint8_t protocol;
  uint16_t checksum;
  uint32_t source;
  uint32_t destination;
  uint8_t data[];
} datagram;

void print_data(Data d);

int main() {
  conexus::init();

  LL::Packet packet(ETH_P_ALL);
  LL::Address address;
  address.set_interface("eth0");
  packet.bind(address);
  FDServer server;

//   std::cout << "Listening on " << packet.get_interface_name() << std::endl;

  server.connect_to_data(sigc::ptr_fun(&print_data));
  server.add_socket(packet);
  server.set_responsiveness(5);
  server.start();
  for (int i=1; i <= 20; i++) {
    if (i%5 == 0)
      cout << "Time: " << i << endl;
    sleep(1);
  }
  server.stop();

  return 0;
}

void print_data(Data d) {
  IP::Address addr;
  datagram* dg = (datagram*)d.data.get();
  addr.set_address(ntohl(dg->source));
  cout << "Received " << d.size << " bytes of data from " << addr.get_address_string() << "\n";
  cout << "version: " << (uint)dg->version << endl;
  cout << "ihl: " << (uint)dg->ihl << endl;
  cout << "tos: " << (uint)dg->tos << endl;
  cout << "tl: " << ntohs((uint)dg->tl) << endl;
  cout << "id: " << ntohs((uint)dg->id) << endl;
  cout << "flags: " << (uint)dg->flags << endl;
  cout << "fragoffset: " << ntohs((uint)dg->fragoffset) << endl;
  cout << "ttl: " << (uint)dg->ttl << endl;
  cout << "protocol: " << (uint)dg->protocol << endl;
  cout << "checksum: " << ntohs((uint)dg->checksum) << endl;
}
