/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <conexus/conexus.h>
#include <unistd.h>
#include <iostream>

using namespace conexus;

void print_data(Data d);

int main() {
  IP::Multicast mcast;
  FDServer server;

  conexus::init();

  mcast.set_local_port(1500);
  mcast.join("224.1.1.5");
  mcast.join("224.1.1.6");

  server.connect_to_data(sigc::ptr_fun(&print_data));
  server.add_socket(mcast);
  server.set_responsiveness(5);
  server.start();
  for (int i=1; i <= 20; i++) {
    if (i%5 == 0)
      std::cout << "Time: " << i << std::endl;
    sleep(1);
  }
  server.stop();

  mcast.leave("224.1.1.5");
  mcast.leave("224.1.1.6");

  return 0;
}

void print_data(Data d) {
  std::cout << "Received " << d.size << " bytes of data [" << d << "]\n";
}
