/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <conexus/conexus.h>

using namespace conexus;

int main(int argc, char* argv[]) {
  conexus::init();

  IP::Multicast mcast;
  IP::Address addr;
  char defaultdata[] = "0123456789";
  char defaulthost[] = "224.1.1.5";
  char* host;
  int port;
  char* data;

  if (argc <= 1)
    host = defaulthost;
  else
    host = argv[1];

  if (argc <= 2)
    port = 1500;
  else
    port = atoi(argv[2]);

  if (argc <= 3)
    data = defaultdata;
  else
    data = argv[3];

  addr.set_hostname(host);
  addr.set_port(port);
  mcast.set_multicast_ttl(64);
  mcast.set_multicast_loop(true);
  mcast.writeto(addr, data, strlen(data)+1);
  mcast.connect(addr);
  mcast.write(data, strlen(data)+1);
  return 0;
}
