/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSGTKIOBLOCKBUTTON_H
#define CONEXUSGTKIOBLOCKBUTTON_H

#include <map>
#include <gtkmm.h>

#include <conexus/io.h>

namespace conexusgtk {

/**
@author Rick L Vinyard Jr
*/
class IOBlockButton : public Gtk::HBox
{
public:
    IOBlockButton();

    ~IOBlockButton();

    void connect(conexus::IO& io, bool control_read=true, bool control_write=true);
    void disconnect(conexus::IO& io);

  protected:
    Gtk::CheckButton m_button;
    Gtk::Image m_image;
    Gtk::Label m_text;

    typedef std::set<conexus::IO*> Controlled;
    Controlled m_read_control;
    Controlled m_write_control;

    void on_button_toggled();

    void change_display(bool);

};

}

#endif
