/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSGTK_IPHOSTPORTENTRY_H
#define CONEXUSGTK_IPHOSTPORTENTRY_H

#include <gtkmm.h>

#include <conexusgtk/hostentry.h>
#include <conexusgtk/portentry.h>

namespace conexusgtk {

namespace IP {

/**
@author Rick L Vinyard Jr
*/
class HostPortEntry : public Gtk::Table
{
public:
    HostPortEntry();

    ~HostPortEntry();

    HostEntry& get_host_entry();
    PortEntry& get_port_entry();

    std::string get_host();
    void set_host(std::string);

    uint32_t get_port();
    void set_port(uint32_t p);

    void connect(conexus::IP::Address& address);
    void disconnect(conexus::IP::Address& address);

    void connect_local_address(conexus::IP::IP& ip);
    void disconnect_local_address(conexus::IP::IP& ip);

    void connect_remote_address(conexus::IP::IP& ip);
    void disconnect_remote_address(conexus::IP::IP& ip);

    sigc::signal<void, bool> signal_host_changed();
    sigc::signal<void> signal_port_changed();

  protected:
    HostEntry m_host;
    PortEntry m_port;
};

}

}

#endif
