/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSGTKHOSTENTRY_H
#define CONEXUSGTKHOSTENTRY_H

#include <set>
#include <string>
#include <gtkmm.h>
#include <conexus/conexus.h>

namespace conexusgtk {

namespace IP {

/**
@author Rick L Vinyard Jr
*/
class HostEntry : public Gtk::VBox
{
public:
    HostEntry();
    HostEntry(conexus::IP::Address& addr);

    ~HostEntry();

    Gtk::ComboBoxEntryText& get_host_box();
    Gtk::Image& get_good_host_image();
    Gtk::Image& get_bad_host_image();

    std::string set_host(std::string s);
    std::string get_host();
    sigc::signal<void, bool> signal_host_changed();

    void connect(conexus::IP::Address& address);
    void disconnect(conexus::IP::Address& address);

    void connect_local_address(conexus::IP::IP& ip);
    void disconnect_local_address(conexus::IP::IP& ip);

    void connect_remote_address(conexus::IP::IP& ip);
    void disconnect_remote_address(conexus::IP::IP& ip);

  protected:
    bool m_change_lock;
    std::set<std::string> m_host_names;
    typedef std::set<conexus::IP::Address*> Addresses;
    typedef std::set<conexus::IP::IP*> IPSockets;
    Addresses m_connected_addresses;
    IPSockets m_connected_local_ipsockets;
    IPSockets m_connected_remote_ipsockets;

    Gtk::Label m_hostname_label;
    Gtk::Label m_address_label;
    Gtk::ComboBoxEntryText m_host;
    Gtk::EventBox m_image_holder;
    Gtk::Image m_good_host_image;
    Gtk::Image m_bad_host_image;

    sigc::signal<void, bool> m_signal_host_changed;

    virtual void on_host_changed();

  private:
    void setup_widget();

};

}

}

#endif
