/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "dotteddecimalentry.h"
#include <iostream>
#include <sstream>

using namespace conexusgtk::IP;

DottedDecimalEntry::DottedDecimalEntry():
Gtk::HBox() {
  Gtk::Label* label;
  int i;
  for (i=0; i < 3; i++) {
    pack_start(m_entry[i]);
    label = Gtk::manage(new Gtk::Label());
    label->set_markup("<big><big><b>.</b></big></big>");
    label->set_use_markup();
    pack_start(*label);
  }
  pack_start(m_entry[i]);

  for (i=0; i < 4; i++) {
    m_entry[i].signal_insert_text().connect(
      sigc::bind(sigc::mem_fun(*this, &DottedDecimalEntry::on_entry_insert_text), i));
    m_entry[i].set_width_chars(3);
  }
}


DottedDecimalEntry::~DottedDecimalEntry() {}


void DottedDecimalEntry::on_entry_insert_text( const Glib::ustring & text, int * position, int n )
{
  std::string s = m_entry[n].get_text();
  char c = text[0];
  int pos = *position;

  if (n < 3 && c == '.')
    m_entry[n+1].grab_focus();
  else if (n == 3 && c == '.')
    m_entry[0].grab_focus();

  if (c < '0' || c > '9') {
    if (s.size() > 1)
    s.erase(pos-1, pos);
    else
      s = "";
    m_entry[n].set_text(s);
  }
  else if (c >= '0' && c <= '9' ) {
    std::istringstream sstrm(s);
    int val;
    sstrm >> val;
    if (val > 255) {
      s.erase(s.begin()+pos-1);
      m_entry[n].set_text(s);
    }
    if (n < 3 && s.size() >= 3)
    m_entry[n+1].grab_focus();
  }
}

std::string DottedDecimalEntry::get_value_string( )
{
  int i;
  std::string s;
  for (i=0; i < 3; i++)
    s += m_entry[i].get_text() + '.';
  s += m_entry[i].get_text();
  return s;
}

