/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSLL_PACKET_H
#define CONEXUSLL_PACKET_H

#include <conexus/socket.h>
#include <conexus/ll_address.h>

namespace conexus {

namespace LL {

/**
@author Rick L Vinyard Jr
   * @ingroup conexus
 */
class Packet : public Socket
{
public:
  Packet(int protocol=ETH_P_IP, int type=SOCK_DGRAM);

  virtual ~Packet() throw();

  virtual void bind() throw (bind_error);
  virtual void bind(Address& a) throw (bind_error) { Socket::bind(a); }

  virtual Data read()  throw (read_error);
  virtual ssize_t write(const void* data, size_t size) throw (write_error);


  void set_interface(int);
  void set_interface(const std::string);

  int get_interface_index(const std::string name);
  std::string get_interface_name(int ifindex);
  std::vector<std::string> get_interface_names();


  protected:
    Address m_address;
    int m_protocol;

};

}

}

#endif
