/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUS_LLLL_ADDRESS_H
#define CONEXUS_LLLL_ADDRESS_H

#include <netpacket/packet.h>
#include <net/ethernet.h>

#include <vector>
#include <string>

#include <conexus/address.h>
#include <conexus/utility.h>

namespace conexus {

/**
 * @namespace conexus::LL
 * The conexus::LL (Link Layer) namespace contains classes capable of communicating directly at the
 * OSI Layer 2 and allows protocol modules to be implemented in user space directly
 * on top of the physical layer [ For more information see PACKET(7) ]
 */
namespace LL {

/**
 * Link Layer packet interface device address.
 *
 * This object wraps the Linux device level packet interface structure sockaddr_ll
 * and provides accessor methods for the members. Many of the related
 * functions for manipulating the sockaddr_ll structure are presented in the class
 * interface as methods.
 *
 * Several extensions to the API functionality are also provided, such as a method to
 * retrieve the kernel's numeric index for a give interface or the MAC address.
 *
 * @author Rick L Vinyard Jr
 * @ingroup conexus
 */
class Address : public conexus::Address
{
public:
    Address(unsigned short protocol=ETH_P_IP);

    ~Address();

    unsigned short get_family() const;

    unsigned short get_protocol() const;
    void set_protocol(unsigned short);

    int get_interface_index() const;
    unsigned short get_hardware_type() const;
    unsigned char get_packet_type() const;
    unsigned char get_hardware_address_length() const;
    const unsigned char* get_hardware_address() const;

    virtual struct sockaddr* get_raw_address();
    virtual socklen_t get_raw_address_size() const;
    virtual bool is_broadcast() const;

    void set_interface(int);
    void set_interface(const std::string);

    friend class Packet;

protected:
  struct sockaddr_ll m_sockaddr_ll;

};

}

}

#endif
