/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "ll_address.h"

#include <netinet/in.h>
#include <sys/ioctl.h>
#include <net/if.h>

using namespace conexus::LL;

Address::Address(unsigned short protocol)
        : conexus::Address() {
    memset(&m_sockaddr_ll, 0x00, sizeof(m_sockaddr_ll));
    m_sockaddr_ll.sll_family = AF_PACKET;
    m_sockaddr_ll.sll_protocol = htons(protocol);
}

Address::~Address() {}

unsigned short Address::get_family() const {
    return m_sockaddr_ll.sll_family;
}

unsigned short Address::get_protocol() const {
    return ntohs(m_sockaddr_ll.sll_protocol);
}

void Address::set_protocol(unsigned short p) {
    m_sockaddr_ll.sll_protocol = htons(p);
}

int Address::get_interface_index() const {
    return m_sockaddr_ll.sll_ifindex;
}

unsigned short Address::get_hardware_type() const {
    return m_sockaddr_ll.sll_hatype;
}

unsigned char Address::get_packet_type() const {
    return m_sockaddr_ll.sll_pkttype;
}

unsigned char Address::get_hardware_address_length() const {
    return m_sockaddr_ll.sll_halen;
}

const unsigned char* Address::get_hardware_address() const {
    return m_sockaddr_ll.sll_addr;
}

struct sockaddr* Address::get_raw_address() {
    return (struct sockaddr*)&m_sockaddr_ll;
}

socklen_t Address::get_raw_address_size() const {
    return sizeof(struct sockaddr_ll);
}

bool Address::is_broadcast() const {
    return (m_sockaddr_ll.sll_pkttype == PACKET_BROADCAST);
}

void Address::set_interface(int ifindex) {
  set_interface(conexus::get_interface_name(ifindex));
}

void Address::set_interface(const std::string ifname) {
  int sd = socket(PF_PACKET, SOCK_RAW, 0);
  struct ifreq req;
  strncpy(req.ifr_name, ifname.c_str(), IFNAMSIZ);
  if (ioctl(sd, SIOCGIFINDEX, &req) >= 0) {
    m_sockaddr_ll.sll_ifindex = req.ifr_ifindex;
    if (ioctl(sd, SIOCGIFHWADDR, &req) >= 0) {
      m_sockaddr_ll.sll_hatype = req.ifr_hwaddr.sa_family;
      m_sockaddr_ll.sll_halen = 8;
      memcpy(m_sockaddr_ll.sll_addr, req.ifr_hwaddr.sa_data, 8);
    }
  }
  close(sd);
}

