/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUS_IPIP_MULTICAST_H
#define CONEXUS_IPIP_MULTICAST_H

#include <conexus/ip_udp.h>

namespace conexus {

namespace IP {

/**
 * This class extends the UDP class to provide methods for joining and leaving multicast groups.
 *
 * @author Rick L Vinyard Jr
 * @ingroup conexus
 */
class Multicast : public UDP
{
public:
    Multicast();

  virtual ~Multicast() throw();

    /**
     * Joins the multicast group specified by @em addr.
     *
     * @param ifindex is  the  interface index of the interface
     *    that should join the multicast group, or 0 to indicate
     *    any interface.
     */
    void join(Address& addr, int ifindex=0);

    /**
     * Joins the multicast group specified by @em addr.
     *
     * @param ifindex is  the  interface index of the interface
     *    that should join the multicast group, or 0 to indicate
     *    any interface.
     */
    void join(const std::string addr, int ifindex=0);

    /**
     * Leaves the multicast group specified by @em addr.
     *
     * @param ifindex is  the  interface index of the interface
     *    that should leave the multicast group, or 0 to indicate
     *    any interface.
     */
    void leave(Address& addr, int ifindex=0);

    /**
     * Leaves the multicast group specified by @em addr.
     *
     * @param ifindex is  the  interface index of the interface
     *    that should leave the multicast group, or 0 to indicate
     *    any interface.
     */
    void leave(const std::string addr, int ifindex=0);

      /**
     * Returns the multicast ttl of the currently associated interface.
     */
  int get_multicast_ttl();

    /**
     * Sets the multicast ttl of the currently associated interface to @em hops.
     */
  void set_multicast_ttl(int hops);

    /**
     * If true multicast packets are looped back to local sockets.
     */
  bool get_multicast_loop();

    /**
     * If parameter @em loop is true then multicast packets are looped back to local sockets.
     */
  void set_multicast_loop(bool loop);

};

}

}

#endif
