/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSSTATE_ERROR_H
#define CONEXUSSTATE_ERROR_H

#include <conexus/error.h>

namespace conexus
  {

  /**
   * Base class for all state transition errors.
   * @author Rick L Vinyard Jr
   * @ingroup errors
   */
  class state_error: public conexus_error
    {
    public:
      state_error(int e=0): conexus_error("Unknown error, state transition failed.",e,"state")
      { }
      state_error(const std::string s, int e=0): conexus_error(s,e,"state")
      { }
    }
  ;

  namespace error
    {

    namespace state
      {

      /**
       * State transition is illegal; i.e. not supported state, such as UNCHANGED
       * @author Rick L Vinyard Jr
       * @ingroup errors
       */
      class illegal: public state_error
        {
        public:
          illegal(): state_error("Attempting to transition to an illegal state.", -1)
          { }
        }
      ;

      /**
       * State transition is inconsistent such as OPENED|CLOSED
       * @author Rick L Vinyard Jr
       * @ingroup errors
       */
      class inconsistent: public state_error
      {
      public:
      inconsistent(): state_error("Attempting to transition to an inconsistent state.", -1)
        { }
      }
      ;

      /**
       * The state transition failed. The state transition was a legal state, the request
       * was not inconsistent, but for one reason or another it still failed.
       * @author Rick L Vinyard Jr
       * @ingroup errors
       */
      class failed: public state_error
      {
      public:
      failed(): state_error("State transition was legal and consistent, but it still failed.", -1)
        { }
      }
      ;

      }

  }

}

#endif // CONEXUSSEND_ERROR_H
