/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSLISTEN_ERROR_H
#define CONEXUSLISTEN_ERROR_H

#include <conexus/error.h>

namespace conexus {

/**
 * Base class for all listen errors.
 * @author Rick L Vinyard Jr
 * @ingroup errors
 */
class listen_error: public conexus_error {
public:
listen_error(int e=0): conexus_error("Unknown error, socket not listening.",e,"listen") { }
listen_error(const std::string s, int e=0): conexus_error(s,e,"listen") { }
}
;

namespace error {


namespace listen {

/**
 * EADDRINUSE
 * Another socket is already listening on the same port.
 * @author Rick L Vinyard Jr
 * @ingroup errors
 */
class address_in_use: public listen_error {
public:
address_in_use(): listen_error("Another socket is already listening on the same port.", EADDRINUSE) { }
}
;

/**
 * EBADF
 * The argument s is not a valid descriptor.
 * @author Rick L Vinyard Jr
 * @ingroup errors
 */
class bad_fd: public listen_error {
public:
  bad_fd(): listen_error("The file descriptor is not a valid index in the descriptor table.", EBADF) { }
}
;

/**
 * ENOTSOCK
 * The argument s is not a socket.
 * @author Rick L Vinyard Jr
 * @ingroup errors
 */
class not_socket: public listen_error {
public:
not_socket(): listen_error("The file descriptor is not associated with a socket.", ENOTSOCK) { }
}
;

      /**
       * EOPNOTSUPP
       * The socket is not of a type that supports the listen operation.
       * @author Rick L Vinyard Jr
       * @ingroup errors
       */
class operation_not_supported: public listen_error
{
public:
operation_not_supported(): listen_error("The socket is not of a type that supports the listen operation.", EOPNOTSUPP)
  { }
}
;

      /**
       * Not bound.
       * @author Rick L Vinyard Jr
       * @ingroup errors
       */
class not_bound: public listen_error
{
public:
not_bound(): listen_error("Trying to listen on a socket that can't be bound.", -1)
  { }
}
;



}
}
}

#endif // CONEXUSCONNECT_ERROR_H
