# Copyright (C)  2006  Daniele Zelante

# This file is part of makroz.
# 
# makroz is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# makroz is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with makroz; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#@LICENSE
# $Id$


# before or after this file:


#  must be defined 

#PRODUCT=productnme
#VERSION=number
#RELEASE=number
#BUILDNR=number


#  may be defined:

#DEBUGBUILD={0,1}
#STATICBUILD={0,1} defaults to 0 for Linux/BSD, autoset to 1 for Cygwin
#PREFIX


#  may be modified

#CPPFLAGS
#CXXFLAGS
#LDFLAGS
#LDLIBS



# must be defined in GNUmakefile

#install_custom:
#doc_custom:



DEBUGBUILD ?= 0
STATICBUILD ?= 0
PREFIX ?= /usr/local
TARBALLFILENAME ?= /dev/null

ARCH := $(shell uname)

COMMONFLAGS :=

ifeq ($(ARCH),CYGWIN_NT-5.0)
	STATICBUILD := 1
endif



ifeq ($(DEBUGBUILD),0)
	ifeq ($(STATICBUILD),0)
		LIBTYPE :=
	else
		LIBTYPE := -sta
	endif
else
	ifeq ($(STATICBUILD),0)
		LIBTYPE := -dbg		
	else
		LIBTYPE := -sta-dbg
	endif
endif


ifneq ($(STATICBUILD),0)
	COMMONFLAGS += -static
endif


ifeq ($(ARCH),Linux)
	GNUNATIVE:=1
	EXESFX:=
	DLLSFX:=
	SOSFX:=.so
	LIBPFX:=lib
	FPIC:=-fPIC
endif

ifeq ($(ARCH),NetBSD)
	GNUNATIVE:=0
	EXESFX:=
	DLLSFX:=
	SOSFX:=.so
	LIBPFX:=lib
	FPIC:=-fPIC
endif

ifeq ($(ARCH),FreeBSD)
	GNUNATIVE:=0
	EXESFX:=
	DLLSFX:=
	SOSFX:=.so
	LIBPFX:=lib
	FPIC:=-fPIC
endif

ifeq ($(ARCH),CYGWIN_NT-5.0)
	GNUNATIVE:=1
	EXESFX:=.exe
	DLLSFX:=.dll
	SOSFX:=
	LIBPFX:=lib
	FPIC:=-fPIC
endif


ifneq ($(GNUNATIVE),0)
	FIND := find
	TAR := tar
	SED := sed
else
	FIND := gfind
	TAR := gtar
	SED := gsed
endif	





