# Copyright (C)  2006  Daniele Zelante

# This file is part of makroz.
# 
# makroz is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# makroz is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with makroz; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#@LICENSE
# $Id$



MKDIR := mkdir -p
MV := mv
SYMLINK := ln -sfn


WARNINGS := \
	-Wall \
	-W \
	-Wpointer-arith \
	-Wcast-qual \
	-Wcast-align \
	-Wwrite-strings \
	-Wconversion \
	-Wsign-compare \
	-Wfloat-equal \
	-Wendif-labels \
	-Wshadow \
	-Wpointer-arith


#WARNINGS += -Wunreachable-code 

WARNINGSC := $(WARNINGS)

WARNINGSCXX := $(WARNINGS) \
	-Woverloaded-virtual \
	-Wold-style-cast \
	-Wsynth

#WARNINGSCXX += -Wabi -Weffc++



#TIMESTAMP := $(strip $(shell date -u +%Y_%m_%d_%H_%M_%S_%N))
TIMESTAMP := $(strip $(shell date --iso-8601=s))

HEADERS :=
HEADERS += $(shell $(FIND) src/ -maxdepth 1 -name '*.h')
HEADERS += $(shell $(FIND) src/ -maxdepth 1 -name '*.hh')
HEADERS += $(shell $(FIND) src/ -maxdepth 1 -name '*.hxx')
HEADERS += $(shell $(FIND) src/ -maxdepth 1 -name '*.hpp')

SOURCESC := $(shell $(FIND) src/ -maxdepth 1 -name '*.c' -printf '%p ' | sort)
SOURCESCC := $(shell $(FIND) src/ -maxdepth 1 -name '*.cc' -printf '%p ' | sort) 
SOURCESCXX := $(shell $(FIND) src/ -maxdepth 1 -name '*.cxx' -printf '%p ' | sort) 
SOURCESCPP := $(shell $(FIND) src/ -maxdepth 1 -name '*.cpp' -printf '%p ' | sort) 
SOURCES := $(SOURCESC) $(SOURCESCC) $(SOURCESCXX) $(SOURCESCPP)

OBJECTS := $(addprefix .bins/,$(notdir $(SOURCESC:.c=.o)))
OBJECTS += $(addprefix .bins/,$(notdir $(SOURCESCC:.cc=.o)))
OBJECTS += $(addprefix .bins/,$(notdir $(SOURCESCXX:.cxx=.o)))
OBJECTS += $(addprefix .bins/,$(notdir $(SOURCESCPP:.cpp=.o)))



DUMMY := $(shell touch .depends)

COMMONFLAGS += -pipe

#CPPFLAGS :=
CPPFLAGS += -I$(PREFIX)/include
CPPFLAGS += -D__STDC_LIMIT_MACROS -D_REENTRANT -D_FILE_OFFSET_BITS=64
CPPFLAGS += -DMAKROZ_BUILDING_$(PRODUCT)
CPPFLAGS += -DMAKROZ_PRODUCT=$(PRODUCT)
CPPFLAGS += -DMAKROZ_PRODUCTSTR="\"$(PRODUCT)\""
CPPFLAGS += -DMAKROZ_VERSION=$(VERSION)
CPPFLAGS += -DMAKROZ_RELEASE=$(RELEASE)
CPPFLAGS += -DMAKROZ_BUILDNR=$(BUILDNR)
CPPFLAGS += -DMAKROZ_TIMESTAMP="\"$(TIMESTAMP)\""

ifneq ($(STATICBUILD),0)
	CPPFLAGS += -DMAKROZ_STATIC
endif	


CFLAGS += $(WARNINGSC)
CXXFLAGS += -ffor-scope $(WARNINGSCXX)
LDFLAGS += -L$(PREFIX)/lib $(WARNINGS)

ifeq ($(ARCH),Linux)
	CPPFLAGS += -DMAKROZ_HASWIDE
endif

ifeq ($(ARCH),FreeBSD)
	CPPFLAGS += -DMAKROZ_HASWIDE
endif

ifeq ($(ARCH),NetBSD)
	CPPFLAGS += -I/usr/pkg/include	
	LDFLAGS += -L/usr/pkg/lib
endif

ifeq ($(ARCH),CYGWIN_NT-5.0)
endif



ifeq ($(DEBUGBUILD),0)
	CPPFLAGS += -DNDEBUG -DMAKROZ_DEBUG=false
	CXXFLAGS += -O3
	LDFLAGS += -s
else
	CPPFLAGS += -DMAKROZ_DEBUG=true
	CPPFLAGS += -D_GLIBCXX_CONCEPT_CHECKS -D_GLIBCXX_DEBUG -DGLIBCXX_DEBUG_PEDANTIC
	CXXFLAGS += -ggdb

	ifeq ($(STATICBUILD),0)
			LDFLAGS += -rdynamic
	endif
endif





PRODUCTV := $(PRODUCT)-$(VERSION)
PRODUCTVRB := $(PRODUCTV).$(RELEASE).$(BUILDNR)


.bins/%.o : src/%.cxx
	$(CXX) $(COMMONFLAGS) -c $(CPPFLAGS) $(CXXFLAGS) $< -o $@

.bins/%.o : src/%.cc
	$(CXX) $(COMMONFLAGS) -c $(CPPFLAGS) $(CXXFLAGS) $< -o $@

.bins/%.o : src/%.c
	$(CC) $(COMMONFLAGS) -c $(CPPFLAGS) $(CFLAGS) $< -o $@	




.PHONY: init
.PHONY: install
.PHONY: clean
.PHONY: tarball
.PHONY: snapshot
.PHONY: chmodx


all: init 
	$(MAKE) depend
	$(MAKE) binary


init:

ifeq ($(PRODUCT),)
	$(error PRODUCT must be defined)
endif
ifeq ($(VERSION),)
	$(error VERSION must be defined)
endif
ifeq ($(RELEASE),)
	$(error RELEASE must be defined)
endif
ifeq ($(BUILDNR),)
	$(error BUILDNR must be defined)
endif
	touch src/$(PRODUCT).cxx
	mkdir -p .bins/



depend: init $(SOURCES) $(HEADERS)
	$(CXX) -MM $(CPPFLAGS) $(CXXFLAGS) $(SOURCES) | $(SED) -r '/^[^ ]+\.o/s/^/.bins\//' > .depends


include .depends

test: binary
	$(MAKE) -C test clean
	$(MAKE) -C test
	cd test; ./test.sh



snapshot:
	touch configure
	chmod +x configure
	$(MKDIR) .tmp/$(PRODUCTVRB)
	$(TAR) --exclude 'CVS' --exclude '.*' -c -f - * | $(TAR) -x -f - -C .tmp/$(PRODUCTVRB)
	cd .tmp; $(TAR) --owner 0 --group 0 -zcf $(PRODUCTVRB)-$(TIMESTAMP).tar.gz $(PRODUCTVRB)
	$(MV) .tmp/*.tar.gz ..
	$(RM) -r .tmp

tarball:
	touch configure
	chmod +x configure
	$(MKDIR) .tmp/$(PRODUCTVRB)
	$(TAR) --exclude 'CVS' --exclude '.*' -c -f - * | $(TAR) -x -f - -C .tmp/$(PRODUCTVRB)
	cd .tmp; $(TAR) --owner 0 --group 0 -zcf $(PRODUCTVRB).tar.gz $(PRODUCTVRB)
	$(MV) .tmp/*.tar.gz ..
	$(RM) -r .tmp
	echo $(PRODUCTVRB).tar.gz > $(TARBALLFILENAME)


clean:
	$(RM) -r ./.docs/
	$(RM) -r ./.bins/
	$(RM) .depends


doc_install: doc
	$(MKDIR) $(PREFIX)/man
	cp -Rv doc/man/man* $(PREFIX)/man
	$(MKDIR) $(PREFIX)/doc/$(PRODUCTV)
	cp -Rv doc/html $(PREFIX)/doc/$(PRODUCTV)


FORCE:
