/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#include "../../src/comf.hxx"
using namespace comf;

class TestDemo : public Test
{
	public:
	
	TestDemo() {}

	void vrun()
	{
		bstream();
		tstream();
		exception();
	}

	

	protected:
	
	void bstream()
	{
		std::string filename = Format("/tmp/comf_test/%$-data.bin") % utod(getpid());
		FileMappingDynamicSegment fmds(filename.c_str(),true,0644,1024*1024);
		BOStorage bos(fmds);
	
		bos << std::string("test");
		bos << BOStorage::BEGIN << 0x77 << BOStorage::END;

	}


	void tstream()
	{
		std::string filename = Format("/tmp/comf_test/%$-data.txt") % utod(getpid());
		FileMappingDynamicSegment fmds(filename.c_str(),true,0644,1024*1024);
		TOStorage tos(fmds);
	
		tos << TOStorage::DEC;
		tos << std::string("test") << TOStorage::NL;
		tos << "fixed";
		tos << TOStorage::BEGIN << 77 << TOStorage::END;
		tos << TOStorage::POP;

	}


	void exception()
	{
		puts("# exception stack trace BEGIN");
		try
		{
			COMF_THROWCOMFEXCEPTION("test text");
		}
		catch(const Exception & ex)
		{
			ex.printStackTrace(stdout,"## ");
		}
		puts("# exception stack trace END");
	}
			




};

static TestDemo s_test_demo;

Test * test_demo()
{
	return &s_test_demo;
}
