/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#ifndef COMF_TSTORAGE_HXX
#define COMF_TSTORAGE_HXX

#include <stack>

#include "object.hxx"
#include "mystd.hxx"


COMF_NS_BEGIN


class TIStorage : public Entity
{
	public:
	TIStorage(const ConstSegment &);
	virtual ~TIStorage();

	enum Cmd {BEGIN,END,ABORT};

	TIStorage & operator >> (Serializable &);

	TIStorage & operator >> (char &);
	TIStorage & operator >> (unsigned char &);
	TIStorage & operator >> (short &);
	TIStorage & operator >> (unsigned short &);
	TIStorage & operator >> (int &);
	TIStorage & operator >> (unsigned int &);
	TIStorage & operator >> (long &);
	TIStorage & operator >> (unsigned long &);

	TIStorage & operator >> (double &);
	TIStorage & operator >> (bool &);
	TIStorage & operator >> (std::string &);
	
	#ifdef MAKROZ_HASWIDE
	TIStorage & operator >> (std::wstring &);
	#endif

	TIStorage & operator >> (const char *);
	TIStorage & operator >> (Cmd);
	
	void checkSignature();
			
	
	protected:
	char read();
	char peek();
	void eatWhite();
	
	
	private:
	const ConstSegment & _data;
	size_t _ptr;
	std::vector<char> _nesting;
	char qread();
	char qpeek();
	const char * ptr() const;
	void qskip(size_t);
	void qskip();

};


class TOStorage : public Entity
{
	public:
	TOStorage(DynamicSegment &);
	virtual ~TOStorage();

	enum Cmd {POP,NL,BLANK,BEGIN,END};
	enum Radix {DEC,HEX,BIN};
	
	TOStorage & operator << (const Serializable &);

	TOStorage & operator << (char);
	TOStorage & operator << (unsigned char);
	TOStorage & operator << (short);
	TOStorage & operator << (unsigned short);
	TOStorage & operator << (int);
	TOStorage & operator << (unsigned int);
	TOStorage & operator << (long);
	TOStorage & operator << (unsigned long);	
	
	TOStorage & operator << (double);
	TOStorage & operator << (bool);
	TOStorage & operator << (const std::string &);
	
	#ifdef MAKROZ_HASWIDE
	TOStorage & operator << (const std::wstring &);
	#endif

	TOStorage & operator << (const char *);
	TOStorage & operator << (Cmd);
	TOStorage & operator << (Radix);

	void writeSignature();

	protected:
	void write(char);
	void write(const char *);

	/*
	void throws(const char * exc, const char * file, int line);
	void throws(const char *);
	*/

	private:
	DynamicSegment & _data;
	size_t _ptr;
	std::stack<Radix> _radix;
	std::stack<char> _nesting;
	bool _needspaceafter;
	bool _newline;
	bool _error;
	
	void qwrite(char);
	void qwrite(const char *);	
	char * ptr() const;
	void qskip(size_t);
	void qreserve(size_t);
	void indent();
};



template <class X, class Y> TOStorage & operator << (TOStorage & s, const std::pair<X,Y> & a)
{
	return s << "(" << a.first << "," << a.second << ")";
}

template <class X, class Y> TIStorage & operator >> (TIStorage & s, std::pair<X,Y> & a)
{
	return s >> "(" >> a.first >> "," >> a.second >> ")";
}



template <class T> TOStorage & operator <<(TOStorage & s, const std::vector<T> & a)
{
	s << "@[" << a.size() << "]" << s.BEGIN;
	typename std::vector<T>::const_iterator it;
	COMF_ITERATEX(it,a) s << s.NL << *it << ";";
	s << s.END;
	return s;
}




template <class T> TIStorage & operator >>(TIStorage & s, std::vector<T> & a)
{
	size_t z;
	s >> "@ [" >> z >> "]" >> s.BEGIN;
	a.resize(z);
	typename std::vector<T>::iterator it;
	COMF_ITERATEX(it,a) s >> *it >> ";";
	s >> s.END;
	return s;
}





COMF_NS_END

#endif
