/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#include <string>

#include "memory.hxx"
#include "string.hxx"


COMF_NS_BEGIN

//**** ConstSegment

void ConstSegment::dump(FILE * f) const
{
	const int dw = 58;
	
	const std::string s1 = Format("--dump--: ptr = %$ : size = %$ ")
		% ptoa(cptr()) % utox(size());
	
	const std::string s2 = ljus(s1,dw,'-');
	fprintf(f,s2.data());

	for(size_t j=0; j<size(); ++j)
	{
		if(j%16==0) fprintf(f,"\n%08X: ",j);
		fprintf(f,"%02X ",static_cast<unsigned char>(cptr()[j]));
	}
	
	const std::string s3("--end---");
	const std::string s4 = ljus(s3,dw,'-');
	fprintf(f,"\n%s\n",s4.data());
}

//**** Memory

const size_t Memory::_s_minsize = 12;

Memory::Memory()
{
	_size = 0;
	_allocsize = _s_minsize;
	_ptr = malloc(_allocsize);
}

Memory::Memory(size_t z)
{
	_size = z;
	_allocsize = std::max(z,_s_minsize);
	_ptr = malloc(_allocsize);
}

Memory::~Memory()
{
	free(_ptr);
}

Memory::Memory(const ConstSegment & a)
{
	_size = a.size();
	_allocsize = std::max(_size,_s_minsize);
	_ptr = malloc(_allocsize);
	memcpy(_ptr,a.cptr(),_size);
}


Memory & Memory::operator = (const ConstSegment & a)
{
	COMF_ASSERT(this!=&a);
	free(_ptr);
	_size = a.size();
	_allocsize = std::max(_size,_s_minsize);
	_ptr = malloc(_allocsize);
	memcpy(_ptr,a.cptr(),_size);
	return *this;
}

size_t Memory::size() const
{
	return _size;
}

const char * Memory::cptr() const
{
	return static_cast<const char*>(_ptr);
}

char * Memory::ptr() const
{
	return static_cast<char *>(_ptr);
}

void Memory::resize(size_t n)
{
	if(n==size()) return;
	if(n > _allocsize)
	{
		_allocsize = n+n/2;
		_ptr = realloc(_ptr, _allocsize);
	}
	else
	{
		if(n<_allocsize/2 && _allocsize>_s_minsize)
		{
			_allocsize = std::max(n+n/2,_s_minsize);
			_ptr = realloc(_ptr, _allocsize);
		}
	};
	_size = n;
}

void Memory::clear(size_t n)
{
	if(n==size()) return;
	if(n > _allocsize)
	{
		free(_ptr);
		_allocsize = n+n/2;
		_ptr = malloc(_allocsize);
	}
	else
	{
		if(n<_allocsize/2 && _allocsize>_s_minsize)
		{
			free(_ptr);
			_allocsize = std::max(n+n/2,_s_minsize);
			_ptr = malloc(_allocsize);
		}
	};
	_size = n;
}


void Memory::clear()
{
	if(size())
	{
	 	free(_ptr);
		_allocsize = _s_minsize;
		_ptr = malloc(_allocsize);
		_size = 0;
	};
}

void Memory::serialize(BOStorage &) const {COMF_TODO;}
void Memory::serialize(BIStorage &) {COMF_TODO;}
void Memory::serialize(TOStorage &) const {COMF_TODO;}
void Memory::serialize(TIStorage &) {COMF_TODO;}


#if 0
void Memory::Serialize(BOStream & s) const
{
	s << Size();
	s.Write(ConstPtr(),Size());
}

void Memory::Serialize(BIStream & s)
{
	size_t sz;
	s >> sz;
	ClearReSize(sz);
	s.Read(Ptr(),sz);
}

void Memory::Serialize(TOStream & s) const
{
	s << _T("Memory[") << Size() << _T("]") << TOStream::e_BeginBlock;
	s.PushRadix(TOStream::e_Hex);
	size_t n;
	LOOP(n,Size())
	{
		s << (DWORD)ConstPtr()[n];
		if((n%16 == 15) && (n+1<Size())) s << TOStream::e_EOL;
	};
	s.PopRadix();
	s << TOStream::e_EndBlock;
}

void Memory::Serialize(TIStream & s)
{
	size_t n;
	s >> _T("Memory [") >> n >> _T("]") >> TIStream::e_BeginBlock;
	ClearReSize(n);
	LOOP(n,Size())
	{
		DWORD k;
		s >> k;
		ASSERT(INCC(k,0,UCHAR_MAX));
		Ptr()[n] = (BYTE)k;
	};
	s >> TIStream::e_EndBlock;
}

#endif


COMF_NS_END

