/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#ifndef COMF_LIBINFO_HXX
#define COMF_LIBINFO_HXX

#include <vector>
#include <string>

#include "types.hxx"
#include "object.hxx"

COMF_NS_BEGIN

class LibInfo
{
	public:
	LibInfo(
		const std::string & product, 
		int version, int release, int build,
		const std::string & timestamp,
		const std::string & author,
		bool debug
		) :
		_product(product),
		_version(version),
		_release(release),
		_build(build),
		_timestamp(timestamp),
		_author(author),
		_debug(debug)
	{
	}

	void regthis() const;

	std::string format() const;
	void print(FILE * f = stderr) const;
	
	static const std::vector<LibInfo> & queryList();
	static void printList(FILE * f = stderr);
	
	protected:
	std::string _product;
	int _version;
	int _release;
	int _build;
	std::string _timestamp;
	std::string _author;
	bool _debug;
	
	private:
	static std::vector<LibInfo> _list;
	
};


class LibInfoRegister : public Entity
{
	public:
	LibInfoRegister(const LibInfo &);
	virtual ~LibInfoRegister() {}
};




COMF_NS_END



// use this macro in main header file of your library (product.hxx)
#define COMF_DECLARE_LIBINFO(PRDOUCT)		\
namespace PRODUCT							\
{											\
	const COMF_NS::LibInfo & libinfo();		\
}											\
	
// use this macro once in main source file of your library (product.cxx)
#define COMF_IMPLEMENT_LIBINFO(AUTHOR)									\
namespace MAKROZ_PRODUCT												\
{																		\
	static COMF_NS::LibInfo	s_libinfo									\
	(																	\
		MAKROZ_PRODUCTSTR,												\
		MAKROZ_VERSION, MAKROZ_RELEASE, MAKROZ_BUILDNR,					\
		MAKROZ_TIMESTAMP,												\
		AUTHOR,															\
		MAKROZ_DEBUG													\
		);																\
	const COMF_NS::LibInfo & libinfo() {return s_libinfo;}				\
	COMF_NS::LibInfoRegister libreg(libinfo());							\
}																		\


#endif
