/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#ifndef COMF_INTEGER_HXX
#define COMF_INTEGER_HXX

#include "defs.hxx"

COMF_NS_BEGIN

unsigned int powerof2(int n);
bool ispowerof2(unsigned int);
unsigned int nextpowerof2(unsigned int);
int log2sup(unsigned int n, bool * exact = 0);

//! Sign
/*! -1 or 0 or +1 */
template <class T> int sgn(const T & x)
{
 	if (x>0) return 1;
 	if (x<0) return -1;
 	return 0;
}

//! Absolute value by type
template <class T> T absT(const T & x)
{
 	return (x>=0 ? x : -x);
}

//! Square
template <class T> T sqr(const T & x)
{
 	return x * x;
}

//! Exchange
template <class T> void xchg(T & a, T & b)
{
 	T c;
 	c=a,a=b,b=c;
}


template <typename T> bool inoo(T x, T a, T b)
{
	return (x> a)&&(x< b);
}

template <typename T> bool inco(T x, T a, T b)
{
	return (x>=a)&&(x< b);
}

template <typename T> bool inoc(T x, T a, T b)
{
	return (x> a)&&(x<=b);
}

template <typename T> bool incc(T x, T a, T b)
{
	return (x>=a)&&(x<=b);
}

template <> double absT(const double & x);


COMF_NS_END





#endif
