/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#include "integer.hxx"

COMF_NS_BEGIN

unsigned int powerof2(int n)
{
	if(n<0) return 0;
	return 1 << n;
}

bool ispowerof2(unsigned int n)
{
	while(n>1)
	{
		if(n&1) return false;
		n = n>>1;
	}
	return true;
}

unsigned int nextpowerof2(unsigned int n)
{
	return powerof2(log2sup(n,0));
}
	



int log2sup(unsigned int n, bool * exact)
{
	if(exact) *exact = true;
	if(n==0) return -1;
	int c = 0;	
	while(n)
	{
		if(exact && n&1 && n>1) *exact = false;
		n = n>>1;
		++c;
	}
	return c;
}	


COMF_NS_END
