/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#ifndef COMF_GLOBALS_HXX
#define COMF_GLOBALS_HXX

#include <vector>

#include "defs.hxx"
#include "types.hxx"

COMF_NS_BEGIN


void assertdbg(bool condition, const char * description, const char * file, int line);

std::vector<std::string> stacktrace(size_t n = 4096);

const char * zeldan();
const char * gpl();

void openlog(const char * ident = 0);
void logerror(const std::string &);




inline unsigned char unsign(char a) {return static_cast<unsigned char>(a);}
inline unsigned short unsign(short a) {return static_cast<unsigned short>(a);}
inline unsigned int unsign(int a) {return static_cast<unsigned int>(a);}
inline unsigned long unsign(long a) {return static_cast<unsigned long>(a);}

inline unsigned char unsign(unsigned char a) {return a;}
inline unsigned short unsign(unsigned short a) {return a;}
inline unsigned int unsign(unsigned int a) {return a;}
inline unsigned long unsign(unsigned long a) {return a;}

#ifndef _LP64
inline unsigned long long unsign(long long a) {return static_cast<unsigned long long>(a);}
inline unsigned long long unsign(unsigned long long a) {return a;}
#endif

COMF_NS_END

#endif

