/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#include <syslog.h>
#include <signal.h>

#ifdef __linux__
#include <execinfo.h>
#include <cxxabi.h>
#endif

#include "globals.hxx"

#include "libinfo.hxx"
#include "string.hxx"
#include "mystd.hxx"


COMF_NS_BEGIN


static bool s_openlog = false;

const char * zeldan()
{
	return "\033[1;31mz\033[1;33me\033[1;32ml\033[1;36md\033[1;34ma\033[1;35mn\033[0;39m";
}

const char * gpl()
{
	return
	"This program is free software; you can redistribute it and/or modify \n"
	"it under the terms of the GNU General Public License as published by \n"
	"the Free Software Foundation; either version 2 of the License, or \n"
	"(at your option) any later version. \n"
	" \n"
	"This program is distributed in the hope that it will be useful, \n"
	"but WITHOUT ANY WARRANTY; without even the implied warranty of \n"
	"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the \n"
	"GNU General Public License for more details. \n"
	" \n"
	"You should have received a copy of the GNU General Public License \n"
	"along with this program; if not, write to the Free Software \n"
	"Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA \n";
}

void openlog(const char * ident)
{
	if(s_openlog) return;
	int opt = LOG_CONS|LOG_PID;
	#ifndef NDEBUG
	opt |= LOG_PERROR;	
	#endif
	::openlog(ident?ident:MAKROZ_PRODUCTSTR,opt,LOG_USER);
	s_openlog = true;	
}

void logerror(const std::string & s)
{
	syslog(LOG_ERR,s.data());
}



void assertdbg(bool c, const char * d, const char * f, int l)
{
	if(!c)
	{
		fprintf(stderr,"ASSERT(%s) : %s(%d)\n",d,f,l);
		std::vector<std::string> s = stacktrace();
		fputs("[\n",stderr);
		COMF_CITERATE(std::vector<std::string>,it,s)
			fprintf(stderr,"\t%s\n",it->data());
		fputs("]\n",stderr);
		
		raise(SIGABRT);
	}

}

#if defined(__linux__) && !defined(MAKROZ_STATIC)
std::vector<std::string> stacktrace(size_t t)
{
	void ** stack = static_cast<void**>(malloc(t*sizeof(void*)));
	int n = backtrace(stack,t);
	std::vector<std::string> retval;
	char ** names = backtrace_symbols(stack,n);
	
	for(int j=0; j<n; ++j)
	{
		const char * name = names[j];
		int a1 = 0;
		while(name[a1]!='(') ++a1;
		int a2 = a1;
		while(name[a2]!='+') ++a2;
		int a3 = a2;
		while(name[a3]!=')') ++a3;

		char file[a1+16];
		strncpy(file,name,a1);
		file[a1]=0;
		
		char func[a2-(a1+1)+16];
		strncpy(func,name+a1+1,a2-(a1+1));
		func[a2-(a1+1)]=0;
		
		char line[a3-(a2+1)+16];
		strncpy(line,name+a2+1,a3-(a2+1));
		line[a3-(a2+1)]=0;
		
		unsigned int iline = strtoul(line+2,0,16);
		
		int status = -1;
		size_t length = strlen(func) * 2 + 256;
		char deman[length];
		if(strcmp(func,"main"))
			__cxxabiv1::__cxa_demangle(func,deman,&length,&status);
		
		if(!status && !strcmp(deman,"comf::stacktrace(unsigned)")) continue;
		retval.push_back(Format("%$(%$+%$)%$") 
			% file 
			% (status ? func : deman) 
			% utod(iline) 
			% (name+a3+1)
			);
	}

	free(names);
	
	return retval;

}
#else
std::vector<std::string> stacktrace(size_t)
{
	std::vector<std::string> a;
	a.push_back("???");
	return a;
}
#endif


COMF_NS_END


