/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id: exception.cxx,v 1.2 2006/01/02 22:08:04 zeldan Exp $

#include <syslog.h>

#include "exception.hxx"

#include "string.hxx"
#include "globals.hxx"
#include "mystd.hxx"


COMF_NS_BEGIN

//--------------------- Exception


const std::string Exception::text() const
{
	if(_line>=0)
		return Format("%$ : %$(%$)") % vtext() % _file % itod(_line);
	else
		return vtext();
}



void Exception::logit(int level) const
{
	syslog(level,"%s",text().data());
}


void Exception::printStackTrace(FILE * file, const char * prefix) const
{
	COMF_CITERATE(std::vector<std::string>,it,_stack)
		fprintf(file, "%s%s\n", prefix, it->data());
}



//---------------------- ErrException


std::string ErrException::vtext() const
{
	return Format("ErrException : %$ (%$)") % strerror(_err) % itod(_err);
}



//------------------- COMFException


std::string COMFException::vtext() const
{
	return _text;
}


COMF_NS_END
