/*
**  RulesetManager.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**          Bjoern Giesler <bjoern@giesler.de>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CodeEditorBundle_H_RulesetManager
#define _CodeEditorBundle_H_RulesetManager

#include <Foundation/NSObject.h>
#include <Foundation/NSArray.h>
#include <AppKit/NSColor.h>
#include <AppKit/NSFontManager.h>

@class NSMutableDictionary;
@class NSFont;

@interface NSColor (RulesetManager)
+ (NSColor *)colorWithRGBAArray: (NSArray *) array;
@end

@interface NSArray (RulesetManager)
+ (NSArray *) arrayWithColor: (NSColor *) color;
@end

@interface RulesetManager: NSObject
{
  NSMutableArray *allNames;
  NSMutableDictionary *fontAttributes;
  NSMutableDictionary *fontDefaults;
//  NSFont *normalFont; /* Cache normal font */
}

/* Automatically call -loadFontAttributesFromUserDefuaults
 * and -buildFontAttributes
 */
+ (RulesetManager *) sharedRulesetManager;

/* Type can be "Comments", "Strings", "Preprocessor", etc. */
- (NSDictionary *) attributesForType: (NSString *) type;

- (void) setColor: (NSColor *) color forType: (NSString *) type;
- (void) setNormalFont: (NSFont *) font;
- (NSFont *) normalFont;
- (void) setTrait: (NSFontTraitMask) mask forType: (NSString *) type;
- (void) setFont: (NSFont *) font forType: (NSString *) type;

- (NSColor *) colorForType: (NSString *) type;
- (NSFont *) fontForType: (NSString *) type;
/* font can be nil. It will use userFixedPitchFont and systemFontSize */
//- (NSFont *) convertFont: (NSFont *) font toType: (NSString *) type;

/* The key is "CodeFontificationAttributes".
 * It will read/write fontDefaults from/into user defaults.
 */
/* Will -buildFontAttributes automatically */
- (BOOL) loadFontAttributesFromUserDefaults;
- (void) writeFontAttributesToUserDefaults;

/* build ready-to-use font attributes from fontDefaults.
 * use this after -setColor: -setFont:
 */
- (void) buildFontAttributes;

@end

#endif /* _CodeEditorBundle_H_RulesetManager */

