/*
**  CodeEdivorViewPreference.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**          Bjoern Giesler <bjoern@giesler.de>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CodeEditorBundle_H_CodeEditorViewPreference
#define _CodeEditorBundle_H_CodeEditorViewPreference

#include <Foundation/NSObject.h>

@interface CodeEditorViewPreference: NSObject
{
  NSString *tab, *tabString;
  float fontifyInterval;
  unsigned fontifyThreshold;
  BOOL autoFontification;
  BOOL autoFontificationThreshold;
  BOOL autoFontificationEachLine;
  BOOL autoIndentation;
  BOOL autoMarkBlock;
  BOOL autoMarkThreshold;
  unsigned markThreshold;
  
  BOOL displaySideView;
}

+ (CodeEditorViewPreference *) sharedCodeEditorViewPreference;

/* Display side view */
- (void) setDisplaySideView: (BOOL) bool;
- (BOOL) displaySideView;

/* Either a number or "Tab" or "Auto" */
- (void)setTab: (NSString *)tab;
- (NSString *) tab;

/* "\t", or "   " (any spaces), or nil for auto-indentation */
- (NSString *) tabString;

/* Use automatically fontification every given interval */
- (void) setAutoFontification: (BOOL) bool;
- (BOOL) autoFontification;
/* Set the interval for automatically fontification */
- (void) setFontificationInterval: (float)interval;
- (float) fontificationInterval;
/* Not to automatically fontification if over a given threshold */
- (void) setAutoFontificationThreshold: (BOOL) bool;
- (BOOL) autoFontificationThreshold;
/* Set the threshold limit for automatically fontification */
- (void) setFontificationThreshold: (unsigned) threshold;
- (unsigned) fontificationThreshold;
/* Automatically fontification each line */
- (void) setAutoFontificationEachLine: (BOOL) bool;
- (BOOL) autoFontificationEachLine;

/* Use automatically indentation */
- (void) setAutoIndentation: (BOOL) bool;
- (BOOL) autoIndentation;

/* Use automatically mark blocks */
- (void) setAutoMarkBlock: (BOOL) bool;
- (BOOL) autoMarkBlock;
/* Not to automatically mark blocks if over a give threshold */
- (void) setAutoMarkThreshold: (BOOL) bool;
- (BOOL) autoMarkThreshold;
/* Set the threshold limit for automatically mark blocks */ 
- (void) setMarkThreshold: (unsigned) threshold;
- (unsigned) markThreshold;

@end

#endif /* _CodeEditorBundle_H_CodeEditorViewPreference */

