/*
**  CodeEditorView.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**          Bjoern Giesler <bjoern@giesler.de>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CodeEditorBundle_H_CodeEditorView
#define _CodeEditorBundle_H_CodeEditorView

#include <AppKit/NSTextView.h>
#include <Foundation/NSRange.h>
#include "BlockHandler.h"

@class NSString;
@class NSDictionary;
@class NSArray;
@class NSColor;
@class NSBezierPath;
@class NSEvent;
@class CodeEditorViewPreference;
@class CEViewTypesetter;
@class CEViewLayoutManager;

typedef enum 
{
  CETTCode,
  CETTText
} CETextType;

@interface CodeEditorView: NSTextView
{
  /* Document */
  CETextType textType;
  BOOL documentEdited; /* When document is edited, and need to save */

  /* Language */
  NSString *languageName;
  NSMutableArray *bundleLanguages;
  NSArray *bundleNames;

  /* Mark Block */
  NSRange lastMarkedRange;
  NSRange markedStartRange, markedEndRange;
  NSColor *startColor, *endColor;
  BOOL hasBlockMarked; /* record any marked block */
  BOOL needsBlockMarked;
  BOOL hasSideMarked;
  NSRect sideMarkedRect;
  NSLayoutManager *layoutManager;

  /* Cache handler class */
  Class blockHandlerClass;
  Class fontificationHandlerClass;
  Class indentationHandlerClass;
  Class methodHandlerClass;

  /* Fontification */
  BOOL fontifying; /*  may from fontify or block marking */
  BOOL needsFontification;
  NSFont *normalFont; /* Cache normal font */

  /* Detect key-in. If so, skip automatically action (periodicTask) */
  BOOL userPressingKey;

  CodeEditorViewPreference *preference;
  
  /* Side View */
  BOOL hasSideTextView;

  /* Built-in text system */
  CEViewTypesetter *typesetter;
  CEViewLayoutManager *builtInLayoutManager;

  float lineHeight;
}

- (BOOL) isDocumentEdited;
- (void) setDocumentEdited: (BOOL) bool;

/* The full path of file */
- (NSString *)languageName;
- (void)setLanguageName: (NSString *)aLanguage;
- (NSArray *) supportedLanguages;

- (void)keyDown: (NSEvent *)anEvent;

/* Return NO if no match. Support RegEx. 
 * Will select the searched string.
 * Backward search will search string before the cursor.
 * Forward search will search string after the cursor.
 */
- (BOOL) searchString: (NSString *) string
             backward: (BOOL) backward
      caseInsensitive: (BOOL) caseInsensitive;

/* Manual Fontification */
- (void) fontification;
/* Manual Mark Block */
- (void) markBlockAroundCursor;
/* Manual show side view */
- (void) showSideTextView;

/* Scroll selected range to the top of visible view */
- (void) scrollSelectedRangeToTop: (id) sender;

@end

#endif /* _CodeEditorBundle_H_CodeEditorView */

