/*
**  CEView+Inspector.m
**
**  Copyright (c) 2002, 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**          Bjoern Giesler <bjoern@giesler.de>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "CodeEditorView.h"
#include "CEView+Inspector.h"

@implementation CodeEditorView (Inspector)

- (void) getNumberOfGlyphs: (int *) numGlyphs
                     lines: (int *) numLines
{
  unichar ch;
  int len, i;
  NSString *text = [self string];

  len = [text length];

  if(numGlyphs)
    (*numGlyphs) = len;

  if(numLines)
    {
      (*numLines) = 1;
      for(i = 0; i < len; i++)
        {
          ch = [text characterAtIndex: i];
          if ( (ch == 0x0A) || (ch == 0x0D) )
	    (*numLines)++;
        }
    }
}

- (void) getCursorPosOverall: (int *) overall
                      inLine: (int *) inLine
                      atLine: (int *) atLine
{
  int len, i;
  int inl, atl, lstart, pos;
  unichar ch;
  NSString *text = [self string];

  pos = [self selectedRange].location;
  if(overall)
    (*overall) = pos;

  if(!inLine && !atLine)
    return;
  
  len = [text length];

  atl = 1;
  lstart = 0;
  inl = 0;

  for (i = 0; i <= pos && i < len; i++)
    {
      ch = [text characterAtIndex: i];
      if ( ((ch == 0x0A) || (ch == 0x0D)) && (i < pos) ) 
	{
	  atl++;
	  lstart = i;
	}
      else if (i == pos)
	inl = i - lstart - 1;
    }

  if (inl == -1)
    inl = 0;

  if(inLine) (*inLine) = inl;
  if(atLine) (*atLine) = atl;
}

- (void) gotoLineNum: (int) lineNum charInLine: (int) charInLine
{
  int len, i, j = 0;
  int atl;
  unichar ch;
  NSString *text = [self string];

  len = [text length];

  atl = 1;

  for (i = 0; i < len; i++)
    {
      ch = [text characterAtIndex: i];

      if( (ch == 0x0A) || (ch == 0x0D) )
        {
          atl++;
        }

      if(atl == lineNum)
        {
          for(j = i; j < len; j++)
            {
              if((j - i) == charInLine) 
                {
                  [self setSelectedRange: NSMakeRange(j + 1, 0)];
                  return;
                }
	    }
	}
    }
}

@end
