/*
**  ToolbarView.m
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "ToolbarView.h"
#include <AppKit/AppKit.h>

@implementation ToolbarView 

- (id) initWithFrame: (NSRect) frame
{
  NSRect rect;
  NSTextField *gotoLabel;

  self = [super initWithFrame: frame];

  rect = NSMakeRect(5, 5, 60, ToolbarHeight-10);
  searchButton = [[NSButton alloc] initWithFrame: rect];
  [searchButton setStringValue: _(@"Search:")];
  [self addSubview: searchButton];
  RELEASE(searchButton);

  rect = NSMakeRect(70, 5, 120, ToolbarHeight-10);
  searchField = [[NSTextField alloc] initWithFrame: rect];
  [self addSubview: searchField];
  RELEASE(searchField);

  rect = NSMakeRect(200, 5, 60, ToolbarHeight-10);
  gotoLabel = [[NSTextField alloc] initWithFrame: rect];
  [gotoLabel setStringValue: _(@"Goto Line:")];
  [gotoLabel setEditable: NO];
  [gotoLabel setSelectable: NO];
  [gotoLabel setBezeled: NO];
  [gotoLabel setDrawsBackground: NO];
  [self addSubview: gotoLabel];
  RELEASE(gotoLabel);

  rect = NSMakeRect(270, 5, 60, ToolbarHeight-10);
  gotoField = [[NSTextField alloc] initWithFrame: rect];
  [self addSubview: gotoField];
  RELEASE(gotoField);

  [searchButton setNextKeyView: searchField];
  [searchField setNextKeyView: gotoField];
  [gotoField setNextKeyView: searchField];

  return self;
}

- (void) dealloc
{
/*
  RELEASE(searchButton);
  RELEASE(searchField);
  RELEASE(gotoField);
  RELEASE(browserButton);
  RELEASE(interfaceButton);
*/
  [super dealloc];
}

- (NSButton *) searchButton
{
  return searchButton;
}

- (NSTextField *) searchField
{
  return searchField;
}

- (NSTextField *) gotoField
{
  return gotoField;
}

/*
- (NSButton *) browserButton
{
  return browserButton;
}

- (NSButton *) interfaceButton
{
  return interfaceButton;
}
*/

@end
