/*
**  PreferenceManager.h
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CodeEditor_H_PreferenceManager
#define _CodeEditor_H_PreferenceManager

#include <Foundation/Foundation.h>

@class NSTextField;
@class NSButton;
@class NSPanel;
@class NSTabView;

@interface PreferenceManager : NSObject
{
  /* preferences cache*/
  NSString *tab;
  BOOL autoMarkBlock;
  BOOL autoFontify;
  BOOL autoFontifyWhenTyping;
  BOOL autoMarkThreshold;
  BOOL autoFontifyThreshold;
  unsigned autoMarkThresholdCharacters;
  float autoFontifyInterval;
  unsigned autoFontifyThresholdLines;
  BOOL autoIndent;
  BOOL displaySideView;

  /* outlet */
  /* Edit */
  NSTextField *insertSpaceField;
  NSButton *insertSpaceButton;
  NSButton *insertTabButton;
  NSButton *insertAutoIndentButton;

  NSButton *autoMarkBlockButton;
  NSButton *autoMarkThresholdButton;
  NSTextField *autoMarkThresholdField;

  NSButton *autoIndentButton;
  
  /* Format */
  NSButton *autoFontifyButton;
  NSButton *autoFontifyThresholdButton;
  NSButton *autoFontifyWhenTypingButton;
  NSTextField *autoFontifyField;
  NSTextField *autoFontifyThresholdField;
  
  /* Display */
  NSButton *displaySideViewButton;

  NSPanel *preferencePanel;
  NSTabView *tabView;
}

+ (PreferenceManager *) sharedPreferenceManager;

- (NSPanel *) preferencePanel;
- (BOOL) runModalPreferencePanel: (id) sender;

- (void) radioButtonAction: (id) sender;
- (void) insertSpaceAction: (id) sender;
- (void) autoMarkBlockAction: (id) sender;
- (void) autoFontifyAction: (id) sender;
- (void) revertToSaved: (id) sender;
- (void) revertEdit: (id) sender;
- (void) revertFormat: (id) sender;
- (void) revertDisplay: (id) sender;

- (NSTextField *) insertSpaceField;
- (NSButton *) insertSpaceButton;
- (NSButton *) insertTabButton;
- (NSButton *) insertAutoIndentButton;
- (NSButton *) autoMarkBlockButton;
- (NSButton *) autoMarkThresholdButton;
- (NSTextField *) autoMarkThresholdField;
- (NSButton *) autoIndentButton;
- (NSButton *) autoFontifyButton;
- (NSButton *) autoFontifyThresholdButton;
- (NSTextField *) autoFontifyField;
- (NSTextField *) autoFontifyThresholdField;
- (NSButton *) autoFontifyWhenTypingButton;
- (NSButton *) displaySideViewButton;
@end

#endif /* _CodeEditor_H_PreferenceManager */
