/*
**  Inspector.h
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CodeEditor_H_Inspector
#define _CodeEditor_H_Inspector

#include <Foundation/Foundation.h>

@class NSPanel;
@class NSTextField;
@class NSButton;
@class NSBox;
@class NSPopUpButton;
@class CodeEditorView;

@interface Inspector : NSObject
{
  CodeEditorView *currentCEView;

  /* Inspector Panel */
  NSPanel *inspectorPanel;
  NSBox *languageBox, *sizeBox, *cursorBox;
  NSTextField *filenameField, *pathField;
  NSButton *showButton;
  NSPopUpButton *languageButton;
  NSTextField *lineField, *charField, *overallField;
  NSTextField *linesField, *bytesField;
}

+ (Inspector *) sharedInspector;

- (NSPanel *) inspectorPanel;
- (void) orderFrontInspectorPanel: (id) sender;

- (void) setCodeEditorView: (CodeEditorView *) ceView;

/* Inspector Panel */
- (void) gotoChar: (id) sender;
- (void) gotoCharAndLine: (id) sender;
- (void) showInWorkspace: (id) sender;
- (void) setLanguage: (id) sender;

@end

#endif /* _CodeEditor_H_Inspector */
