/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KOKMAINWIDGET_H
#define KOKMAINWIDGET_H

#include <qwidget.h>
#include "common.h"
#include "qvaluevector.h"
#include "qstringlist.h"
#include "searchrequest.h"
#include "searchresult.h"
#include "qtabbarext.h"
#include <qlistbox.h>
#include <qtextedit.h>
#include "cockpref.h"

/**
Main widget responsible of showing the list of available cocktails and 
managing the actions made by the user.
*/
class kokMainWidget : public QWidget
{
Q_OBJECT
public:
	kokMainWidget(QWidget *parent = 0, const char *name = 0);

	~kokMainWidget();
	void saveOptions();

public slots:
	virtual void fileNew();
	virtual void fileOpen();
	virtual void fileSave();
	virtual void fileSaveAs();
	virtual void filePrint();
	virtual void fileExit();
	virtual void editUndo();
	virtual void editRedo();
	virtual void editCut();
	virtual void itemHighlighted( const QString & str );
	virtual void editPaste();
	///Modify the user preferences
	virtual void editPref();
	virtual void editFind();
	virtual void helpIndex();
	virtual void helpContents();
	virtual void helpAbout();
	virtual void newSearchRequest( searchRequest sr );
	virtual void newTabSelected( int id );
	virtual void closeAllTab();
	virtual void newTabSelected( QString str );
	virtual void closeThisTab( QString name );
	virtual void closeAllOther( QString name );
	void setPref(cockPref pref);
	///Return the total number of recipes
	int getNbRecipes();

signals:
	void displayMessage(QString);

protected:
	QWidget * parent;
	QMap<QString, recipe *> dicoAll;
	QValueVector<recipe *> allRecipes;
	dicoRecipe dicoFind;
	QStringList * allNames;
	QValueVector<searchResult> searches;
	QStringList * allElementsName;

	QListBox * nameListBox;
	QTabBarExt * tabWidget;
	QTextEdit * recipeAllTextEdit;
	///The user prefered units for displaying the recipes of the cocktails(cl, oz,...)
	units userUnits;
	double userRounding;
	///The total number of recipes loaded
	int nbRecipes;
};

#endif
