/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rm.h"

RM::RM()
{
}


RM::~RM()
{
}


setRecipe RM::getSetOfRecipeContaining(dicoRecipe dico, QStringList names, bool all)
{
	setRecipe  recipesSet, tempSet;
	bool firstSet = true;
	for ( QStringList::Iterator it = names.begin(); it != names.end(); ++it ) {
		if(dico.find(*it) != dico.end()){
			if (all){
				if (firstSet){
					recipesSet=(*(dico.find(*it)));
					firstSet=false;
				}
				//we make the intersection between the two sets
				set_intersection((*(dico.find(*it))).begin() ,(*(dico.find(*it))).end(), recipesSet.begin(), recipesSet.end() ,insert_iterator<setRecipe>(tempSet,tempSet.begin()));
				recipesSet=tempSet;
				tempSet.erase(tempSet.begin(),tempSet.end());
				cerr << "making one intersection, the new size of the possible set is "<< recipesSet.size()<<endl;
			}
			else{  //we make the union between the two sets
				set_union((*(dico.find(*it))).begin() ,(*(dico.find(*it))).end(), recipesSet.begin(), recipesSet.end() ,insert_iterator<setRecipe>(tempSet,tempSet.begin()));
				recipesSet=tempSet;
				tempSet.erase(tempSet.begin(),tempSet.end());
			}
		}
		else
			if (all){ //we return an empty set
				setRecipe emptySet;
				return emptySet;
			}
	}
	return recipesSet;
}

QStringList RM::toStringList(setRecipe recipes)
{
	QStringList results;
	setRecipe::iterator i;
	for (i=recipes.begin(); i!=recipes.end();++i){
		results.push_back((*i)->getName());
	}
	return results;
}

QStringList RM::getRecipeContaining(dicoRecipe dico, QStringList names, bool all)
{
	return RM::toStringList(RM::getSetOfRecipeContaining(dico,names,all));
}

QStringList RM::getRecipeContaining(dicoRecipe dico, QStringList names, QStringList namesWhitout, bool all)
{
	setRecipe s1,s2,s3;
	s1=RM::getSetOfRecipeContaining(dico,names,all);
	s2=RM::getSetOfRecipeContaining(dico,namesWhitout,false);

	//making s1-s2
	set_difference(s1.begin(), s1.end(), s2.begin(), s2.end(), insert_iterator<setRecipe>(s3,s3.begin()) );

	cerr << s1.size() <<" " <<s2.size()<<" " <<s3.size()<<endl;
	return RM::toStringList(s3);
}

QStringList RM::getListOfElementsName(QMap<QString, setRecipe > * dicoFind)
{
	QStringList names;
	QMap<QString, setRecipe >::iterator it;
	for ( it = dicoFind->begin(); it != dicoFind->end(); ++it ) {
		names.append(it.key().latin1());
	}
	return names;
}
