/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QTABBAREXT_H
#define QTABBAREXT_H

#include <qtabbar.h>
#include <qevent.h>
#include <qstring.h>
/**
An extended Tab Bar in order to provide the user a menu to close tabs
*/
class QTabBarExt : public QTabBar
{
Q_OBJECT
public:
	QTabBarExt();

	~QTabBarExt();
	QTabBarExt( QWidget * parent = 0, const char * name = 0 );
	void contextMenuEvent( QContextMenuEvent * e );

public slots:
	void closeThis();
	void closeAll();
	void closeAllOther();

signals:
	void closeThisTab(QString);
	void closeAllTab();
	void closeAllOtherTab(QString);
protected:
	//the tab selected by the user
	QTab * ctab;
};

#endif
