/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qtabbarext.h"
#include "common.h"
#include <qpopupmenu.h>
#include <qcursor.h>
#include <qpoint.h>

QTabBarExt::QTabBarExt( QWidget * parent, const char * name)
 :QTabBar(parent,name)
{
}


QTabBarExt::QTabBarExt()
 : QTabBar()
{
}


QTabBarExt::~QTabBarExt()
{
}

void QTabBarExt::contextMenuEvent( QContextMenuEvent * e ){
	cerr << "contextMenuEvent called" <<endl;
	QPopupMenu* pMainMenu = new QPopupMenu(this);

	//locating the QTab & updating ctab
	ctab= this->selectTab(QPoint(e->x(),e->y()));
	if (ctab==0)
		return;
	else{
		QString name = ctab->text();
		pMainMenu->insertItem( "Close this search", this, SLOT(closeThis()));
		pMainMenu->insertItem( "Close all searches", this,SLOT(closeAll()));
		pMainMenu->insertItem( "Close all other searches", this,SLOT(closeAllOther()));
		pMainMenu->exec( QCursor::pos() );
	}
}

void QTabBarExt::closeThis(){
	QString name = ctab->text();
	this->removeTab(ctab);
	emit closeThisTab(name);
}

void QTabBarExt::closeAll(){
	QPtrList<QTab> * tabList = this->tabList();
	QValueVector<QTab *>  toRemove;
	
	for (ctab=tabList->first() ; ctab ; ctab=tabList->next()){
		if (ctab->text()!="&All")
			toRemove.append(ctab);
	}

	for(unsigned i=0 ; i< toRemove.size();++i)
		this->removeTab(toRemove[i]);

	emit closeAllTab();
}

void QTabBarExt::closeAllOther(){
	QString name = ctab->text();
	QPtrList<QTab> * tabList = this->tabList();
	QValueVector<QTab *>  toRemove;

	for (ctab=tabList->first() ; ctab ; ctab=tabList->next()){
		if ((ctab->text()!="&All")&&(ctab->text()!=name))
			toRemove.append(ctab);
	}

	for(unsigned i=0 ; i< toRemove.size();++i)
		this->removeTab(toRemove[i]);

	emit closeAllOtherTab(name);
}
