/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "cocktailfileparser.h"
#include <qdom.h>
#include <qfile.h>
#include <iostream>
#include <qstringlist.h>

using namespace std;

cocktailFileParser::cocktailFileParser()
{
}


cocktailFileParser::~cocktailFileParser()
{
}


void cocktailFileParser::writeCocktailsToFile(QString fileName, QValueVector<recipe *>* recipes)
{
	cerr<< "start of the writing in the file "<<fileName<<endl;
	QDomImplementation impl = QDomDocument().implementation();
	 // document with document type
	QString name = "cocktails_list";
	QString publicId = QString::null;
	QString systemId = "cocktails_list.dtd";
	QDomDocument doc(impl.createDocumentType(name,publicId,systemId));
	doc.appendChild(doc.createComment("This file describe a list of cocktails"));
	doc.appendChild(doc.createTextNode("\n")); // for nicer output
	QDomElement root = doc.createElement( "cocktails_list" );
	doc.appendChild( root );
	   
	for(unsigned i=0 ; i< recipes->size() ; ++i){
		//creation of a recipe element
		recipe * rece = (*recipes)[i];
		QDomElement nrecipe = doc.createElement( "recipe" );
		nrecipe.setAttribute( "name", (rece)->getName() );
		if (rece->getProportional()==true)
			nrecipe.setAttribute( "units", "proportional");
		else
			nrecipe.setAttribute( "units", "cl");
		
		
		if (!rece->getComment().isNull()){ //need to creat a comment 
			QDomElement ncomment = doc.createElement("comment");
			ncomment.appendChild(doc.createTextNode( rece->getComment() ));
			nrecipe.appendChild( ncomment);
		}
		

		if (!rece->getGlassType().isNull()){ //need to creat a  glassType
			QDomElement nglasstype = doc.createElement("glassType");
			nglasstype.appendChild(doc.createTextNode( rece->getGlassType() ));
			nrecipe.appendChild( nglasstype);
		}

		if (rece->getNbrGlasses()!=1){ //need to creat a  nbrGlasses
			QDomElement nnbrglasses = doc.createElement("nbrGlasses");
			nnbrglasses.appendChild(doc.createTextNode( QString("%1").arg(rece->getNbrGlasses()) ));
			nrecipe.appendChild( nnbrglasses);
		}
		//Now the liquidElements
		QDomElement nliquidelement = doc.createElement("liquidElement");
		QValueVector<liquidElement *> liquidElements = rece->getLiquidElements();
		for (unsigned j=0 ; j< liquidElements.size() ; ++j){
			nliquidelement = doc.createElement("liquidElement");
			nliquidelement.setAttribute("name",liquidElements[j]->getName());
			if (liquidElements[j]->getQuantity()!=0){
				QDomElement nquantity = doc.createElement("quantity");
				nquantity.appendChild(doc.createTextNode( QString("%1").arg(liquidElements[j]->getQuantity() )));
				nliquidelement.appendChild(nquantity);
			}
			nrecipe.appendChild(nliquidelement);
		}

		//Now the otherElements
		QDomElement notherelement = doc.createElement("otherElement");
		QValueVector<otherElement *> otherElements = rece->getOtherElements();
		for (unsigned j=0 ; j< otherElements.size() ; ++j){
			notherelement = doc.createElement("otherElement");
			notherelement.setAttribute("name",otherElements[j]->getName());
			if (otherElements[j]->getQuantity()!=0){
				QDomElement nquantity = doc.createElement("quantity");
				nquantity.appendChild(doc.createTextNode( QString("%2").arg( otherElements[j]->getQuantity() )));
				notherelement.appendChild(nquantity);
			}
			nrecipe.appendChild(notherelement);
		}
		
		
		root.appendChild( nrecipe );
	   }
	QFile file( fileName);
	if( !file.open( IO_WriteOnly ) ){
		cerr <<"unable to open in WriteOnly mode the file "<<fileName<<endl;
		return ;
	}
 
	QTextStream ts( &file );
	ts.setEncoding(QTextStream::UnicodeUTF8);
	ts << doc.toString();
	file.close();
 }
void cocktailFileParser::readCocktailsFromFile(QString fileName, QValueVector<recipe *>* recipes)
{
	cocktailFileParser::readCocktailsFromFile(fileName, recipes, false, NULL);
}

void cocktailFileParser::readCocktailsFromFile(QString fileName, QValueVector<recipe *>* recipes, dicoRecipe * dico)
 {
 	cocktailFileParser::readCocktailsFromFile(fileName, recipes, true, dico);
 }
 
void cocktailFileParser::readCocktailsFromFile(QString fileName, QValueVector<recipe *>* recipes, bool addToDico, dicoRecipe * dico)
{
	QDomDocument doc;
	QFile file( fileName );
	if( !file.open( IO_ReadOnly ) ){
		cerr << "ERROR : unable to open file "<<fileName<<endl;
		exit(-1);
	}
	if( !doc.setContent( &file ) )
	{
		file.close();
		cerr << "ERROR : unable to open file "<<fileName<<" as a valid QDomDocument file"<<endl;
		exit(-2);
	}
	file.close();
	QDomElement root=doc.documentElement();
	QDomElement child=root.firstChild().toElement();
	while(!child.isNull())
	{
	if (child.tagName() == "recipe"){
		//A String List in order to add our new recipe in the dico
		QStringList compoList;
		QString nameElement;
		QString nom="";
		QString units;
		QString comment= "";
		QString glassType ="";
		int nbrGlasses=1;
		QValueVector<liquidElement *> liquidElements;
		QValueVector<otherElement *> otherElements;
		nom = child.attribute("name").lower().simplifyWhiteSpace();
		units = child.attribute("units","cl").lower().simplifyWhiteSpace();
		// We traverse the recipe
		QDomElement grandChild=child.firstChild().toElement();
		while(!grandChild.isNull())
		{
			if (grandChild.tagName() == "comment")
				comment = grandChild.text();
			if (grandChild.tagName() == "glassType")
				glassType = grandChild.text().lower().simplifyWhiteSpace();
			if (grandChild.tagName() == "nbrGlasses")
				nbrGlasses = (grandChild.text()).toInt();
			
			if (grandChild.tagName() == "liquidElement"){
				double quantity=0;
				QDomElement grandGrandChild= grandChild.firstChild().toElement();
				while(!grandGrandChild.isNull()){
					if (grandGrandChild.tagName() == "quantity"){
						quantity= grandGrandChild.text().toDouble();
						if (units=="oz")
							quantity=quantity*ozToCl;
					}
					grandGrandChild = grandGrandChild.nextSibling().toElement();
				}
				nameElement = grandChild.attribute("name").lower().simplifyWhiteSpace();
				compoList.append(nameElement);
				liquidElements.push_back(new liquidElement(nameElement,quantity));
			}

			if (grandChild.tagName() == "otherElement"){
				double quantity=0;
				QDomElement grandGrandChild= grandChild.firstChild().toElement();
				while(!grandGrandChild.isNull()){
					if (grandGrandChild.tagName() == "quantity"){
						quantity= grandGrandChild.text().toDouble();
						if (units=="oz")
							quantity=quantity*ozToCl;
					}
					grandGrandChild = grandGrandChild.nextSibling().toElement();
				}
				nameElement = grandChild.attribute("name").lower().simplifyWhiteSpace();
				compoList.append( nameElement );
				otherElements.push_back(new otherElement(nameElement,quantity));
			}

			grandChild = grandChild.nextSibling().toElement();
		}
		bool proportional=true;
		if (units=="cl"||units=="oz")
			proportional=false;

		//creation of a new recipe
		recipe * newRecipe =new recipe(nom , proportional , nbrGlasses , liquidElements , otherElements,comment);
		if (addToDico){
			//parcours de tous les ��ents de compoList
			for ( QStringList::Iterator it = compoList.begin(); it != compoList.end(); ++it ) {
				if (dico->find(*it) != dico->end())   //compo already encoded in the dictionary
					(*(dico->find(*it))).insert(newRecipe);
				else{
					//create a new set
					set<recipe *> newset;
					newset.insert(newRecipe);
					//and insert it in the dico
					dico->insert(*it,newset);
				}
    			}
		}
		recipes->push_back(newRecipe);
		
		cerr << "new recipe added : "<<nom<<endl;
		}
	child = child.nextSibling().toElement();
	}
	cerr << "finishing the reading" <<endl;
}

