


TTF2PK(1)                                               TTF2PK(1)


NAME
       ttf2pk - convert a CJK TrueType font into TeX's pk format.

SYNOPSIS
       ttf2pk pkfile[.pk] tfmfile[.tfm] dpi-x y-scale start-char
              nmb-of-char [-p n param-1 ... param-n]
              [-C codingscheme] [-F family] [-W tfm-width]
              [-H tfm-height] [-D tfm-depth] [-I ital-corr]
              [-h horiz-esc] [-v vert-esc] [-x x-offset]
              [-y y-offset] [-r rotation] [-e encoding] ttf-file

DESCRIPTION
       ttf2pk  takes  a  CJK non-composite format 2 or 4 TrueType
       font in Big 5, EUC, or SJIS encoding (e.g.  NTU  TTF)  and
       converts  a certain contiguous subrange (at most 256 char-
       acters) into a .pk- and a .tfm-file.  The created font can
       then  be used with TeX or LaTeX.  EUC (Extended UNIX code)
       encodings are e.g. GB, JIS, or KS.  Currently no hint  in-
       structions are supported.

       ttf2pk  always  assumes  10pt  as  the design size for the
       written TeX font.

PARAMETERS
       pkfile The name of the .pk-file  to  which  ttf2pk  should
              write  out the pixel data.  If no extension is giv-
              en, .pk will be appended.  If you use `-', data  is
              written to stdout.

       tfmfile
              The  name  of  the .tfm-file to which ttf2pk should
              write out the font metric data.  If no extension is
              given, .tfm will be appended.  If you use `-', data
              is written to stdout.

       dpi-x
       y-scale
              The horizontal resolution and vertical scaling val-
              ue.   Change  these  parameters  to scale the font;
              dpi-y = dpi-x * y-scale .

       start-char
       nmb-of-char
              These two values indicate the character code of the
              first  character and the number of characters to be
              written into the .pk-file.  The number  of  charac-
              ters will be truncated to 256 if the given value is
              greater.  start-char can be in decimal, hexidecimal
              (prefix `0x'),   or  octal  (prefix `0')  notation,
              nmb-of-char must be an integer.

       -p n param-1 ... param-n
              With this option you can set  the  font  parameters
              (slant,  x-height  etc.)  of the .tfm-file.  If you



CJK Version 4.1.0          20-Nov-1996                          1





TTF2PK(1)                                               TTF2PK(1)


              don't specify any parameters,  ttf2pk  assigns  de-
              fault  values  to  the first 7 parameters.  If n is
              smaller than 7, ttf2pk fills up the other values to
              get  the  default 7 parameters.  You can specify at
              most 30 parameters.  Please refer to a  book  about
              TeX for a description of all parameters.

       -C codingscheme
              The  name  of  the coding scheme.  If you omit this
              parameter, the default string `CJK' will  be  used.
              This string will be truncated to 40 characters.

       -F family
              The  name of the font family.  If you omit this pa-
              rameter, the default string  `ttf2pk'  This  string
              will be truncated to 20 characters.

       -W tfm-width
       -H tfm-height
       -D tfm-depth
              The  width,  height, and depth of all characters in
              multiples of the design size.  These three  parame-
              ters  do  not  affect the .pk-file; use the -x, -h,
              and -y parameters additionally.

       -I ital-corr
              The italic correction of  the  font.   No  slanting
              will be done actually, only the value in the metric
              file will be set.  Default value is 0.   [Note:  It
              is very uncommon to use slanted CJK fonts.]

       -h horiz-esc
       -v vert-esc
              The horizontal and vertical escapement of all char-
              acters (in multiples of design size; will be scaled
              properly  to  the given resolution value).  You can
              use -h in combination with -x to change the charac-
              ter widths in .pk-files.  Since standard TeX cannot
              handle vertical typesetting (which would need a ze-
              ro  horizontal escape value and a positive vertical
              escapement) there should never be  a  necessity  to
              use  the  -v  option.  Default values for -h and -v
              are the character width and 0 respectively.

       -x x-offset
       -y y-offset
              With these two parameters you can shift the charac-
              ter  (pixel)  image  in  .pk-files horizontally and
              vertically.  Positive x values shift  right,  posi-
              tive  y values shift up; units are multiples of de-
              sign size.  The default value  of  both  parameters
              is 0.





CJK Version 4.1.0          20-Nov-1996                          2





TTF2PK(1)                                               TTF2PK(1)


       -r rotation
              If the parameter is non-zero, the glyphs are rotat-
              ed 90 degrees counter-clockwise (useful for  imita-
              tion  of vertical typesetting).  The default values
              for the height and depth are assumed to be 0.75 and
              0.25  multiples of design size respectively. It may
              be necessary to adjust these values using  the  -H,
              -D, and -y parameters.

       -e encoding
              The  encoding of the TrueType font. Possible values
              are `EUC', `Big5', `SJIS', and  `X'.   The  special
              value  `X'  takes  start-char  in  JIS encoding and
              translates the value into  SJIS  encoding;  the  TT
              font will be treated SJIS encoded.

       ttf-file
              The  last parameter must point to the TrueType font
              file to process.  Only non-composite TTF  files  in
              format 2 or 4 can be handled currently.

LIMITATIONS
       Since  this  version  does  not support hinting, only high
       resolutions will produce good-looking results.

SEE ALSO
       hbf2gf(1)

       the CJK documentation files (ttf2pk.doc).

AVAILABILITY
       ttf2pk is part of  the  CJK  macro  package  for  LaTeX 2e
       available at the CTAN hosts and its mirrors.

       NTU  TrueType  fonts can be found at ftp.ifcss.org and its
       mirrors.

AUTHORS
       Werner LEMBERG <a7971428@unet.univie.ac.at>
       LI Yu-Ray <r82111@ew.ee.ntu.edu.tw>
       LIN Yaw-Jen <f1506015@csie.ntu.edu.tw>
       WANG Yu-Chung <wycc@iis.sinica.edu.tw>
       WU Liang-Sheng














CJK Version 4.1.0          20-Nov-1996                          3


