


HBF2GF(1)                                               HBF2GF(1)


NAME
       hbf2gf - convert a CJK bitmap font into subfonts usable by
       TeX.

SYNOPSIS
       hbf2gf configuration-file [ subfont-number x-resolution
              y-scale ]

DESCRIPTION
       CJK  bitmap  fonts can't be directly used with TeX because
       the number of characters in each  font  exceeds  256,  the
       limit  of a TeX font.  Thus it is necessary to split these
       fonts into subfonts, and this is exactly what hbf2gf does.

       As  the name says, hbf2gf uses CJK fonts in a certain for-
       mat which is called Hanzi Bitmap Font  (HBF)  format.   It
       simply  consists of the CJK bitmap file(s) and a text file
       very similar to the BDF format  of  the  X  Window  System
       which  describes  the bitmap font files: the encoding, the
       size, etc.  The produced .gf-files can then  be  converted
       with gftopk into standard .pk-files.

       hbf2gf can be called in two modes:

         hbf2gf configuration-file

            This  call  normally  creates a set of .gf-files, one
            .pl-file, and a batch file which must be executed af-
            ter  hbf2gf has finished.  This script will then call
            gftopk to convert all .gf-files into  .pk-files,  and
            it  will  call  pltotf to convert the .pl-file into a
            .tfm-file.  Finally it will  copy  the  .tfm-file  so
            that  each  .pk-file has its .tfm-file (which are all
            identical).

         hbf2gf configuration-file subfont-number x-resolution
                y-scale

            This  mode is intended for use with MakeTeXPK and its
            derivates.  Only one .gf-file together  with  a  .pl-
            file  for  the given subfont number will be computed,
            taking the horizontal resolution and a vertical scal-
            ingfactor   from   the  command  line,  ignoring  the
            nmb_fonts parameter of the  configuration  file.   No
            job file and will be created.

       See the next section for more details about the configura-
       tion file.

CONFIGURATION FILE
       Here a sample configuration file (gsfs14.cfg) for a  56x56
       Chinese  font  in  GB  encoding; note that all information
       about the font is in the jfs56.hbf file.  See  the  AVAIL-
       ABILITY  section  where to get CJK fonts together with its



CJK Version 4.1.0          20-Nov-1996                          1





HBF2GF(1)                                               HBF2GF(1)


       .hbf files:

         hbf_header     /usr/local/lib/font/china/jfs56/jfs56.hbf
         mag_x          1
         threshold      128
         comment        jianti fansongti 56x56 pixel font

         design_size    14.4

         y_offset       -13

         nmb_files      -1

         output_name    gsfs14

         checksum       123456789

         dpi_x          300

         pk_files       no
         tfm_files      yes

         coding         codingscheme GuoBiao encoded TeX text

         pk_directory   $TEXMF/fonts/chinese/gsfs14/pk/CJK/
         tfm_directory  $TEXMF/fonts/chinese/gsfs14/tfm/

       A configuration file is a plain text  file  consisting  of
       keywords  and its arguments.  A keyword must start a line,
       otherwise the whole line will be  ignored.   If  the  word
       starting a line is not a keyword, the line will be ignored
       too.  Empty lines will also be skipped.   The  search  for
       keywords  is  case  insensitive; in contrast the arguments
       will be taken exactly as  given  (except  `yes'  and  `no'
       which can be written with uppercase or lowercase letters).
       Each keyword has one argument which must be  separated  by
       whitespace  (blanks  or tabs) from the keyword and must be
       on the same line.  Each line must not be longer  than  256
       characters.

       You  can  use  environment  variables in the configuration
       file.  hbf2gf recognizes only environment  variable  names
       which  start  with  a letter or an underscore, followed by
       alphanumeric characters or underscores.  You can  surround
       the  variable  with  braces to indicate where the variable
       name ends, for example ${FOO}.  To get a dollar  sign  you
       must write $$.

       This is the list of all necessary keywords:

       hbf_header
              the HBF header file name of the input font(s).





CJK Version 4.1.0          20-Nov-1996                          2





HBF2GF(1)                                               HBF2GF(1)


       output_name
              the  name  stem of the output files.  A running two
              digit decimal number starting with 01 will  be  ap-
              pended.   For Unicode fonts see the keyword unicode
              below.

       And now all optional keywords:

       x_offset
              increases the character width.  Will be applied  on
              both  sides;  default for non-rotated glyphs is the
              value given in the  HBF  header  (HBF_BITMAP_BOUND-
              ING_BOX) scaled to design_size (in pixels).

       y_offset
              shifts  all characters up or down; default for non-
              rotated glyphs is the value given in the HBF header
              (HBF_BITMAP_BOUNDING_BOX) scaled to design_size (in
              pixels).

       design_size
              the designsize (in points) of the  font.   x_offset
              and y_offset refer to this size.  Default is 10.0

       slant  the slant of the font (given as Delta_x / Delta_y).
              Only values in the range  0 <= slant <= 1  are  al-
              lowed.  Default is 0.0

       rotation
              if  set to `yes', all glyphs will be rotated 90 de-
              grees counter-clockwise.  The  default  offsets  as
              given  in  the  HBF header will be ignored (and set
              to 0).  Default is `no'.

       mag_x
       mag_y  scaling values of the characters to  reach  design-
              size.   If only one magnification is given, x and y
              values  are  assumed  to  be  equal.   Default   is
              mag_x = mag_y = 1.0



       threshold
              A  value between 1 and 254 defining a threshold for
              converting the internal  graymap  into  the  output
              bitmap; lower values cut more pixels.  Default val-
              ue is 128.


       comment
              a comment describing the font; default is none.






CJK Version 4.1.0          20-Nov-1996                          3





HBF2GF(1)                                               HBF2GF(1)


       nmb_fonts
              the number of the fonts.  Default value is  -1  for
              creating all fonts.

       unicode
              if  `yes',  a  two digit hexadecimal number will be
              used as a running number, starting with  the  value
              of the first byte of the first code range.  Default
              is `no'.


       dpi_x
       dpi_y  the horizontal and vertical resolution (in dpi)  of
              the  printer.   If  only one resolution is given, x
              and y values are assumed to be equal.   Default  is
              300.

       checksum
              a  checksum  to identify the .gf-files with the ap-
              propriate .tfm-files.  The default of  this  32 bit
              unsigned integer is the system time (in seconds).

       coding a  comment describing the coding scheme; default is
              none.


       pk_directory
              the destination directory  of  the  .pk-files;  de-
              fault:  none.   Attention!  The batch file will not
              check whether this directory exists.

       tfm_directory
              the destination directory of  the  .tfm-files;  de-
              fault:  none.   Attention!  The batch file will not
              check whether this directory exists.

       pk_files
              whether to create  .pk-files  or  not;  default  is
              `yes'.

       tfm_files
              whether  to  create  .tfm-files  or not; default is
              `yes'.

       long_extension
              if `yes', .pk-files will include the resolution  in
              the extension (e.g.  gsso1201.300pk).  This affects
              the batch file only (default is `yes').

       rm_command
              the shell command to remove files; default: `rm'.

       cp_command
              the shell command to copy files; default: `cp'.



CJK Version 4.1.0          20-Nov-1996                          4





HBF2GF(1)                                               HBF2GF(1)


       job_extension
              the extension of the batch file which calls  gftopk
              and  pltotf  to  convert the .gf- and the .pl-files
              into .pk- and .tfm-files respectively;  default  is
              none.

LIMITATIONS
       The  x  and  y  output size must not exceed MAX_CHAR_SIZE,
       which is defined at compile time; its default value is 255
       (pixel).

SEE ALSO
       ttf2pk(1)

       hbf2gf.w:  this  is  the source code written in CWEB which
       can be converted into a pretty-printed TeX document  using
       cweave.   The  CJK  package  also  contains a preformatted
       hbf2gf.dvi file.

       the CJK documentation files (hbf2gf.doc).

       the Hanzi Bitmap File (HBF) standard version  1.3;  avail-
       able at ftp.ifcss.org

FILES
       *.cfg  The  MakeTeXPK  script  (as  delivered with the CJK
              package) searches for files of the  form  <stem  of
              the  CJK  font name>.cfg to decide whether the font
              must be handled by hbf2gf or not.

AVAILABILITY
       hbf2gf is part of  the  CJK  macro  package  for  LaTeX 2e
       available at the CTAN hosts and its mirrors.

       CJK  fonts  together with HBF header files can be found at
       ftp.ifcss.org and its mirrors.

AUTHOR
       Werner Lemberg <a7971428@unet.univie.ac.at>


















CJK Version 4.1.0          20-Nov-1996                          5


