/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/

#include <iostream>
#include "examplewindow.h"
#include <gtkmm/application.h>
#include <config.h>
#include <locale.h>
#include "gettext.h"

// to install from shell: inside sequencer-1.0 directory run:
// # this creates the configure script
// $ autoreconf --verbose --install --force
// $ ./configure --with-jack
// $  make 

// # to run program:
// inside sequencer-1.0/tests run
// ./sequencer


// the whole project is 7000 lines in 17 files
// Author : Marvin Eagle (except for RtMidi library, which has it's own authors)
// Version Sequencer 1.0 completed Dec. 19, 2017

int main( int argc, char *argv[] )
{
	
	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain (PACKAGE);
	auto app = Gtk::Application::create(argc, argv, "org.gtkmm.example");

	ExampleWindow window(app);
//Shows the window and returns when it is closed.
	app->run(window);
 
	return 0;
}
