/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/
#ifndef GTKMM_CUSTOM_CLASS_NOTE
#define GTKMM_CUSTOM_CLASS_NOTE

class Note 
{
public:
	Note(int midi_number);
	~Note();
	bool over;
	bool selected;
    int position_x, position_y, normal_x;
    int midi_number;
    int velocity;
    int midi_instrument;
    int midi_channel;
    int display; // 0 for flat flat, 1 for flat, 
				// 2 for regular, 3 for #, 4 for ##
	int display_options;
	bool black; // true if it is a black key, false otherwise
	int calculate_y(int midi_num);
	int find_display_options(int midi_num);
	void update_display();
	void update_x();
protected:
	bool is_black(int midi_num);
	
};

#endif
