/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/

#include "mywidget.h"
#include <gdkmm/general.h>  // for cairo helper functions
#include <iostream>
#include <cstring>

//   g++  -c mywidget.cpp -o mywidget.o `pkg-config gtkmm-3.0 --cflags --libs`
//   g++  midiout.o RtMidi.o customradiobutton.o note.o mybutton.o mywidget.o myarea.o main.o examplewindow.o -o main `pkg-config gtkmm-3.0 --cflags --libs`

MyWidget::MyWidget()	
  //The GType name will actually be gtkmm__CustomObject_mywidget
{
	set_has_window(false);
	over = false;
	key_number = 0;
}

MyWidget::~MyWidget()
{}

Gtk::SizeRequestMode MyWidget::get_request_mode_vfunc() const
{
  //Accept the default value supplied by the base class.
  return Gtk::Widget::get_request_mode_vfunc();
}

//Discover the total amount of minimum space and natural space needed by
//this widget.

void MyWidget::get_preferred_width_vfunc(int& minimum_width, int& natural_width) const
{
  minimum_width = 32;
  natural_width = 94;
}

void MyWidget::get_preferred_height_for_width_vfunc(int /* width */,
   int& minimum_height, int& natural_height) const
{
  minimum_height = 9;
  natural_height = 9;
}

void MyWidget::get_preferred_height_vfunc(int& minimum_height, int& natural_height) const
{
  minimum_height = 9;
  natural_height = 9;
}

void MyWidget::get_preferred_width_for_height_vfunc(int /* height */,
   int& minimum_width, int& natural_width) const
{
  minimum_width = 32;
  natural_width = 94;
}

void MyWidget::on_size_allocate(Gtk::Allocation& allocation)
{
  //Do something with the space that we have actually been given:
  //(We will not be given heights or widths less than we have requested, though
  //we might get more)
 
  //Use the offered allocation for this container:
  set_allocation(allocation);
 
}

void MyWidget::on_map()
{
  //Call base class:
  Gtk::Widget::on_map();
}

void MyWidget::on_unmap()
{
  //Call base class:
  Gtk::Widget::on_unmap();
}

void MyWidget::on_realize()
{
  //Do not call base class Gtk::Widget::on_realize().
  //It's intended only for widgets that set_has_window(false).

  //Call base class:
  Gtk::Widget::on_realize();
}

void MyWidget::on_unrealize()
{
   //Call base class:
  Gtk::Widget::on_unrealize();
}

void MyWidget::draw_black_key(const Cairo::RefPtr<Cairo::Context>& cr, int xs, int ys, int bkl, int bkh,  double b_red, double b_green, double b_blue)
{
	cr->move_to(xs, ys);
	cr->line_to(bkl, ys);
	cr->line_to(bkl, bkh);
	cr->line_to(xs, bkh);
	cr->close_path();
	if(over)
		cr->set_source_rgb(b_red, b_green, b_blue);
	else
		cr->set_source_rgb(0, 0, 0);
	cr->fill();
}

// This function draws right white key
void MyWidget::draw_white_key(const Cairo::RefPtr<Cairo::Context>& cr, int xs, int ys, int kl, double red, double green, double blue)
{
	cr->move_to(xs, ys);
	cr->line_to(kl, ys);
	cr->line_to(kl, 18);
	cr->line_to(xs, 18);
	cr->close_path();
	if(over)
		cr->set_source_rgb(red, green, blue);
	else
		cr->set_source_rgb(1, 1, 1);
	cr->fill ();
	cr->move_to(xs, ys);
	cr->line_to(kl, ys);
	cr->line_to(kl, 18);
	cr->line_to(xs, 18);
	cr->set_source_rgb(0, 0, 0);
	cr->stroke();		
}

/*This function draws single key in the drawing area.
 * See piano.png image file for key mapping in the directory above this file Documents/CP.
 * oct_off is an octave number counting from the bottom: 1 is for the first */
void MyWidget::draw_key(const Cairo::RefPtr<Cairo::Context>& cr, int key_num, int oct_off)
{
	int xs, ys, kh, bkh, kl, bkl;
	int csharp, dsharp, fsharp, gsharp, asharp; 
	double red, green, blue, b_red, b_green, b_blue;
	
	red = 0.97; green = 0.87; blue = 0.62; // mouse over colors
	b_red = 0.11; b_green = 0.5; b_blue = 0.41;
	kh = 18;     // white key height
	xs = 0;  // coordinates for the upper left corner of the key
	ys = 0;
	//ys = 522 - kh * 7 * (oct_off-1); // 1 octave is 126 high
	
	kl = 32;  // right side of white key length
	bkl = 62; // black key length
	bkh = 12; // black key height
	cr->set_line_width(1.0);
	
	if( (key_num != 77) &&  (key_num != 78) && (key_num % 19 != 0) )
		key_num = key_num % 19;

	switch (key_num)
	{
		case 77: // note C (upper portion of key) This is unique case 
				// for one key only (top left white key)
			cr->move_to(xs, ys);
			cr->line_to(bkl, ys);
			cr->line_to(bkl, 18);
			cr->line_to(xs, 18);
			cr->close_path();
			if(over)
				cr->set_source_rgb(red, green, blue);
			else
				cr->set_source_rgb(1, 1, 1);
			cr->fill ();
			cr->move_to(bkl, 18);
			cr->line_to(xs, 18);
			cr->line_to(xs, ys);
			cr->line_to(bkl, ys);
			cr->set_source_rgb(0, 0, 0);
			cr->stroke();
		break;
		case 78: // note C right side of key
			draw_white_key(cr, xs, ys, kl, red, green, blue);
		break;
		case 38: case 57: case 76:
		case 19:
		case 16:
		case 13:
		case 10:
		case 8:
		case 5:
		case 2:
			draw_white_key(cr, xs, ys, kl, red, green, blue);
		break;
		case 18:
			cr->move_to(xs, ys);
			cr->line_to(bkl, ys);
			cr->line_to(bkl, 9);
			cr->line_to(xs, 9);
			cr->close_path();
			if(over)
				cr->set_source_rgb(red, green, blue);
			else
				cr->set_source_rgb(1, 1, 1);
			cr->fill ();
			cr->move_to(bkl, 9);
			cr->line_to(xs, 9);
			cr->line_to(xs, ys);
			cr->line_to(bkl, ys);
			cr->set_source_rgb(0, 0, 0);
			cr->stroke();
		break;
		case 3:
		case 6:
		case 11:
		case 14:
		case 17:
			draw_black_key(cr, xs, ys, bkl, bkh, b_red, b_green, b_blue);
		break;
		case 15:
		case 12:
		case 4:
			cr->move_to(xs, ys);
			cr->line_to(bkl, ys);
			cr->line_to(bkl, 9);
			cr->line_to(xs, 9);
			cr->close_path();
			if(over)
				cr->set_source_rgb(red, green, blue);
			else
				cr->set_source_rgb(1, 1, 1);
			cr->fill();
			cr->move_to(xs, 9);
			cr->line_to(xs, ys);
			cr->set_source_rgb(0, 0, 0);
			cr->stroke();
		break;
		case 9:
			cr->move_to(xs, ys);
			cr->line_to(bkl, ys);
			cr->line_to(bkl, 9);
			cr->line_to(xs, 9);
			cr->close_path();
			if(over)
				cr->set_source_rgb(red, green, blue);
			else
				cr->set_source_rgb(1, 1, 1);
			cr->fill ();
			cr->move_to(bkl, 9);
			cr->line_to(xs, 9);
			cr->line_to(xs, ys);
			cr->set_source_rgb(0, 0, 0);
			cr->stroke();
		break;
		case 7:
			cr->move_to(xs, ys);
			cr->line_to(bkl, ys);
			cr->line_to(bkl, 11);
			cr->line_to(xs, 11);
			cr->close_path();
			if(over)
				cr->set_source_rgb(red, green, blue);
			else
				cr->set_source_rgb(1, 1, 1);
			cr->fill ();
			cr->move_to(xs, 11);
			cr->line_to(xs, ys);
			cr->line_to(bkl, ys);
			cr->set_source_rgb(0, 0, 0);
			cr->stroke();
		break;
		case 1:
			cr->move_to(xs, ys);
			cr->line_to(bkl, ys);
			cr->line_to(bkl, 10);
			cr->line_to(xs, 10);
			cr->close_path();
			if(over)
				cr->set_source_rgb(red, green, blue);
			else
				cr->set_source_rgb(1, 1, 1);
			cr->fill ();
			cr->move_to(bkl,10);
			cr->line_to(xs, 10);
			cr->line_to(xs, ys);
			cr->set_source_rgb(0, 0, 0);
			cr->stroke();
		break;
		

	}
}

bool MyWidget::on_draw(const Cairo::RefPtr<Cairo::Context>& cr)
{
  	draw_key(cr, key_number, 0);

  return true;
}

