/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/

#ifndef GTKMM_CUSTOM_WIDGET_MYBUTTON_H
#define GTKMM_CUSTOM_WIDGET_MYBUTTON_H

#include <gtkmm/widget.h>
#include <string>
#include <glibmm/ustring.h>
#include <pangomm/fontdescription.h>

class MyButton : public Gtk::Widget
{
public:
  MyButton();
  virtual ~MyButton();
  bool over;
  bool pressed;
  bool occupied;
  int button_type, button_name;
  // these variable are used for section buttons:
  int sect_start, sect_end, sect_chord_start, sect_chord_end, sect_chord_length;
  int sect_pix_length;
  Glib::ustring * sect_name;

        
protected:

  //Overrides:
  Gtk::SizeRequestMode get_request_mode_vfunc() const override;
  void get_preferred_width_vfunc(int& minimum_width, int& natural_width) const override;
  void get_preferred_height_for_width_vfunc(int width, int& minimum_height, int& natural_height) const  override;
  void get_preferred_height_vfunc(int& minimum_height, int& natural_height) const override;
  void get_preferred_width_for_height_vfunc(int height, int& minimum_width, int& natural_width) const override;
  void on_size_allocate(Gtk::Allocation& allocation) override;
  void on_map() override;
  void on_unmap() override;
  void on_realize() override;
  void on_unrealize() override;
  bool on_draw(const Cairo::RefPtr<Cairo::Context>& cr) override;
	
 
  Glib::RefPtr<Gdk::Window> m_refGdkWindow;
  void draw_text(const Cairo::RefPtr<Cairo::Context>& cr, const Glib::ustring& text,
                       int rectangle_width, int rectangle_height, int size);
  
 };

#endif 
