/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/

#ifndef GTKMM_EXAMPLE_MYAREA_H
#define GTKMM_EXAMPLE_MYAREA_H
#include <glib.h>
#include "note.h"
#include "mybutton.h"
#include "custom_dllist.h"
#include <gtkmm/eventbox.h>
#include <gtkmm/drawingarea.h>

class Section_base
{
public:
	Section_base();
	~Section_base();
	int chord_start;
	int chord_end;
	int length;
	Glib::ustring * name;
};

typedef Dlnode Sequence;

class MyArea : public Gtk::DrawingArea
{
public:
	MyArea();
	virtual ~MyArea();
	
	void draw_note(const Cairo::RefPtr<Cairo::Context>& cr, Note * n);
	void  draw_sharp(const Cairo::RefPtr<Cairo::Context>& cr, int x, int y, double scale, Note * n);
	void  draw_double_sharp(const Cairo::RefPtr<Cairo::Context>& cr, int x, int y, double scale, Note * n);
	void  draw_flat(const Cairo::RefPtr<Cairo::Context>& cr, int x, int y, double scale, Note * n);
	void  draw_double_flat(const Cairo::RefPtr<Cairo::Context>& cr, int x, int y, double scale, Note * n);
	void  draw_glow(const Cairo::RefPtr<Cairo::Context>& cr, int x, int y, double scale);
	
	Sequence * curs_node; // current sequence node 
	Sequence * curs_node_copy; // backup copy (only changes on save)
	Dlnode * current_sequence;
	Dlnode * current_chord;
	Section_base * initial_section_base;
	
protected:
	Note * dummy_note;
	bool on_motion_notify_event (GdkEventMotion* event);
	 //Override default signal handler:
	bool on_draw(const Cairo::RefPtr<Cairo::Context>& cr) override;
};

#endif
