/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/

#include "myarea.h"
#include <cairomm/context.h>
#include <cairomm/pattern.h>
#include <glibmm/refptr.h>
#include "custom_dllist.h"
#include <stdio.h>
#include <gtkmm/button.h>
#include "note.h"
#include <glib.h>
#include "globals.h"

Dlnode * g_sequences;

// g++  -c myarea.cpp -o myarea.o `pkg-config gtkmm-3.0 --cflags --libs` 

// the whole project is 4700 lines in 15 files
// Author : Marvin Eagle (except for RtMidi library, which has it's own authors)
// Version Sequencer 1.0 completed Dec. 19, 2017
Section_base::Section_base()
{
	chord_start = 0; // Chords are counted from 1
	chord_end = 0;
	name = NULL;
}
Section_base::~Section_base()
{}

MyArea::MyArea()
{
	// Set masks for mouse events
	add_events(Gdk::BUTTON_PRESS_MASK |
			   Gdk::BUTTON_RELEASE_MASK |
			   Gdk::POINTER_MOTION_MASK);
	dummy_note = new Note(-1000);
	
	g_sequences = Dlist::dl_create();
	current_sequence = Dlist::dl_create();
	current_chord = Dlist::dl_create();
	
	curs_node = g_sequences; // current sequence node
	current_chord->data = dummy_note;
	current_sequence->data = current_chord;
	g_sequences->data = current_sequence;
	
	// initial_section_base = new Section_base();
	curs_node->section_bases = Dlist::dl_create();
	// section_bases->data = initial_section_base;	

}

MyArea::~MyArea()
{ 
	
}

bool MyArea::on_motion_notify_event (GdkEventMotion*event)
{
	//int XMouse=event->x;
	//int YMouse=event->y;
	
	return false;
}

void  MyArea::draw_double_flat(const Cairo::RefPtr<Cairo::Context>& cr,
					int x, int y, double scale, Note * n)
{
	// note must be shifted to the right 7px
    // draw double flat
    double red, green, blue;
	cr->save();
	cr->translate(x, y);
	cr->scale(0.75, 1);
	draw_flat(cr, -1, 0, 1.0, n);
	draw_flat(cr, 10, 0, 1.0, n);
	cr->restore();
	
}

void  MyArea::draw_flat(const Cairo::RefPtr<Cairo::Context>& cr,
					int x, int y, double scale, Note * n)
{
	// draw flat // d2b399ff Inkscape line color for black background images
	// Note must be shifted to the right 5px
	double red, green, blue;
	int x_start = 4;
	int y_start = 2.5;
	cr->save();
	cr->translate(x, y);
	if(n->selected)
		{ red = 1.0; green = 0.54; blue = 0; }
	else // not selected
		{red = 0.47; green = 0.9; blue = 0.71;}
	cr->move_to(x_start, y_start + 2);
	cr->line_to(x_start + 2, y_start + 2);
	cr->line_to(x_start + 2, y_start + 24);
	cr->line_to(x_start, y_start + 26);
	cr->close_path();
	cr->set_source_rgb(red, green, blue);
	cr->set_line_width(0.5);
	cr->fill();
	
	cr->move_to(x_start + 2, y_start + 14);
	cr->curve_to(x_start + 10.9, y_start + 8.9, x_start + 12, y_start + 16,
					x_start + 12, y_start + 16);
	cr->curve_to(x_start + 12, y_start + 20.4, x_start + 3.6, y_start + 23, 
					x_start , y_start + 27 );
	cr->line_to(x_start, y_start + 25.5);
	cr->curve_to(x_start + 5.1, y_start + 21, x_start + 8, y_start + 18.7,
					x_start + 7.2, y_start + 15.2);
	cr->curve_to( x_start + 5.5, y_start + 13.1, x_start + 3.5, y_start + 13.9,
					x_start + 2, y_start + 15.7);
	cr->close_path();
	cr->fill();
	
	cr->restore();
}

void  MyArea::draw_double_sharp(const Cairo::RefPtr<Cairo::Context>& cr,
								int x, int y, double scale, Note * n)
{
	// Note must be shifted to the right 7px
	double red, green, blue;
	cr->save();
	cr->translate(x, y);	
	// draw double sharp
	if(n->selected)
		{ red = 1.0; green = 0.54; blue = 0; }
	else // not selected
		{red = 0.47; green = 0.9; blue = 0.71;}
	int x_start = 2;
	int y_start = 12; 
	cr->move_to(x_start, y_start);
	cr->line_to(x_start + 5, y_start);
	cr->curve_to(x_start + 5, y_start + 5, x_start + 11, y_start + 11, 
					x_start + 16, y_start + 11); 
	cr->line_to(x_start + 16, y_start + 16);
	cr->line_to(x_start + 11, y_start + 16);
	cr->curve_to(x_start + 11, y_start + 11, x_start + 5, y_start + 5,
					x_start, y_start + 5);
	cr->close_path();
	cr->set_source_rgb(red, green, blue);
	cr->set_line_width(0.2);
	cr->fill();
	
	cr->move_to(x_start + 16, y_start);
	cr->line_to(x_start + 16, y_start + 5);
	cr->curve_to(x_start + 11, y_start + 5, x_start + 5, y_start + 11,
					x_start + 5, y_start + 16);
	cr->line_to(x_start, y_start + 16);
	cr->line_to(x_start, y_start + 11);
	cr->curve_to(x_start + 5, y_start + 11, x_start + 11, y_start + 5,
					x_start + 11, y_start);
	cr->close_path();
	cr->fill(); 
	cr->restore();
	
}

void MyArea::draw_sharp(const Cairo::RefPtr<Cairo::Context>& cr,
					int x, int y, double scale, Note * n)
{
	// Note must be shifted to the right 5px
	double red, green, blue;
	cr->save();
	cr->translate(x, y);	
	// draw sharp
	if(n->selected)
		{ red = 1.0; green = 0.54; blue = 0; }
	else // not selected
		{red = 0.47; green = 0.9; blue = 0.71;}
	
	int x_start = 3.5;
	int y_start = 9;
	cr->set_source_rgb(red, green, blue);
	cr->move_to(x_start, y_start + 1);
	cr->line_to(x_start, y_start + 23);
	cr->stroke();
	cr->move_to(x_start + 5, y_start);
	cr->line_to(x_start + 5, y_start + 22);
	cr->stroke();
	cr->move_to(x_start - 3, y_start + 8);
	cr->line_to(x_start + 8, y_start + 6);
	cr->stroke();
	cr->move_to(x_start - 3, y_start + 16);
	cr->line_to(x_start + 8, y_start + 14);
	cr->stroke();
	cr->restore();

}

//Draws 5 ellipses of different size and rotation one on another
void  MyArea::draw_note(const Cairo::RefPtr<Cairo::Context>& cr, Note * n)
{
	int xs = n->position_x;
	int ys = n->position_y;
	double red, green, blue; // note color
	
	if(ys == 451 || ys == 466) // lowest D and E
	{
		// draw horizontal line
		cr->save();
		cr->move_to(xs + 8, 471);
		cr->line_to(xs + 48, 471);
		cr->set_source_rgb(0.43, 0.5, 0.73);
		cr->stroke();
		cr->restore();
	}
	else if(ys == 481) // lowest C
	{
		// draw 2 horizontal lines
		cr->save();
		cr->move_to(xs + 8, 471);
		cr->line_to(xs + 48, 471);
		cr->set_source_rgb(0.43, 0.5, 0.73);
		cr->stroke();
		cr->move_to(xs + 8, 501);
		cr->line_to(xs + 48, 501);
		cr->stroke();
		cr->restore();
	}
	else if(ys == 241) // middle C
	{
		// draw horizontal line
		cr->save();
		cr->move_to(xs + 8, 261);
		cr->line_to(xs + 48, 261);
		cr->set_source_rgb(0.43, 0.5, 0.73);
		cr->stroke();
		cr->restore();
	}
	else if(ys == 31 || ys == 16) // top A and B
	{
		// draw horizontal line
		cr->save();
		cr->move_to(xs + 8, 51);
		cr->line_to(xs + 48, 51);
		cr->set_source_rgb(0.43, 0.5, 0.73);
		cr->stroke();
		cr->restore();
	}
	else if(ys == 1) // top C
	{
		// draw 2 horizontal lines
		cr->save();
		cr->move_to(xs + 8, 51);
		cr->line_to(xs + 48, 51);
		cr->set_source_rgb(0.43, 0.5, 0.73);
		cr->stroke();
		cr->move_to(xs + 8, 21);
		cr->line_to(xs + 48, 21);
		cr->stroke();
		cr->restore();
	}

	
	int width = 25; // of the rectangle enclosing ellipse
	int height = 15; // of the rectangle enclosing ellipse
	if(n->selected)
		{ red = 1.0; green = 0.54; blue = 0; }
	else // not selected
		{red = 0.47; green = 0.9; blue = 0.71;}
		
	double rotation = 0.4;
	cr->save();
	cr->translate(xs, ys);
	
	cr->save();
	cr->translate(28, 20);
	cr->scale(width / 2.0, height / 2.0);
	cr->arc(0.0, 0.0, 1.0, 0.0, 2 * M_PI);
	cr->restore();
	cr->set_source_rgb(red, green, blue);
	cr->stroke();
	
	
	cr->save();
	cr->rotate(rotation);
	cr->translate(34, 7.5);
	cr->scale(width / 2.8, height / 2.8);
	cr->arc(0.0, 0.0, 1.0, 0.0, 2 * M_PI);
	cr->restore();
	cr->set_source_rgb(red, green, blue);
	cr->stroke();
	
	rotation = 0.3;
	cr->save();
	cr->rotate(rotation);
	cr->translate(33, 11);
	cr->scale(width / 2.8, height / 2.8);
	cr->arc(0.0, 0.0, 1.17, 0.0, 2 * M_PI);
	cr->restore();
	cr->set_source_rgb(red, green, blue);
	cr->stroke();
	
	rotation = 0.2;
	cr->save();
	cr->rotate(rotation);
	cr->translate(32, 14);
	cr->scale(width / 2.8, height / 2.8);
	cr->arc(0.0, 0.0, 1.17, 0.0, 2 * M_PI);
	cr->restore();
	cr->set_source_rgb(red, green, blue);
	cr->stroke();
	
	rotation = 0.1;
	cr->save();
	cr->rotate(rotation);
	cr->translate(30, 17);
	cr->scale(width / 2.8, height / 2.8);
	cr->arc(0.0, 0.0, 1.25, 0.0, 2 * M_PI);
	cr->restore();
	
	cr->set_source_rgb(red, green, blue);
	cr->stroke();
	cr->restore();
}

void  MyArea::draw_glow(const Cairo::RefPtr<Cairo::Context>& cr, int x, int y, double scale)
{
	// draw radial gradient
	int x_start = 0;
	int y_start = 0;
	cr->save();
	cr->translate(x, y);

	cr->scale(1, 0.6);
	static Cairo::RefPtr< Cairo::RadialGradient > grad = 
			Cairo::RadialGradient::create (x_start + 27.7, y_start + 33.5, 5,
									x_start + 27.7, y_start + 33.5, 25);
	grad->add_color_stop_rgba(0.2, 0.04, 0.09, 0.2, 0.5);
	grad->add_color_stop_rgba(0.25, 0.93, 0.86, 0.22, 0.5);
	grad->add_color_stop_rgba(0.8, 0.3, 0.33, 0.25, 0.5);
	grad->add_color_stop_rgba(1, 0.04, 0.09, 0.2, 0.5);
	grad->add_color_stop_rgba(1, 0.04, 0.09, 0.2, 0);
	cr->set_source(grad);
	cr->paint();
	static Cairo::RefPtr< Cairo::LinearGradient > grad1 = 
			Cairo::LinearGradient::create (100.0, 100.0, 200.0, 100.0);
	
	cr->restore();
}

bool MyArea::on_draw(const Cairo::RefPtr<Cairo::Context>& cr)
{
	Dlnode * chords_buffer_list;
	Dlnode * notes_buffer_list;
	Note * n;
	int width = 848;
	cr->set_source_rgb(0.04, 0.09, 0.2); 
	cr->paint(); 
	puts("Inside MyArea::on_draw");
	for(uint j=0; j<Dlist::dl_count (current_sequence); j++)
	{
		notes_buffer_list = (Dlnode *) (Dlist::dl_nth_node(current_sequence, j)->data);
		//std::cout << "Inside outer for loop: j = " << j << std::endl;
		for(uint k=1; k<Dlist::dl_count (notes_buffer_list); k++)
		{
			n = (Note *) (Dlist::dl_nth_node(notes_buffer_list, k)->data);
			//std::cout << "Inside inner for loop: k = " << k << std::endl;
			if(n->selected) 
			{
				//puts ("selected");
				draw_glow(cr, n->position_x, n->position_y, 1.0);
			}
		}
	}
	puts("Line 394");
	 // draw horizontal lines
	for(int i=0; i<13; i++)
	{
		if(i == 0 || i == 1 || i == 7  )
			continue;
		cr->move_to(0, 9 + i * 36);
		cr->line_to(3392, 9 + i * 36);
		cr->set_source_rgb(0.12, 0.23, 0.70);
		cr->stroke();
	}
	
	
	int le = Dlist::dl_count( (Dlnode*) curs_node->section_bases);
	printf("length of curs_node->section_bases is %d\n", le);
	
	// draw vertical section lines
	
	Section_base * buffer_base;
	Dlnode * buffer_node;
	buffer_node = (Dlnode*) curs_node->section_bases;
	while(buffer_node != NULL)
	{
		buffer_base = (Section_base *) buffer_node->data;
		//puts("Inside area on_draw bases iteration");
		int e = buffer_base->chord_end;
		//printf("e is %d\n", e);
		cr->move_to(53 * e, 0);
		cr->line_to(53 * e, 522);
		cr->set_source_rgb(0.12, 0.23, 0.70);
		cr->stroke();
		buffer_node = buffer_node->next;
	}
	

	
	for(uint j=0; j<Dlist::dl_count (current_sequence); j++)
	{
		notes_buffer_list = (Dlnode *) (Dlist::dl_nth_node(current_sequence, j)->data);
		//printf("glist notes_buffer_list length: %d \n", Dlist::dl_count(notes_buffer_list) );
		if(notes_buffer_list == current_chord)
		{
			//printf("found current chord index: %d\n", j);
			// draw translucent rectangle on the board above the selected button
			cr->move_to(j * 53, 0);
			cr->line_to( (j+1) * 53, 0);
			cr->line_to( (j+1) * 53, 522);
			cr->line_to(j * 53, 522);
			cr->close_path();
			cr->set_source_rgba(0.9, 0.93, 0.45, 0.2);
			cr->fill();
		}
		//printf("glist notes_buffer_list # %d length: %d \n", j, Dlist::dl_count(notes_buffer_list) );
		for(uint k=1; k<Dlist::dl_count (notes_buffer_list); k++)
		{
			draw_note(cr, n);
			
			n = (Note *) (Dlist::dl_nth_node(notes_buffer_list, k)->data);
			if (n->display == 0) // double flat
				draw_double_flat(cr, n->position_x-7, n->position_y, 1.0, n);
			if (n->display == 1) // flat
				draw_flat(cr, n->position_x-4, n->position_y, 1.0, n);
			if (n->display == 3) // sharp
				draw_sharp(cr, n->position_x, n->position_y, 1.0, n);
			else if(n->display == 4) // double sharp
				draw_double_sharp(cr, n->position_x-5, n->position_y, 1.0, n);
						
			//printf("Note number %d, position_y = %d\n", k, n->position_y);
		}
	}
	
	return true;
}
