/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/

#ifndef GTKMM_MANUALWINDOW_H
#define GTKMM_MANUALWINDOW_H

#include <gtkmm.h>
#include <pangomm/context.h>
#include <pangomm/fontdescription.h>
#include <gdkmm/rgba.h>

class ManualWindow : public Gtk::Window
{
public:
	ManualWindow();
	virtual ~ManualWindow();

protected:
	Gtk::ScrolledWindow scroll;
	Gtk::HBox m_HBox;
	Gtk::VBox m_VBox, s_VBox;
	Gtk::Label m1_label, m2_label, m3_label;
	Gdk::RGBA white_color;
	
	Gtk::Button close_button;
	void on_button_close();

	const Pango::FontDescription * desc;
	// Pango::FontDescription &other;

};

#endif //GTKMM_EXAMPLEWINDOW_H
