/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/

#include "manualwindow.h"
#include <iostream>
#include <pangomm/context.h>
#include <pangomm/fontdescription.h>
#include <gdkmm/rgba.h>
#include <config.h>
#include "gettext.h"

#define _(string) gettext (string)

ManualWindow::ManualWindow()
:
	m_HBox(true, 5),
	m_VBox(false, 5),
	s_VBox(false, 5), 
	white_color(),
	scroll(),
	close_button("Close")
{
	set_title("Manual");
	set_border_width(5);
	set_default_size(610, 400);
	set_size_request(610, 400);
	add(m_VBox);
	
	white_color.set_rgba(1.0, 1.0, 1.0, 1.0); 
	override_background_color(white_color);

	
	m1_label.set_markup(
	"<markup><span background=\"white\" foreground=\"blue\" font=\"Century 22\">"
	"Manual for Chord Sequencer\n</span></markup>");
	Glib::ustring str0(
	"<markup><span background=\"white\" font=\"Century 16\"> ");
	Glib::ustring str1(
_("Chord Sequencer is a program that allows you to create a sequence of chords \
and play it out in a live performance chord by chord, changing chords using \
usb pedal or keyboard. The chords are played on the external synthesizer \
(Zynaddsubfx recommended, but any synthesizer that supports midi input and \
polyphony, should work), which is connected to the Sequencer using Jack. \
Every time you advance to the new chord in the sequence, the new midi signals \
are sent by the program to the synthesizer, producing a sound change.  \
It is very helpful when you want to play another instrument at the same time \
using your hands, while your foot using pedal is changing the harmony of the piece.\n\n") );
	Glib::ustring str2 = Glib::ustring::compose(
_("First you need to open and start QjackCtl. If you don\'t have it, it can \
be installed by running command \n<i>sudo apt-get install qjackctl</i>%1%1\
\
<b>To start program:</b> \n\
1 - Open QjackCtl and start it.\n\
2 - Open the Chord Sequencer by clicking on it\'s desktop icon, or \
inside sequencer-1.0/src run \n<i>./sequencer</i>\n\n\
\
Then you need to connect it to the synthesizer.%1%1\
\
<b>To connect to zynaddsubfx:</b> %1\
(This assumes that Chord Sequencer was configured --with-jack)%1\
1 - Run command <i>zynaddsubfx -I jack -O jack -a</i> %1\
   Note: just clicking on the zynaddsubfx desktop icon may or may not \
be the right thing, depending on which options are provided in the desktop \
shortcut command.%1\
2 - Connect Chord Sequencer to zynaddsubfx->midi_input (MIDI tab in jack)\n\
3 - Connect zynaddsubfx  output to system (Audio tab in jack)\n\
4 - Change midi input channel in zynaddsubfx to 2 (Chord Sequencer\
 by default uses second midi channel)%1%1\
\
After you successfully opened the sequencer you will want to create \
several sample chords. You create the chords by creating notes. \
To make a note, click on the corresponding key on the keyboard. \
The note will appear on the chord display area. Clicking on the same \
key second time with the same chord being selected will delete the note.%1%1\
\
<b>New chord creation</b>\n\n\
Of course, you will need more than one chord to play. To create a new chord, \
you need to be in the Edit Chord Mode. There are 5 major modes in \
Chord Sequencer: %1%1\
\
1 - Edit Chord %1\
2 - Play Chord %1\
3 - Edit Note %1\
4 - Edit Sections %1\
5 - Sequence Control %1%1\
\
These 5 modes correspond to the 5 large green buttons on the bottom, \
which are the modal buttons used to change between the modes. %1%1\
\
Ok, now after you pressed the Edit Chord button and New Chord button \
showed up, click on it and a new chord will appear on the chord screen. \
The new chord is inserted right after the currently selected chord.\
Or course, you will not be able to insert a new chord in this way \
at the beginning of the song. To do that, use Main menu->Chord->New Chord \
Before Selected. For example, if you need to place a new chord at the beginning \
of the song, you would first select the first chord of the song, then click on \
Main menu->Chord->New Chord Before Selected, and new empty chord will appear on \
the chord screen. \n\
<b>Hint:</b> to select a chord, click on the corresponding purple button right below \
the chord. %1%1"), "\n" );

	Glib::ustring str3(
	_("<b>Creating Notes</b>\n\n\
\
To create a new note, make sure you have the right chord selected and \
press the corresponding key on the keyboard to the left. The new note will \
appear on the screen.\n\n\
\
<b>Deleting Notes</b>\n\n\
\
If for some reason the note you created does not fit well in the chord, you \
can always delete it by pressing the same key that you pressed when created \
this note. Make sure you have the right chord selected.\n\n\
\
<b>Selecting Notes</b>\n\n\
\
Selecting a note is as easy as clicking on it. The note will turn orange \
when selected. In order to see all things \
you can do with a selected note, though, you need to be in the Note Edit \
mode. Clicking on Note Edit button will bring you to the Note Edit mode. \
In this mode, you will see Multiple Select button, and if you click on it, \
you enter Multiple Select submode, which is not a separate mode by itself, \
but a submode to the Note Edit mode. Multiple Select allows you to select and \
edit several notes at the same time. So far the only thing you can do to \
multiple selected notes is to change their velocity (volume)\n\n\
\
<b>Deselecting Notes</b>\n\n\
\
To deselect a selected note, click on it. The note will turn back to light \
green when deselected. \n\n\
\
<b>Playing Single Note</b>\n\n\
\
The program allows you to play single note from a chord. To do that, you \
need to be in Edit Note mode. Select the note and click on \"Play Note\" \
radio button. The note should start playing. To stop playing, click on \
 \"Don't Play\" radio button. Clicking \
on \"Play Chord\" radio button will play the currently selected chord.\n\n\
\
<b>Changing Note Display</b>\n\n\
\
Sometimes you need to change how the note is displayed on the screen in \
order to be in the consistence with the classical scale notations. There 5 \
display options available for use. They are listed below.\n\n\
\
1 - sharp\n\
2 - flat\n\
3 - double sharp\n\
4 - double flat\n\
5 - clear\n\n\
\
Note that not all of them will be available to each note you created. Only \
2 or 3 options will be available, and if you want to see them, you need to \
change to the Note Edit mode by clicking on the corresponding modal button \
and selecting the note. Make sure you are in the Single Note select mode. \
You change the note display by clicking on corresponding available options.\n\n\
\
<b>Changing note velocity</b>\n\n\
\
Each note can be assignted different volume in the chord. It is done in \
the Note Edit mode by selecting note first, using a Note velocity slider \
to change the value and pressing Set Velocity button to save the set value \
of the note volume (veloctiy). Note that velocity is not changed until you \
press the Set Velocity button. \n\n\
\
<b>Chord Edit mode</b>\n\n\
\
You enter Chord Edit mode by clicking on the modal Chord Edit button. \
In this mode you can delete, copy and paste the chords you created earlier.\n\n\
\
<b>Selecting Chords</b>\n\n\
\
To select a chord, click on the corresponding purple button right below \
the chord.\n\n\
\
<b>Copying and Pasting Chords</b>\n\n\
\
Copying can also be done through menu->Chord->Copy Chord, or \
just clicking Copy Chord button. Pasting can only be done when the empty \
chord is selected, you cannot paste over the chord that already has some \
notes in it.\n\n\
\
<b>Deleting Chords</b>\n\n\
\
You delete chord in the same way by pressing Delete button, \
or selecting menu->Chord->Delete Chord. \n\n\
\
<b>Play Chord mode</b>\n\n\
\
You enter Play Chord mode by clicking on the modal Play Chord button. \
In this mode you can play any selected chord by pressing Play button. \
Pressing Next Chord button will stop playing current chord, select next \
chord and play it. Pressing Previous Chord button will stop playing the \
current chord, select the previous chord and play it. Pressing Stop button \
will stop all sounds. \n\
If you are using sections, then when the chord progression reaches the end \
of the section, instead of moving forward for the next chord, it will jump \
to the chord that is a beginning of the next section, located to the right of \
currently played section in the section box. Same is true when moving back \
using previous chord button, only in opposite direction.\n\
\
I want to go into a little bit more detail concerning playing chords, since \
this is the main thing this program was designed to do. Normally I would \
play chords by pressing a usb foot pedal, which in my case has 3 pedals which \
emit signals 1, 2 and 3 depending on which pedal you push. The shortcut 3 \
I have assigned in the following fashion:  \n\n\
\
If no chords are played, it invokes the Play button in the Play Chord mode.\n\
If chores are currently played, it invokes the Next Chord button in the Play \
Chord mode. \n\
The shortcut 2 I assigned to the Previous Chord button in the Play Chord mode.\n\
The shortcut 1 is assigned to Stop button in the Play Chord mode.\n\
The instrument is normally changed in the Synthethizer, but for the \
convenience I include a list of selected instruments of Zynaddsubfx \
Collection bank. \n\n\
\
<b>Changing shortcuts</b>\n\n\
\
Of course, you don\'t have to buy or use the same pedal I got, this is why \
this program allows you to change any shortcut currently assigned to a command \
by clicking on menu Application->Keyboard Shortcuts, which will open a window \
where you can currently change shortcuts to 6 commands. If you want more \
shortcut functionality, please send me an email with the request. \n\n") );
		
	Glib::ustring str4(
	_("<b>Saving sequence</b>\n\n\
\
To save a sequence of chords that you created, push Save button in the right \
bottom corner. The window will pop up asking you for a name to save the sequence. \
After entering a name and pressing Save button, your sequence is saved to the \
hard disk and will be visible in the list of all sequences. \n\n\
\
<b>Selecting and deleting sequences</b>\n\n\
\
To see all sequences, press modal Sequence button. A window will pop up with \
the list of all available sequences. To select a sequence, click on it's name \
and press Select button. To delete a sequence, click on it's name and press \
Delete button. Same with renaming the sequence. \n\n\
\
<b>Renaming sequence</b>\n\n\
\
To rename a sequence, you need first open it by using Sequence button -> \
select sequence. After the sequence is loaded on the screen, you can rename it \
by either pressing save button or clicking menu->sequence->rename sequence. \
The window will pop up asking for a new name. \n\n\
\
<b>Making a new sequence</b>\n\n\
\
Either select menu->sequence-new sequence or press\
Sequence modal button -> New Sequence button.\n\n\
\
<b>Advanced topic: Using sections.</b>\n\n\
\
When you create a sequence of chord for a song, most of the time in can \
be divided into sections, like intro, verse, bridge, coda and so on. \
Of course, it would be nice to be able to repeat those sections as we \
play the sequence without having to write them again. That is exactly \
what sections are designed to do in this application. Note that none of \
the section operations including copying, pasting, deleting or joining \
will affect the original chord sequence that is displayed in the chord \
window. Make sure you save changes by pressing save button before exit.\n\n\
\
<b>Creating sections</b>\n\n\
\
To divide an existing sequence of chords into sections, first you need to \
load the sequence or create it from scratch as described above. After that, \
you enter the Section Edit mode by pressing Section modal button. \
Initially the sequence will be one big section, visualized as a grey \
rectangle below the modal buttons. To create new sections, you split \
this initial section into two by first selecting the chord that you \
want to be last chord in the left section, and then pressing Split button. \
The line will appear in the chord screen to the right of selected \
chord indicating the end of the left section and the start of the \
right section. You will notice that the grey box under the modal \
buttons will be split into two also, indicating that this sequence \
now has two sections. Additional section are created in the same way \
by splitting the existing sections.  \n\n\
\
<b>Selecting sections</b>\n\n\
\
To select a section, click on it inside the section box. The selected \
section will turn sea green color when selected. The selected chord \
in the chord window will jump to the start of selected section. To deselect \
a section, click on it again. It will turn back to grey color.  \n\n\
\
<b>Rearranging sections</b>\n\n\
\
Of course, splitting the sequence into sections by itself does not \
change the way it will be played, because all sections are in the same order \
as they were before splitting. Note that the order of the sections in \
the section box is the same order they will be played out when you \
switch to the Play Chord mode, from left to right of the section box. \n\
Rearranging sections is done by copying \
and pasting them. To copy a section, first select it by clicking inside \
the grey section box below the modal buttons, then press copy. When it \
comes to pasting, you have two options: paste before or paste after \
selected section. Decide where you want to paste the copied section \
and select a section either before or after that place, then press \
Paste before or Paste after button, respectively. The new section will \
appear in the section box. All other sections will be resized smaller \
to make a space for new one.  \n\n\
\
<b>Naming and renaming sections</b>\n\n\
\
You can name and rename every section you create. The name will be displayed \
in the section box. When creating a name, you will have two options: either \
to name only selected section, or give same name to all same sections, \
created by copying and pasting. To name a section, first select it in the \
section box, then press the Re(Name) button. The window will appear first \
asking if you want to rename one section or all similar sections. After \
making this choice, you will be asked for a short name. (Obviously, long \
names will have to be truncated in the section box, so there is no point \
to make them longer than 6 - 7 characters.  \n\n\
\
<b>Joining sections</b>\n\n\
\
Joining two sections is the most complex operation in this program. Joining \
was designed to be the opposite operation for splitting. It simplifies \
the sectional structure of the sequence without changing the original \
chord information. This kind of simplification is sometimes necessary \
if you went too far with copying and pasting sections and want to step \
back safely. In order to join consecutive two sections, mark them for \
joining first by placing the selected chord in the left section \
in the chord window. The section with the selected chord in it and the \
section immediately to the right of that section will be marked for joning. \
When you are ready press Join button. The line between the left \
section and the one next to the right will disappear, indicating that these \
sections are now joined together. The similar effect will be achieved if you \
select the left section in the section box and press Join button. \n\
The join operation can only be successful, if there is at least one \
occurrence of the two sections marked for joining in the section box, \
where they are placed next to each other in the same order as as they \
are in the chord window. If there is more than one such occurrence, the \
join operation will be done on all of them. \nNote that if in the section \
box there are other occurrences of these two sections marked for joining, \
where they are separated from each other or not in the same order, they \
will be deleted to preserve structural integrity. \n\n\
\
<b>Deleting sections</b>\n\n\
\
To delete a section, first select it in the section box, then press Delete \
button. The section will be deleted only if there is another section with \
the same chord information in the section box. \n\n\
\
<b>Running multiple synthethizers</b>\n\n\
\
Sometimes you need to connect additional instrument for playing along \
with the chords. To make this happen, you will need a second Zynaddsubfx \
instance \
(or other synthesizer). In case with Zynaddsubfx, you need to do it like \
this: \n\n\
\
1 - connect your instrument to the usb by MIO 1-in 1-out USB to MIDI cable \
(or other similar)\n\n\
2 - Start second zynaddsubfx instance by the following command: \n\
<i>zynaddsubfx -I jack -O jack -a</i>\n\n\
3 - In Jack midi tab, expand second zynaddsubfx in the right pane, and \n\
4 - connect system on the left to midi_input under second zynaddsubfx in \
the right pane\n\
5 - In the Jack audio tab connect second zynaddsubfx to system\n\n\
\
Hope you enjoy using this program!") );

	Glib::ustring str5("</span></markup>");
	
	Glib::ustring combined_ustring(str0 + str1 + str2 + str3 + str4 + str5);
	
	m2_label.set_markup(combined_ustring);
	
	m1_label.set_justify(Gtk::JUSTIFY_CENTER);
	m1_label.set_line_wrap();
	m2_label.set_justify(Gtk::JUSTIFY_LEFT);
	m2_label.set_line_wrap();
	
	scroll.add(s_VBox);
	s_VBox.pack_start(m1_label);
	s_VBox.pack_start(m2_label);
	
	
	
	m_VBox.pack_start(scroll, Gtk::PACK_EXPAND_WIDGET);
	m_VBox.pack_start(m_HBox, Gtk::PACK_SHRINK);
	
	close_button.set_size_request(100, 30);
	m_HBox.pack_start(close_button, Gtk::PACK_SHRINK);
	close_button.signal_clicked().connect( sigc::mem_fun(*this, 
									&ManualWindow::on_button_close) );

	show_all_children();
}

ManualWindow::~ManualWindow()
{
}

void ManualWindow::on_button_close()
{
	hide();
}
