/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/

#ifndef GTKMM_EXAMPLEWINDOW_H
#define GTKMM_EXAMPLEWINDOW_H




#include <vector>
#include <glib.h>
#include "note.h"
#include <cstdio>
#include <fstream>
#include <gtkmm.h>
#include <cstdlib>
#include "myarea.h"
#include "RtMidi.h"
#include "mywidget.h"
#include "mybutton.h"
#include <gdkmm/rgba.h>
#include <gtkmm/fixed.h>
#include <manualwindow.h>
#include <gtkmm/hvscale.h>
#include <glibmm/refptr.h>
#include "custom_dllist.h"
#include <glibmm/ustring.h>
#include <gtkmm/separator.h>
#include <gtkmm/liststore.h>
#include <gtkmm/adjustment.h>
#include "customradiobutton.h"
#include "customradiowidget.h"
#include <gtkmm/comboboxtext.h>
#include <gtkmm/scrolledwindow.h>


class ExampleWindow : public Gtk::Window
{
public:
	ExampleWindow(const Glib::RefPtr<Gtk::Application>& app);
	virtual ~ExampleWindow();
	
		
protected:
	RtMidiOut *midiout;
	RtMidi::Api api;
	void display_note_options(Note * n);
	bool chooseMidiPort( RtMidiOut *rtmidi );
	std::vector<unsigned char> message;
	Gtk::ScrolledWindow scroll;
	Glib::RefPtr <Gtk::Adjustment> scroll_adj;
	int area_width;
	
  //Signal handlers:
	void on_save();
	bool onKeyPress(GdkEventKey* event);
	bool onKeyRelease(GdkEventKey* event);
	void on_play_chord();
	void on_stop_chord();
	void on_next_chord();
	void on_previous_chord();
	void cancel_delete_sequence(Gtk::Window* w);
	void delete_sequence_yes(Gtk::Window* wd, Glib::ustring str);
	void close_and_save(Gtk::Window* win);
	void close_and_select(Gtk::Window* win, Glib::ustring * str);
	void close_and_new(Gtk::Window* win);
	void rename_current_sequence(Gtk::Window* window);
	void cancel_rename_current_sequence(Gtk::Window* window);
	void just_save_current_sequence(Gtk::Window* win);
	void save_current_sequence(Gtk::Entry *name);
	void select_sequence(Gtk::TreeView * view);
	void delete_sequence(Gtk::TreeView * view);
	void load_sequence(Glib::ustring * str);
	void new_sequence();
	void cancel_sequence();
	void on_copy_chord();
	void on_paste_chord();
	void on_set_velocity();
	void on_new_chord();
	void on_delete_chord();
	void on_button_quit();
	void read_saved_file();
	void new_chord_before_selected();
	std::string trim(const std::string& str);
	void on_inst_combo_changed();
	bool on_box_enter(GdkEventCrossing* crossing_event, int data);
	bool on_box_leave(GdkEventCrossing* crossing_event, int data);
	bool on_key_pressed(GdkEventButton* button_event, int data);
	
	bool on_note_edit_clicked(GdkEventButton* button_event);
	bool on_note_edit_leave(GdkEventCrossing* crossing_event);
	bool on_note_edit_enter(GdkEventCrossing* crossing_event);
	
	bool on_sequence_clicked(GdkEventButton* button_event);
	bool on_sequence_leave(GdkEventCrossing* crossing_event);
	bool on_sequence_enter(GdkEventCrossing* crossing_event);
	
	bool on_chord_edit_clicked(GdkEventButton* button_event);
	bool on_chord_edit_leave(GdkEventCrossing* crossing_event);
	bool on_chord_edit_enter(GdkEventCrossing* crossing_event);
	
	bool on_chord_play_clicked(GdkEventButton* button_event);
	bool on_chord_play_leave(GdkEventCrossing* crossing_event);
	bool on_chord_play_enter(GdkEventCrossing* crossing_event);
	
	bool on_sections_clicked(GdkEventButton* button_event);
	bool on_sections_leave(GdkEventCrossing* crossing_event);
	bool on_sections_enter(GdkEventCrossing* crossing_event);
	
	bool on_chord_button_pressed(GdkEventButton* button_event, int data);
	bool on_chord_button_leave(GdkEventCrossing* crossing_event, int data);
	bool on_chord_button_enter(GdkEventCrossing* crossing_event, int data);
	
	bool on_mult_select_clicked(GdkEventButton* button_event);
	bool on_mult_select_leave(GdkEventCrossing* crossing_event);
	bool on_mult_select_enter(GdkEventCrossing* crossing_event);
	
	bool on_area_clicked(GdkEventButton* button_event);
	bool on_play_radio_clicked(GdkEventButton* button_event, int pos);
	bool on_display_radio_clicked(GdkEventButton* button_event, int data);
	int findMidiNumber(int number);
	
	// section functions and variables
	void split_section();
	void recalculate_section_buttons();
	bool on_section_buttons_clicked(GdkEventButton* button_event,
								MyButton * button);
	bool on_section_buttons_enter(GdkEventCrossing* crossing_event,
							MyButton * button);
	bool on_section_buttons_leave(GdkEventCrossing* crossing_event,
								MyButton * button);
	void copy_section();
	void paste_before_section();
	void paste_after_section();
	void clear_new_sequence();
	void delete_section();
	void delete_section_yes(Gtk::Window* window);
	void cancel_delete_section(Gtk::Window* window); 
	void update_section_buttons();
	void join_sections();
	void name_sections();
	void name_one_section(Gtk::Window* window);
	void name_similar_sections(Gtk::Window* window);
	void actually_name_one_section(Gtk::Window* window,  Gtk::Entry * name);
	void actually_name_similar_sections(Gtk::Window* window,  Gtk::Entry * name);
	void cancel_rename_section(Gtk::Window* window);
	Glib::ustring * copy_ustring(Glib::ustring * original);
	Dlnode * copied_section;
	Dlnode * selected_section;
	Sequence * copy_sequence(Sequence * sequence_to_copy);
	Sequence * copy_all_sequences(Sequence * seque_to_copy);
	Gtk::Window * ausure_dialog, * rename_sec_dialog;
	Gtk::Window * rename_section_dialog, * rename_sections_dialog;
	Gtk::HBox section_HBox;
	
		// section edit buttons

	Gtk::HBox section_edit_top_HBox, section_edit_bottom_HBox;
	Gtk::Button split_section_button, delete_section_button;
	Gtk::Button join_section_button, copy_section_button;
	Gtk::Button paste_after_section_button, paste_before_section_button;
	Gtk::Button name_section_button;
	
	void save_all();
	
	//Inner class tree model columns:
	class ModelColumns : public Gtk::TreeModel::ColumnRecord
	{
	public:
		ModelColumns()
		{ add(m_col_id); add(m_col_name); }
		Gtk::TreeModelColumn<int> m_col_id;
		Gtk::TreeModelColumn<Glib::ustring> m_col_name;
	};
	ModelColumns m_Columns;
	
public:
	// Inner class SequenceWindow
	class SequenceWindow : public Gtk::Window
	{
	public:
		SequenceWindow();
		virtual ~SequenceWindow();
	
		//Inner Inner class tree model columns:
		class ModelColumns : public Gtk::TreeModel::ColumnRecord
		{
		public:
			ModelColumns()
			{ add(m_col_id); add(m_col_name); }
			
			Gtk::TreeModelColumn<unsigned int> m_col_id;
			Gtk::TreeModelColumn<Glib::ustring> m_col_name;
		};
		ModelColumns m_Columns;
		
		//Child widgets:
		void update();
		Gtk::VBox m_VBox;
		Gtk::ScrolledWindow m_ScrolledWindow;
		Gtk::TreeView m_TreeView;
		Glib::RefPtr<Gtk::ListStore> m_refTreeModel;
		Gtk::HButtonBox m_ButtonBox;
	
		Gtk::Button m_Button_Select, m_Button_Delete, m_Button_New, m_Button_Cancel;
	};
		
	// Inner class KeyShortcutsWindow
	class KeyShortcutsWindow : public Gtk::Window
	{
	public:
		KeyShortcutsWindow();
		virtual ~KeyShortcutsWindow();
		int two_key_search(guint first_key, guint second_key, guint two_d_array[6][2]);
		void on_learn_button_clicked( int data);
		bool onSKeyPress(GdkEventKey* event);
		bool onSKeyRelease(GdkEventKey* event);
		void save_shortcut(guint key, guint two_d_array[6][2], int index);
		void save_two_shortcuts(guint first_key, guint second_key, 
						guint two_d_array[6][2], int index);
		void on_close_button_clicked();
							
		void read_shortcuts_file();
		void write_shortcuts_file();
		std::string trim(const std::string& str);
		bool shortcuts_changed;
		Glib::ustring * shortcut_strings[6];
		guint shortcut_keys[6][2];
		guint number_of_shortcuts;
		int total_keys_pressed;
		int shortcut_keys_pressed;
		guint first_key_guint;
		bool learn_mode;
		int learn_index;
		int learn_keys_pressed;
		guint first_learn_key_pressed;
		
		Gtk::Grid ks_grid;
		Gtk::HSeparator sep, sep1;
		Glib::ustring doc_label_string;
		Gtk::Label doc_label, command_label, shortcut_label;
		Gtk::Label play_label, stop_label, previous_label, new_label;
		Gtk::Label copy_label, paste_label;
		
		Gtk::Entry * entries[6];
		Gtk::Entry play_entry, stop_entry, previous_entry, new_entry;
		Gtk::Entry copy_entry, paste_entry;
		Gtk::Button learn_play_button, learn_stop_button;
		Gtk::Button learn_previous_button, learn_new_button;
		Gtk::Button learn_copy_button, learn_paste_button;
	
		Gtk::Button button_close;
	};
	
	KeyShortcutsWindow ks_window;
	
protected:		
  //Child widgets:
	Gtk::Allocation all;
	MyArea area;
	Gtk::Fixed fixed_board;
	Gtk::HBox m_HBox, button_chords_HBox, v_button_chords_HBox;
	Gtk::HBox chord_edit_button_box, sequence_button_box;
	Gtk::HBox note_edit_button_box, chord_play_button_box;
	Gtk::VBox  area_VBox;
	Gtk::Box main_VBox;
	
  MyWidget * keys[84];
  Gtk::EventBox n_EventBox; // this is weird: if I delete this line, 
							// I get segmentation error, event though
							// variable is not used ???
  Gtk::EventBox * boxes[108];
  Gtk::EventBox * chord_buttons[64];
  Gtk::EventBox * box_note_edit;
  Gtk::EventBox * box_sequence;
  Gtk::EventBox * box_chord_edit;
  Gtk::EventBox * box_chord_play;
  Gtk::EventBox * box_mult_select;
  Gtk::EventBox * box_sections;
  
  Gtk::HBox m_ButtonHBox, modal_button_HBox, scale_HBox;
  Gtk::VBox note_chord_play_radio_box, modal_button_VBox, scroll_VBox;
  
 
      
  // these buttons are always visible
  Gtk::Button m_Button_Quit;
  Gtk::Button  save_button;
  Gtk::Window * save_dialog, * rename_dialog, * save_or_not_dialog, * areusure_dialog;
  
   std::pair <int,int> pairs[30];
   int mode;
   int selected_chord_number; // counts from 1
   Glib::ustring output;
   int channel; // counts from 1
   Glib::ustring * current_sequence_name;
   bool multiple_select;
   Dlnode * selected_notes, * copied_chord;
   Note * dummy_selected_note;
   Note * selected_note;
   bool is_sequence_named;
   bool playing;
   
   	
	MyButton * chord_radio_buttons[64];

	// modal radio buttons
	MyButton * mode_note_edit_button;
	MyButton * mode_sequence_button;
	MyButton * mode_chord_edit_button;
	MyButton * mode_chord_play_button;
	MyButton * mode_sections_button;
	
	MyButton * mult_select_b;
	
	// chord edit buttons
	Gtk::Button  new_chord_button;
	Gtk::Button  delete_chord_button;
	Gtk::Button  copy_chord_button;
	Gtk::Button  paste_chord_button;
	
	// chord play buttons
	Gtk::Button  next_chord_button;
	Gtk::Button  previous_chord_button;
	Gtk::Button  play_button;
	Gtk::Button  stop_button;

	// sequence select/edit buttons
	Gtk::Button  new_seq_button;
	Gtk::Button  delete_seq_button;
	Gtk::Button  select_seq_button;
	Gtk::Button  next_seq_button; // not used
	
	//note edit buttons
	CustomRadioButton spacer_rad, play_note_rad, play_chord_rad, dont_play_rad;
	Gtk::HScale * sc;
	const Glib::RefPtr< Gtk::Adjustment> adj;
	Gtk::Button set_velocity_b;
	
	Gtk::HBox note_HBox, instrument_HBox;
	typedef CustomRadioButton CustomLabel;
	CustomLabel note_label, instrument_label;
	CustomLabel separator1, separator2;
	CustomRadioButton normal_rad, sharp_rad, flat_rad;
	CustomRadioButton sharpsharp_rad, flatflat_rad;
	CustomRadioButton display_group[5];
	Gtk::VBox display_VBox;
	Glib::RefPtr<Gtk::ListStore> m_refTreeModel;
	Gtk::ComboBox inst_combo;
	SequenceWindow s_win;
	ManualWindow manual;
	
    
	Glib::RefPtr<Gio::SimpleActionGroup> m_refActionGroup;
	Glib::RefPtr<Gio::SimpleAction> m_refActionRain;
	
	void on_action_keyboard_shortcuts();
	void on_action_select_sequence();
	void about_sequencer();
	void on_action_play_chord();
	void on_action_next_chord();
	void on_action_previous_chord();
	void on_action_stop_chord();
	void on_action_copy_chord();
	void on_action_paste_chord();
	void on_action_new_chord();
	void on_action_delete_chord();
	void on_action_select_chord();
	void on_action_select_note();
	void on_action_deselect_note();
	void on_action_new_note();
	void on_action_delete_note();
	void show_manual();
	void on_channel_change(Gtk::RadioMenuItem * item, int index);
	void read_channel_file();
	void activate_command(int index);

	Glib::RefPtr<Gtk::AccelGroup> accel_group;
	
	Gtk::Box menu_box;
	Gtk::MenuBar * menubar;
	
    Gtk::MenuItem * application_menu_item;
    Gtk::Menu * application_submenu;
    Gtk::MenuItem * shortcuts_subitem;
    Gtk::MenuItem * about_subitem;
    Gtk::MenuItem * quit_subitem;
    
    Gtk::MenuItem * sequence_menu_item;
    Gtk::Menu * sequence_submenu;
    Gtk::MenuItem * select_seq_subitem;
    Gtk::MenuItem * new_seq_subitem;
    Gtk::MenuItem * save_seq_subitem;
    Gtk::MenuItem * rename_seq_subitem;
    
    Gtk::MenuItem * chord_menu_item;
    Gtk::Menu * chord_submenu;
    Gtk::MenuItem * new_chord_subitem;
    Gtk::MenuItem * new_before_chord_subitem;
    Gtk::MenuItem * copy_chord_subitem;
    Gtk::MenuItem * paste_chord_subitem;
    Gtk::MenuItem * delete_chord_subitem;
    Gtk::MenuItem * play_chord_subitem;
    Gtk::MenuItem * next_chord_subitem;
    Gtk::MenuItem * previous_chord_subitem;
    Gtk::MenuItem * stop_chord_subitem;
    Gtk::MenuItem * select_chord_subitem; 
    
    Gtk::MenuItem * note_menu_item;
    Gtk::Menu * note_submenu;
    
    Gtk::MenuItem * select_note_subitem;
    Gtk::MenuItem * deselect_note_subitem;
    Gtk::MenuItem * new_note_subitem;
    Gtk::MenuItem * delete_note_subitem;
    
    Gtk::MenuItem * help_menu_item;
    Gtk::Menu * help_submenu;
    Gtk::MenuItem * manual_subitem;
    
    Gtk::MenuItem * channel_subitem;
    Gtk::Menu * channel_submenu;
    Gtk::RadioMenuItem * radio_menu_items[16];
	
    
    Gtk::MenuItem * menu_items_with_shotrcuts[6];
    
	void update_menu_labels();
  
};

#endif //GTKMM_EXAMPLEWINDOW_H
