/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details. 
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/

#include "examplewindow.h"
#include <iostream>
#include <stdio.h>
#include "note.h"
#include <glib.h>
#include <cstdio>
#include <fstream>
#include <cstdlib>
#include "RtMidi.h"
#include "myarea.h"
#include <config.h>
#include "gettext.h"
#include <gtk/gtk.h>
#include "mybutton.h"
#include <gdkmm/rgba.h>
#include <gtkmm/fixed.h>
#include <gtkmm/frame.h>
#include <glib/gprintf.h>
#include <gtkmm/hvscale.h>
#include <glibmm/refptr.h>
#include "custom_dllist.h"
#include <glibmm/ustring.h>
#include <gdk/gdkkeysyms.h>
#include <gtkmm/separator.h>
#include <gtkmm/liststore.h>
#include <gtkmm/adjustment.h>
#include "customradiobutton.h"
#include "customradiowidget.h"
#include <gtkmm/comboboxtext.h>
#include <gtkmm/scrolledwindow.h>
#include "globals.h"


#include <unicode/schriter.h>
#include <unicode/brkiter.h>
#include <iostream>
#include <cassert>
#include <memory>

#define _(string) gettext (string)

// to install from shell:
// change directory to sequencer-1.1: 
// cd sequencer-1.1
// inside sequencer-1.1 directory run:
// (this creates the configure script)
// $ autoreconf --verbose --install --force
// $ ./configure --with-jack
// (or if you want alsa, run $ ./configure --with-alsa, which is not recommended)
// $  make 

// At this point you will be able to run the program. No need to install it,
// just run as described below from the directory you downloaded it to.
// Don't close terminal window yet.


// To run program:
// open jack and start it. (I am using qjackctl for this, there are other ways too)
// In the still open terminal window, 
// change directory to sequencer-1.1/src:
// cd src
// inside sequencer-1.1/src run
// ./sequencer

// This should do it. If you did everything correctly, at this moment 
// you will see the graphical interface.


// This program is best paired with zynaddsubfx synthesizer:
// To connect to zynaddsubfx:
// zynaddsubfx -I jack -O jack -a
// connect Chord Sequencer to zynaddsubfx->midi_input (MIDI tab in jack)
// connect zynaddsubfx to system (Audio tab in jack)
// change midi input channel in zynaddsubfx to 2

// To connect additional instrument for playing along with the chords:
// connect it to the usb by MIO 1-in 1-out USB to MIDI cable
// Start second zynaddsubfx -I alsa -O jack -a
// In Jack midi tab, expand zynaddsubfx in the right pane, and 
// connect system to midi_input under zynaddsubfx in the right pane
// In the Jack audio tab connect zynaddsubfx to system

// the whole project is 11700 lines in 24 files
// Author : Copyright (c) 2017-2018 Marvin Eagle (except for RtMidi library,
// which has it's own authors)
// Chord Sequencer Version  1.1 completed September 2, 2018

// This is an old way of compiling, do not use it:
// Old compile line:
// g++ -D__UNIX_JACK__ -o sequencer sequencer.cpp RtMidi.cpp customradiobutton.cpp  examplewindow.cpp  myarea.cpp  mybutton.cpp  mywidget.cpp  note.cpp  -ljack -lasound -lpthread `pkg-config gtkmm-3.0 --cflags --libs`
// End of the old way of compiling

// Platform-dependent sleep routines.
#if defined(__WINDOWS_MM__)
  #include <windows.h>
  #define SLEEP( milliseconds ) Sleep( (DWORD) milliseconds ) 
#else // Unix variants
  #include <unistd.h>
  #define SLEEP( milliseconds ) usleep( (unsigned long) (milliseconds * 1000.0) )
#endif


extern Dlnode * g_sequences;

ExampleWindow::ExampleWindow(const Glib::RefPtr<Gtk::Application>& app)
: 	m_HBox(false, 0),
	main_VBox( Gtk::ORIENTATION_VERTICAL,0),
	m_Button_Quit(_("Quit") ),
	save_button(_("Save") ),
	// chord edit buttons
	new_chord_button(_("New\nChord") ),
	delete_chord_button(_("Delete\nChord") ),
	copy_chord_button(_("Copy chord") ),
	paste_chord_button(_("Paste chord") ),
	// chord play buttons
	next_chord_button(_("Next chord") ),
	previous_chord_button(_("Previous chord") ),
	play_button(_("Play") ),
	stop_button(_("Stop ") ),
	
	area(),
	fixed_board(),
	button_chords_HBox(),
	modal_button_HBox(),
	modal_button_VBox(),
	
	
	// button boxes which will toggled  hidden or visible
	chord_edit_button_box(),
	chord_play_button_box(), 
	note_edit_button_box(),
	sequence_button_box(),
	note_chord_play_radio_box(Gtk::Orientation::ORIENTATION_VERTICAL),
	
	// note edit buttons
	spacer_rad(),
	play_note_rad(),
	play_chord_rad(),
	dont_play_rad(),
	adj ( Gtk::Adjustment::create(0.0, 0.0, 128.0, 0.1, 1.0, 1.0) ),
	note_HBox(),
	instrument_HBox(),
	note_label(),
	instrument_label(),
	separator1(),
	separator2(),
	display_VBox(),
	normal_rad(),
	sharp_rad(),
	flat_rad(),
	sharpsharp_rad(),
	flatflat_rad(),
	scale_HBox(),
	set_velocity_b(_("Set velocity") ),
	message(),
	scroll(),
	scroll_VBox(),
	output(),
	current_sequence_name(),
	s_win(), 
	ks_window(),
	menu_box(),
	menubar(),
	manual(),
	radio_menu_items(),
	section_edit_top_HBox(),
	section_edit_bottom_HBox(),
	split_section_button(_("Split") ),
	delete_section_button(_("Delete") ),
	copy_section_button(_("Copy") ),
	paste_before_section_button(_("Paste before") ),
	paste_after_section_button(_("Paste after") ),
	join_section_button(_("Join") ),
	name_section_button(_("(Re)Name") ),
	section_HBox()

{

	
	
	
	
	midiout = 0; 
	api = RtMidi::UNSPECIFIED;
	// RtMidiOut constructor
	try
	{
		//midiout = new RtMidiOut(api);
		midiout = new RtMidiOut(api, "Chord Sequencer");
	}
	catch ( RtMidiError &error )
	{
		error.printMessage();
		exit( EXIT_FAILURE );
	}

	 // Call function to select port.
	try 
	{
		//chooseMidiPort(midiout);
		std::cout << "\n" << _("Opening virtual port") << "\n";
		midiout->openVirtualPort();
		
	}
	catch ( RtMidiError &error )
	{
		error.printMessage();
	}
	
	read_channel_file(); // sets the channel variable
	
	// Program change: 192, 5 = changes the instrument
	// Use Zynaddsubfx Ultra Soft instrument from the Collection bank
	message.push_back( 192 + channel - 1);
	message.push_back( 19 );
	midiout->sendMessage( &message );
	
	//  Quarter Frame message
	message[0] = 0xF1;
	message[1] = 60;
	midiout->sendMessage( &message );

	// Control Change: 176, 7, 100 (volume)
	message[0] = 176  + channel - 1;
	message[1] = 7;
	message.push_back( 100 );
	midiout->sendMessage( &message );
	
	// Poly on message
	message[0] = 176  + channel - 1;
	message[1] =  127;
	message[2] = 0;
	midiout->sendMessage( &message );
	
	// to turn off key repeat (which interprets holding down a key as a
	// multiple key presses) type at the terminal: xset r off
	int s = system("xset r off");
	
	mode = 1; // 1 for "Edit chord"
			//  2 for "Play chord"
			//  3 for "Edit note"
			//  4 for "Sequence"
	selected_chord_number = 1; // corresponds to the element # 0 in 
						// Dlist area.current_sequence
	multiple_select = false;
	set_title("Chord Sequencer");
	playing = false;
	
	
	this->signal_key_press_event().connect(
		sigc::mem_fun(*this, &ExampleWindow::onKeyPress), false);
	this->signal_key_release_event().connect(
		sigc::mem_fun(*this, &ExampleWindow::onKeyRelease), false);
	
	
	for (int i=0; i<83; i++)
	{
		keys[i] = new MyWidget(); // index 0 will be ignored
	}
	for (int i=0; i<79; i++)
	{
		boxes[i] = new Gtk::EventBox(); // index 0 will be ignored
	}
	
	// Dlnode selected_notes always has at least one note, 
	// which is not counted or displayed
	selected_note = NULL;
	selected_notes = Dlist::dl_create();
	dummy_selected_note = new Note(-1000);
	selected_notes->data = dummy_selected_note;
	copied_chord = NULL;
	is_sequence_named = false;
	
	
	/////////////// SETUP GUI ////////////////
	
	
	ks_window.shortcut_strings[0] =  new Glib::ustring(_("Play Chord") );
	ks_window.shortcut_strings[1] =  new Glib::ustring(_("Previous Chord") );
	ks_window.shortcut_strings[2] =  new Glib::ustring(_("Stop Chord") );
	ks_window.shortcut_strings[3] =  new Glib::ustring(_("New Chord") );
	ks_window.shortcut_strings[4] =  new Glib::ustring(_("Copy Chord") );
	ks_window.shortcut_strings[5] =  new Glib::ustring(_("Paste Chord") );
	
	ks_window.read_shortcuts_file();
	// ks_window.play_entry.set_text( *(new Glib::ustring("3") ) );
	
	mode_note_edit_button = new MyButton();
	mode_sequence_button = new MyButton();
	mode_chord_edit_button = new MyButton();
	mode_chord_play_button = new MyButton();
	mode_sections_button = new MyButton();
	
	mode_chord_edit_button->pressed = true; // start with "Edit chord" mode
	mult_select_b = new MyButton();
	
	
	box_note_edit = new Gtk::EventBox();
	box_sequence = new Gtk::EventBox();
	box_chord_edit = new Gtk::EventBox();
	box_chord_play = new Gtk::EventBox();
	box_sections = new Gtk::EventBox();
	
	box_mult_select = new Gtk::EventBox();
	
	// sc is a note velocity scale
	sc = new Gtk::HScale(adj);
	sc->set_draw_value(true);
	sc->set_sensitive(false);
	sc->set_digits(0);
	sc->set_value_pos(Gtk::POS_TOP);
	sc->set_size_request(180, -1);
		
	set_border_width(6);
	set_default_size(900, 200);
	set_size_request(900, 200);
	area_width = 3392;
	area.set_size_request (area_width, 522);
	scroll.set_size_request(848, 550);
	scroll.add(scroll_VBox); // this is container for area and button_chords_HBox
	scroll_VBox.pack_start(area, Gtk::PACK_SHRINK, 0);
	scroll_VBox.pack_start(button_chords_HBox, Gtk::PACK_SHRINK, 0);
	scroll_adj = scroll.get_hadjustment();
	
	add(main_VBox); // This is main Vertical Box. It has only two rows:
				// one is menu bar and second is fixed_board
				
	
	// setup menu			
	menu_box.set_orientation(Gtk::ORIENTATION_VERTICAL);
	application_menu_item = Gtk::manage(new Gtk::MenuItem(_("Application") ) ); 
	application_submenu = Gtk::manage(new Gtk::Menu);
	application_menu_item->set_submenu(*application_submenu); 
		
    shortcuts_subitem = Gtk::manage(new Gtk::MenuItem(_("Keyboard Shortcuts") ) );
    application_submenu->append(*shortcuts_subitem);
    
    channel_subitem = Gtk::manage(new Gtk::MenuItem(_("Midi Output Channel") ) );
    application_submenu->append(*channel_subitem);
    
    channel_submenu = Gtk::manage(new Gtk::Menu);
    channel_subitem->set_submenu(*channel_submenu);
    
    Gtk::RadioButton::Group group;
    Gtk::RadioMenuItem::Group gr = (Gtk::RadioMenuItem::Group) group;
   												
    
    for(int i = 0; i< 16; i++)
    {
		std::string s = std::to_string(i+1);
		char const * pchar = s.c_str();
		
		Glib::ustring ustr(pchar);
		radio_menu_items[i] = Gtk::manage(new Gtk::RadioMenuItem(gr, ustr, false));
		channel_submenu->append(*radio_menu_items[i] );
		if(channel - 1 == i)
			radio_menu_items[i]->set_active(true);
		
		radio_menu_items[i]->signal_activate().connect
					(sigc::bind<Gtk::RadioMenuItem*, int > (sigc::mem_fun( *this,
					&ExampleWindow::on_channel_change), radio_menu_items[i], i ) );
	}
    
    about_subitem = Gtk::manage(new Gtk::MenuItem(_("About Chord Sequencer") ) );
    application_submenu->append(*about_subitem);
    
    quit_subitem = Gtk::manage(new Gtk::MenuItem(_("Quit") ) );
    application_submenu->append(*quit_subitem);
    
    sequence_menu_item = Gtk::manage(new Gtk::MenuItem(_("Sequence") ) );
    sequence_submenu = Gtk::manage(new Gtk::Menu);
    sequence_menu_item->set_submenu(*sequence_submenu);
    
    select_seq_subitem = Gtk::manage(new Gtk::MenuItem(_("Select Sequence") ) );
    sequence_submenu->append(*select_seq_subitem);
    
    new_seq_subitem = Gtk::manage(new Gtk::MenuItem(_("New Sequence") ) );
    sequence_submenu->append(*new_seq_subitem);
    
    save_seq_subitem = Gtk::manage(new Gtk::MenuItem(_("Save Sequence") ) );
    sequence_submenu->append(*save_seq_subitem);
    
    rename_seq_subitem = Gtk::manage(new Gtk::MenuItem(_("Rename Sequence") ) );
    sequence_submenu->append(*rename_seq_subitem);
    
    chord_menu_item = Gtk::manage(new Gtk::MenuItem(_("Chord") ) );
    chord_submenu = Gtk::manage(new Gtk::Menu);
    chord_menu_item->set_submenu(*chord_submenu);
    
    new_chord_subitem = Gtk::manage(new Gtk::MenuItem(_("New Chord" ) ) );
    chord_submenu->append(*new_chord_subitem);
    new_chord_subitem->set_hexpand( true);
    
    new_before_chord_subitem = Gtk::manage(new Gtk::MenuItem(_("New Chord Before Selected" ) ) );
    chord_submenu->append(*new_before_chord_subitem);
    new_before_chord_subitem->set_hexpand( true);
      
    copy_chord_subitem = Gtk::manage(new Gtk::MenuItem(_("Copy Chord") ) );
    chord_submenu->append(*copy_chord_subitem);
    copy_chord_subitem->set_hexpand( true);
    
    paste_chord_subitem = Gtk::manage(new Gtk::MenuItem(_("Paste Chord") ) );
    chord_submenu->append(*paste_chord_subitem);
    paste_chord_subitem->set_hexpand( true);
    
    delete_chord_subitem = Gtk::manage(new Gtk::MenuItem(_("Delete Chord") ) );
    chord_submenu->append(*delete_chord_subitem);
    delete_chord_subitem->set_hexpand( true);
    
    select_chord_subitem = Gtk::manage(new Gtk::MenuItem(_("Select Chord") ) );
    chord_submenu->append(*select_chord_subitem);
    select_chord_subitem->set_hexpand( true);
    
    play_chord_subitem = Gtk::manage(new Gtk::MenuItem(_("Play Chord") ) );
    chord_submenu->append(*play_chord_subitem);
    play_chord_subitem->set_hexpand( true);
    
    next_chord_subitem = Gtk::manage(new Gtk::MenuItem(_("Next Chord") ) );
    chord_submenu->append(*next_chord_subitem);
    next_chord_subitem->set_hexpand( true);
    
    previous_chord_subitem = Gtk::manage(new Gtk::MenuItem(_("Previous Chord") ) );
    chord_submenu->append(*previous_chord_subitem);
    previous_chord_subitem->set_hexpand( true);
    
    stop_chord_subitem = Gtk::manage(new Gtk::MenuItem(_("Stop All Sounds") ) );
    chord_submenu->append(*stop_chord_subitem);
    stop_chord_subitem->set_hexpand( true);
    
    note_menu_item = Gtk::manage(new Gtk::MenuItem(_("Note") ) );
    note_submenu = Gtk::manage(new Gtk::Menu);
    note_menu_item->set_submenu(*note_submenu);
    
    new_note_subitem = Gtk::manage(new Gtk::MenuItem(_("New Note") ) );
    note_submenu->append(*new_note_subitem);
    new_note_subitem->set_hexpand( true);
    
    delete_note_subitem = Gtk::manage(new Gtk::MenuItem(_("Delete Note") ) );
    note_submenu->append(*delete_note_subitem);
    delete_note_subitem->set_hexpand( true);
    
    select_note_subitem = Gtk::manage(new Gtk::MenuItem(_("Select Note") ) );
    note_submenu->append(*select_note_subitem);
    select_note_subitem->set_hexpand( true);
    
    deselect_note_subitem = Gtk::manage(new Gtk::MenuItem(_("Deselect Note") ) );
    note_submenu->append(*deselect_note_subitem);
    deselect_note_subitem->set_hexpand( true);
    
    help_menu_item = Gtk::manage(new Gtk::MenuItem(_("Help") ) );
    help_submenu = Gtk::manage(new Gtk::Menu);
    help_menu_item->set_submenu(*help_submenu);
    
    manual_subitem = Gtk::manage(new Gtk::MenuItem(_("Read Manual") ) );
    help_submenu->append(*manual_subitem);
    manual_subitem->set_hexpand( true);
    
 	menubar = Gtk::manage(new Gtk::MenuBar);
    menubar->append(*application_menu_item);
    menubar->append(*sequence_menu_item);
    menubar->append(*chord_menu_item);
    menubar->append(*note_menu_item);
    menubar->append(*help_menu_item);
    menu_box.add(*menubar);
    
    
    
    main_VBox.pack_start(menu_box,  Gtk::PACK_SHRINK, 0);
    
    menu_items_with_shotrcuts[0] = play_chord_subitem;
    menu_items_with_shotrcuts[1] = previous_chord_subitem;
    menu_items_with_shotrcuts[2] = stop_chord_subitem;
    menu_items_with_shotrcuts[3] = new_chord_subitem;
    menu_items_with_shotrcuts[4] = copy_chord_subitem;
    menu_items_with_shotrcuts[5] = paste_chord_subitem;
 
	
	// connect menu actions and create shortcuts
	
	shortcuts_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_keyboard_shortcuts) ) );
	about_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::about_sequencer) ) );
	quit_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_button_quit) ) );
	select_seq_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_select_sequence) ) );		
	new_seq_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::new_sequence) ) );
	save_seq_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_save) ) );
	rename_seq_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_save) ) );
	
	new_chord_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_new_chord) ) );
	new_before_chord_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::new_chord_before_selected) ) );
	copy_chord_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_copy_chord) ) );
	paste_chord_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_paste_chord) ) );
	delete_chord_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_delete_chord) ) );
	select_chord_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_select_chord) ) );
	play_chord_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_play_chord) ) );
	next_chord_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_next_chord) ) );
	previous_chord_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_previous_chord) ) );
	stop_chord_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_stop_chord) ) );
	select_note_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_select_note) ) );				
	deselect_note_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_deselect_note) ) );
	new_note_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_new_note) ) );
	delete_note_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::on_action_delete_note) ) );
	manual_subitem->signal_activate().connect(
					(sigc::mem_fun(*this, &ExampleWindow::show_manual) ) );

	
	// set labels for subitems that have a shortcut
	update_menu_labels();
	// update labels when shortcuts changed
	ks_window.signal_hide().connect(sigc::mem_fun(*this,
							&ExampleWindow::update_menu_labels) );
	   
    			
		
	fixed_board.set_size_request(944, 626);
	
	main_VBox.pack_start(fixed_board,  Gtk::PACK_SHRINK, 0);
	//main_VBox.pack_start(note_chord_play_radio_box, Gtk::PACK_SHRINK, 0);
	play_note_rad.inner->set_size_request(100, 20);
	play_chord_rad.inner->set_size_request(100, 20);
	dont_play_rad.inner->set_size_request(100, 20);
	spacer_rad.inner->type = 1; // spacer
	play_note_rad.inner->type = 2; 
	play_note_rad.inner->name = 1;
	play_chord_rad.inner->type = 2;
	play_chord_rad.inner->name = 2;
	dont_play_rad.inner->type = 2;
	dont_play_rad.inner->name = 3;
	
	// name enumerated here
	/////////////////////////
	sharpsharp_rad.inner->name = 6;
	sharp_rad.inner->name = 7;
	normal_rad.inner->name = 8;
	flat_rad.inner->name = 9;
	flatflat_rad.inner->name = 10;
	
	display_group[4] = sharpsharp_rad;
	display_group[3] = sharp_rad;
	display_group[2] = normal_rad;
	display_group[1] = flat_rad;
	display_group[0] = flatflat_rad;
	
	for(int i=0; i<5; i++)
		display_group[i].inner->type = 2;
	for(int i=0; i<5; i++)
		display_group[i].inner->set_size_request(75, 20);
	normal_rad.inner->active = true;	
	
	note_label.inner->type = 4;
	note_label.inner->name = 4;
	instrument_label.inner->type = 4;
	instrument_label.inner->name = 5;
	instrument_label.inner->set_size_request(80, 25);
	note_label.inner->set_size_request(80, 25);
	
	spacer_rad.inner->set_size_request(100, 15);
	note_chord_play_radio_box.pack_start(*spacer_rad.e_box, Gtk::PACK_SHRINK, 0);
	note_chord_play_radio_box.pack_start(*play_note_rad.e_box, Gtk::PACK_SHRINK, 0);
	note_chord_play_radio_box.pack_start(*play_chord_rad.e_box, Gtk::PACK_SHRINK, 0);
	note_chord_play_radio_box.pack_start(*dont_play_rad.e_box, Gtk::PACK_SHRINK, 0);	
	dont_play_rad.inner->active = true;
	fixed_board.put(note_chord_play_radio_box, 540, 538);
	
	fixed_board.put(scroll, 96, 0);
	
	for (int i=0; i<64; i++)
	{
		chord_buttons[i] = new Gtk::EventBox();
		chord_radio_buttons[i] = new MyButton();
		chord_radio_buttons[i]->set_size_request(53, 12);
		chord_radio_buttons[i]->button_type = 1; // chord_radio_button
		button_chords_HBox.pack_start(*chord_buttons[i], Gtk::PACK_SHRINK, 0 );
		chord_buttons[i]->add(*chord_radio_buttons[i]);
	}
	chord_radio_buttons[0]->pressed = true;
	chord_radio_buttons[0]->occupied = true;
		
	// Modal buttons
	mode_note_edit_button->set_size_request(80, 24);
	mode_sequence_button->set_size_request(80, 24);
	mode_chord_edit_button->set_size_request(80, 24);
	mode_chord_play_button->set_size_request(80, 24);
	mode_sections_button->set_size_request(80, 24);
	mult_select_b->set_size_request(80, 24);
	mult_select_b->set_margin_top(5);
	
	mode_note_edit_button->button_name = 3;
	mode_sequence_button->button_name = 4;
	mode_chord_edit_button->button_name = 1;
	mode_chord_play_button->button_name = 2;
	mult_select_b->button_name = 5;
	mode_sections_button->button_name = 6;
	
	mode_note_edit_button->button_type = 2; // modal button
	mode_sequence_button->button_type = 2; // modal button
	mode_chord_edit_button->button_type = 2; // modal button
	mode_chord_play_button->button_type = 2; // modal button 
	mode_sections_button->button_type = 2;  // modal button
	mult_select_b->button_type = 3; 
	
	
	modal_button_VBox.pack_start(modal_button_HBox, Gtk::PACK_SHRINK, 0);
	modal_button_HBox.pack_start(*box_chord_edit, Gtk::PACK_SHRINK, 4);
	box_chord_edit->add(*mode_chord_edit_button);
	modal_button_HBox.pack_start(*box_chord_play, Gtk::PACK_SHRINK, 4);
	box_chord_play->add(*mode_chord_play_button);
	modal_button_HBox.pack_start(*box_note_edit, Gtk::PACK_SHRINK, 4); 
	box_note_edit->add(*mode_note_edit_button);
	modal_button_HBox.pack_start(*box_sections, Gtk::PACK_SHRINK, 4);
	box_sections->add(*mode_sections_button);
	modal_button_HBox.pack_start(*box_sequence, Gtk::PACK_SHRINK, 4); 
	box_sequence->add(*mode_sequence_button);
	
	modal_button_VBox.pack_start(scale_HBox,  Gtk::PACK_SHRINK, 0);
	scale_HBox.pack_start(*sc, Gtk::PACK_SHRINK, 6);
	box_mult_select->add(*mult_select_b);
	scale_HBox.pack_start(set_velocity_b, Gtk::PACK_SHRINK, 0);
	scale_HBox.pack_start(*box_mult_select, Gtk::PACK_SHRINK, 5);
	scale_HBox.set_size_request(-1, 24);
	
	set_velocity_b.set_size_request(70, 24);
	set_velocity_b.set_vexpand(false);
	set_velocity_b.set_margin_top(5);	
	
	modal_button_VBox.set_size_request(315, 60);
	fixed_board.put(modal_button_VBox, 0, 557);
	// edit chord buttons
	new_chord_button.set_size_request(50, 60);	
	paste_chord_button.set_size_request(50, 60);
	delete_chord_button.set_size_request(50, 60);
	copy_chord_button.set_size_request(50, 60);

	chord_edit_button_box.pack_end(paste_chord_button, Gtk::PACK_SHRINK);
	chord_edit_button_box.pack_end(copy_chord_button, Gtk::PACK_SHRINK);
	chord_edit_button_box.pack_end(delete_chord_button, Gtk::PACK_SHRINK);
	chord_edit_button_box.pack_end(new_chord_button, Gtk::PACK_SHRINK);
	
	//chord_edit_button_box.set_size_request(350, 60);
	fixed_board.put(chord_edit_button_box,  450, 557);
	
	// save and quit buttons
	m_Button_Quit.set_size_request( 96, 30);
	fixed_board.put(m_Button_Quit, 844, 591);
	
	save_button.set_size_request( 96, 30);
	fixed_board.put(save_button, 844, 557);
	
	// play chord buttons
	previous_chord_button.set_size_request(100, 30);
	next_chord_button.set_size_request(80, 30);
	play_button.set_size_request(60, 30);
	stop_button.set_size_request(60, 30);
	chord_play_button_box.pack_end(next_chord_button, Gtk::PACK_SHRINK);
	chord_play_button_box.pack_end(previous_chord_button, Gtk::PACK_SHRINK);
	chord_play_button_box.pack_end(play_button, Gtk::PACK_SHRINK);
	chord_play_button_box.pack_end(stop_button, Gtk::PACK_SHRINK);
	
	chord_play_button_box.set_size_request(350, 30);
	fixed_board.put(chord_play_button_box,  458, 557);

	instrument_HBox.pack_start(*instrument_label.e_box, Gtk::PACK_SHRINK, 4);
	puts("line 677");
	// section edit buttons
	split_section_button.set_size_request(90, 30);
	join_section_button.set_size_request(90, 30);
	delete_section_button.set_size_request(90, 30);
	name_section_button.set_size_request( 90, 30);
	section_edit_top_HBox.pack_start(split_section_button, Gtk::PACK_SHRINK);
	section_edit_top_HBox.pack_start(join_section_button, Gtk::PACK_SHRINK);
	section_edit_top_HBox.pack_start(delete_section_button, Gtk::PACK_SHRINK);
	section_edit_top_HBox.pack_start(name_section_button, Gtk::PACK_SHRINK);
	fixed_board.put(section_edit_top_HBox, 458, 557);
	
	copy_section_button.set_size_request( 90, 30);
	paste_before_section_button.set_size_request( 135, 30);
	paste_after_section_button.set_size_request( 135, 30);
	section_edit_bottom_HBox.pack_start(copy_section_button,  Gtk::PACK_SHRINK);
	section_edit_bottom_HBox.pack_start(paste_before_section_button,  Gtk::PACK_SHRINK);
	section_edit_bottom_HBox.pack_start(paste_after_section_button,  Gtk::PACK_SHRINK);
	fixed_board.put(section_edit_bottom_HBox, 458, 591);
	fixed_board.put(section_HBox, 0, 591);
	
	split_section_button.signal_clicked().connect( sigc::mem_fun(*this,
									&ExampleWindow::split_section) );
	copy_section_button.signal_clicked().connect( sigc::mem_fun(*this, 
										&ExampleWindow::copy_section) );
	paste_before_section_button.signal_clicked().connect( sigc::mem_fun(*this, 
									&ExampleWindow::paste_before_section) );
	paste_after_section_button.signal_clicked().connect( sigc::mem_fun(*this, 
									&ExampleWindow::paste_after_section) );
	delete_section_button.signal_clicked().connect( sigc::mem_fun(*this, 
									&ExampleWindow::delete_section) );
	join_section_button.signal_clicked().connect( sigc::mem_fun(*this, 
									&ExampleWindow::join_sections) );
	name_section_button.signal_clicked().connect( sigc::mem_fun(*this, 
									&ExampleWindow::name_sections) );
	// Section base node initialized in area
	Section_base * initial_base = new Section_base();
	Dlnode * init_base_node;
	init_base_node = (Dlnode*) area.curs_node->section_bases;
	init_base_node->data = initial_base;
	initial_base->chord_start = 1;
	initial_base->chord_end = 1;
	initial_base->length = 1;
	initial_base->name = NULL;
	
	puts("Line 695");
	MyButton * initial_section_btn = new MyButton();
	initial_section_btn->sect_chord_start = 1;
	initial_section_btn->sect_chord_end = 1;
	initial_section_btn->sect_chord_length = 1;
	initial_section_btn->button_type = 4;
	initial_section_btn->sect_start = 0;
	initial_section_btn->sect_end = 430;
	initial_section_btn->sect_pix_length = 430;
	initial_section_btn->set_size_request(430, 30);
	initial_section_btn->sect_name = NULL;
	
	Dlnode * sections = Dlist::dl_create();
	area.curs_node->sections = sections;
	copied_section = NULL;
			
	sections->section_button = initial_section_btn;
	Gtk::EventBox * initial_eventbox = new Gtk::EventBox();
	sections->eventbox =  initial_eventbox;
	initial_eventbox->add(*initial_section_btn);
	section_HBox.add(*initial_eventbox);
	selected_section = (Dlnode*) area.curs_node->sections;
	
	initial_eventbox->signal_button_press_event().connect(sigc::bind<MyButton *>(
					sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_clicked), initial_section_btn) );
	initial_eventbox->signal_enter_notify_event().connect(sigc::bind<MyButton *>(
					sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_enter), initial_section_btn) );
	initial_eventbox->signal_leave_notify_event().connect(sigc::bind<MyButton *>(
					sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_leave), initial_section_btn) );
	// Combo Box code:
	puts("line 719");
		//Create the Tree model:
	m_refTreeModel = Gtk::ListStore::create(m_Columns);
	inst_combo.set_model(m_refTreeModel);
	inst_combo.set_size_request(75, 25);
	Gtk::TreeModel::Row row;
	
	//Fill the ComboBox’s Tree Model: 53 instruments
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 1;
	row[m_Columns.m_col_name] = "Vibraphone";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 2;
	row[m_Columns.m_col_name] = "Soft Vibes";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 3;
	row[m_Columns.m_col_name] = "Simple Chimes";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 4;
	row[m_Columns.m_col_name] = "Silver Bell";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 6;
	row[m_Columns.m_col_name] = "Ethereal";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 12;
	row[m_Columns.m_col_name] = "Full Square";
	
	//row = *(m_refTreeModel->append());
	//row[m_Columns.m_col_id] = 14;
	//row[m_Columns.m_col_name] = "Steel Wire";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 15;
	row[m_Columns.m_col_name] = "Echo Bubbles";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 17;
	row[m_Columns.m_col_name] = "Sub Delay";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 18;
	row[m_Columns.m_col_name] = "Soft";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 19;
	row[m_Columns.m_col_name] = "Ultra Soft";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 23;
	row[m_Columns.m_col_name] = "Full Strings";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 24;
	row[m_Columns.m_col_name] = "Slow Strings";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 26;
	row[m_Columns.m_col_name] = "Sweep Synth";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 27;
	row[m_Columns.m_col_name] = "Warm Strings";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 30;
	row[m_Columns.m_col_name] = "Multi Synth";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 32;
	row[m_Columns.m_col_name] = "Medium Saw";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 35;
	row[m_Columns.m_col_name] = "Sweep Saw";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 39;
	row[m_Columns.m_col_name] = "MasterSynthLow";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 40;
	row[m_Columns.m_col_name] = "MasterSynthHi";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 41;
	row[m_Columns.m_col_name] = "Sharp Synth";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 45;
	row[m_Columns.m_col_name] = "Synth Bass";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 47;
	row[m_Columns.m_col_name] = "Variable Reed";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 48;
	row[m_Columns.m_col_name] = "Reed Organ";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 49;
	row[m_Columns.m_col_name] = "Soft Organ";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 51;
	row[m_Columns.m_col_name] = "Great Organ";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 52;
	row[m_Columns.m_col_name] = "64ft Organ";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 53;
	row[m_Columns.m_col_name] = "Hammond Organ";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 55;
	row[m_Columns.m_col_name] = "Sines";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 57;
	row[m_Columns.m_col_name] = "Warm Flute";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 59;
	row[m_Columns.m_col_name] = "Beyond";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 63;
	row[m_Columns.m_col_name] = "SlowDeepMatrix";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 64;
	row[m_Columns.m_col_name] = "Ice Field";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 65;
	row[m_Columns.m_col_name] = "HollowIceField";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 66;
	row[m_Columns.m_col_name] = "Smooth";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 67;
	row[m_Columns.m_col_name] = "Rushes";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 73;
	row[m_Columns.m_col_name] = "Sweep Rushes";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 76;
	row[m_Columns.m_col_name] = "Voyager";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 78;
	row[m_Columns.m_col_name] = "SoftVoyagerRev";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 81;
	row[m_Columns.m_col_name] = "Sharp and Warm";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 82;
	row[m_Columns.m_col_name] = "SharpAndDeep";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 87;
	row[m_Columns.m_col_name] = "Aooww";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 97;
	row[m_Columns.m_col_name] = "Wet Brass";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 98;
	row[m_Columns.m_col_name] = "Wet Brass 2";
		
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 114;
	row[m_Columns.m_col_name] = "Space Voice";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 115;
	row[m_Columns.m_col_name] = "FarSpaceVoice";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 116;
	row[m_Columns.m_col_name] = "SpaceVoice 2";
	
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 117;
	row[m_Columns.m_col_name] = "Soft Choir";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 118;
	row[m_Columns.m_col_name] = "Full Choir";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 119;
	row[m_Columns.m_col_name] = "Soft Ahh";

	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 129;
	row[m_Columns.m_col_name] = "Breathy Ahh";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 121;
	row[m_Columns.m_col_name] = "Another Choir";
	
	row = *(m_refTreeModel->append());
	row[m_Columns.m_col_id] = 122;
	row[m_Columns.m_col_name] = "Light Choir";	
	puts("line 939");
		//Add the model columns to the Combo (which is a kind of view),
		//rendering them in the default way:
	inst_combo.pack_start(m_Columns.m_col_id);
	inst_combo.pack_start(m_Columns.m_col_name);
	instrument_HBox.pack_start(inst_combo, Gtk::PACK_SHRINK, 4);
	instrument_HBox.set_size_request(320, 25);
	fixed_board.put(instrument_HBox, 479, 597);
	
		//Connect signal handler:
	inst_combo.signal_changed().connect( sigc::mem_fun(*this, &ExampleWindow::on_inst_combo_changed) );	

	separator1.inner->type = 5;
	separator2.inner->type = 5;
	
	separator1.inner->set_size_request(4, 60);
	separator2.inner->set_size_request(4, 60);
	//fixed_board.put(*separator1.e_box, 723, 557);
	//fixed_board.put(*separator2.e_box, 834, 557);
	
	// m_ButtonHBox.pack_start(display_VBox,  Gtk::PACK_SHRINK, 4);
	for(int i=4; i>-1; i--)
		display_VBox.pack_start(*display_group[i].e_box, Gtk::PACK_SHRINK, 0);
	
	display_VBox.set_size_request(100, 60);
	fixed_board.put(display_VBox, 732, 557);	
		
	fixed_board.put(*boxes[77],  0, 0);
	boxes[77]->add(*keys[77]);
	keys[77]->set_size_request(62, 18);
	keys[77]->key_number = 77;
	
	fixed_board.put(*boxes[78],  62, 0);
	boxes[78]->add(*keys[78]);
	keys[78]->set_size_request(33, 18);
	keys[78]->key_number = 78;
	
	pairs[29].first = 77;
	pairs[29].second = 78;
	
	// Loop 4 times, once for each octave
	for (int i = 3, j = 0; i> -1; i--, j++)
	{
		int offset = 19 * i; 
		int pair_offset = 7 * i;
		int octave_offset = 126 * j;
		
		fixed_board.put(*boxes[19 + offset], 62, 18 + octave_offset);
		boxes[19 + offset]->add(*keys[19 + offset]);
		keys[19 + offset]->set_size_request(33, 18);
		keys[19 + offset]->key_number = 19 + offset;
		
		fixed_board.put(*boxes[18 + offset], 0, 18 + octave_offset);
		boxes[18 + offset]->add(*keys[18 + offset]);
		keys[18 + offset]->set_size_request(62, 9);
		keys[18 + offset]->key_number = 18 + offset;
		
		pairs[28 - pair_offset].first = 18 + offset;
		pairs[28 - pair_offset].second = 19 + offset;
		
		fixed_board.put(*boxes[17 + offset], 0, 27 + octave_offset);
		boxes[17 + offset]->add(*keys[17 + offset]);
		keys[17 + offset]->set_size_request(62, 12);
		keys[17 + offset]->key_number = 17 + offset;

		fixed_board.put(*boxes[16 + offset], 62, 36 + octave_offset);
		boxes[16 + offset]->add(*keys[16 + offset]);
		keys[16 + offset]->set_size_request(33, 18);
		keys[16 + offset]->key_number = 16 + offset;
		
		fixed_board.put(*boxes[15 + offset], 0, 39 + octave_offset);
		boxes[15 + offset]->add(*keys[15 + offset]);
		keys[15 + offset]->set_size_request(62, 9);
		keys[15 + offset]->key_number = 15 + offset;
		
		pairs[27 - pair_offset].first = 15 + offset;
		pairs[27 - pair_offset].second = 16 + offset;
		
		fixed_board.put(*boxes[14 + offset], 0, 48 + octave_offset);
		boxes[14 + offset]->add(*keys[14 + offset]);
		keys[14 + offset]->set_size_request(62, 12);
		keys[14 + offset]->key_number = 14 + offset;
		
		fixed_board.put(*boxes[13 + offset], 62, 54 + octave_offset);
		boxes[13 + offset]->add(*keys[13 + offset]);
		keys[13 + offset]->set_size_request(33, 18);
		keys[13 + offset]->key_number = 13 + offset;
		
		fixed_board.put(*boxes[12 + offset], 0, 60 + octave_offset);
		boxes[12 + offset]->add(*keys[12 + offset]);
		keys[12 + offset]->set_size_request(62, 9);
		keys[12 + offset]->key_number = 12 + offset;
		
		pairs[26 - pair_offset].first = 12 + offset;
		pairs[26 - pair_offset].second = 13 + offset;
		
		fixed_board.put(*boxes[11 + offset], 0, 69 + octave_offset);
		boxes[11 + offset]->add(*keys[11 + offset]);
		keys[11 + offset]->set_size_request(62, 12);
		keys[11 + offset]->key_number = 11 + offset;
		
		fixed_board.put(*boxes[10 + offset], 62, 72 + octave_offset);
		boxes[10 + offset]->add(*keys[10 + offset]);
		keys[10 + offset]->set_size_request(33, 18);
		keys[10 + offset]->key_number = 10 + offset;
		
		fixed_board.put(*boxes[9 + offset], 0, 81 + octave_offset);
		boxes[9 + offset]->add(*keys[9 + offset]);
		keys[9 + offset]->set_size_request(62, 9);
		keys[9 + offset]->key_number = 9 + offset;
		
		pairs[25 - pair_offset].first = 9 + offset;
		pairs[25 - pair_offset].second = 10 + offset;
		
		fixed_board.put(*boxes[8 + offset], 62, 90 + octave_offset);
		boxes[8 + offset]->add(*keys[8 + offset]);
		keys[8 + offset]->set_size_request(33, 18);
		keys[8 + offset]->key_number = 8 + offset;
		
		fixed_board.put(*boxes[7 + offset], 0, 90 + octave_offset);
		boxes[7 + offset]->add(*keys[7 + offset]);
		keys[7 + offset]->set_size_request(62, 11);
		keys[7 + offset]->key_number = 7 + offset;
		
		pairs[24 - pair_offset].first = 7 + offset;
		pairs[24 - pair_offset].second = 8 + offset;
		
		fixed_board.put(*boxes[6 + offset], 0, 101 + octave_offset);
		boxes[6 + offset]->add(*keys[6 + offset]);
		keys[6 + offset]->set_size_request(62, 12);
		keys[6 + offset]->key_number = 6 + offset;
		
		fixed_board.put(*boxes[5 + offset], 62, 108 + octave_offset);
		boxes[5 + offset]->add(*keys[5 + offset]);
		keys[5 + offset]->set_size_request(33, 18);
		keys[5 + offset]->key_number = 5 + offset;
		
		fixed_board.put(*boxes[4 + offset], 0, 113 + octave_offset);
		boxes[4 + offset]->add(*keys[4 + offset]);
		keys[4 + offset]->set_size_request(62, 9);
		keys[4 + offset]->key_number = 4 + offset;
		
		pairs[23 - pair_offset].first = 4 + offset;
		pairs[23 - pair_offset].second = 5 + offset;
		
		fixed_board.put(*boxes[3 + offset], 0, 122 + octave_offset);
		boxes[3 + offset]->add(*keys[3 + offset]);
		keys[3 + offset]->set_size_request(62, 12);
		keys[3 + offset]->key_number = 3 + offset;
		
		fixed_board.put(*boxes[2 + offset], 62, 126 + octave_offset);
		boxes[2 + offset]->add(*keys[2 + offset]);
		keys[2 + offset]->set_size_request(33, 18);
		keys[2 + offset]->key_number = 2 + offset;
		
		fixed_board.put(*boxes[1 + offset], 0, 134 + octave_offset);
		boxes[1 + offset]->add(*keys[1 + offset]);
		keys[1 + offset]->set_size_request(62, 10);
		keys[1 + offset]->key_number = 1 + offset;
		
		pairs[22 - pair_offset].first = 1 + offset;
		pairs[22 - pair_offset].second = 2 + offset;
	}
	// Start events section

	for(int i = 1; i<79; i++)
	{
		boxes[i]->set_events(Gdk::BUTTON_PRESS_MASK |
								Gdk::ENTER_NOTIFY_MASK | 
								Gdk::LEAVE_NOTIFY_MASK );
		boxes[i]->signal_button_press_event().connect(sigc::bind<int>(
					sigc::mem_fun(*this, &ExampleWindow::on_key_pressed), i) );
		boxes[i]->signal_leave_notify_event().connect(sigc::bind<int>(
					sigc::mem_fun(*this, &ExampleWindow::on_box_leave), i) );
		boxes[i]->signal_enter_notify_event().connect(sigc::bind<int>(
					sigc::mem_fun(*this, &ExampleWindow::on_box_enter), i) );
    }
    
    for(int i=0; i<64; i++)
    {
		chord_buttons[i]->set_events(Gdk::BUTTON_PRESS_MASK |
								Gdk::ENTER_NOTIFY_MASK | 
								Gdk::LEAVE_NOTIFY_MASK );
		chord_buttons[i]->signal_button_press_event().connect(sigc::bind<int>(
					sigc::mem_fun(*this, &ExampleWindow::on_chord_button_pressed), i) );
		chord_buttons[i]->signal_leave_notify_event().connect(sigc::bind<int>(
					sigc::mem_fun(*this, &ExampleWindow::on_chord_button_leave), i) );
		chord_buttons[i]->signal_enter_notify_event().connect(sigc::bind<int>(
					sigc::mem_fun(*this, &ExampleWindow::on_chord_button_enter), i) );
	}
	puts("line 1129");
	for(int i=0; i<5; i++)
	{
		display_group[i].e_box->set_events(Gdk::BUTTON_PRESS_MASK);
		display_group[i].e_box->signal_button_press_event().connect(sigc::bind<int>(
					sigc::mem_fun(*this, &ExampleWindow::on_display_radio_clicked), i) );
	}
	
	play_note_rad.e_box->set_events(Gdk::BUTTON_PRESS_MASK);
	play_chord_rad.e_box->set_events(Gdk::BUTTON_PRESS_MASK);
	dont_play_rad.e_box->set_events(Gdk::BUTTON_PRESS_MASK);
	play_note_rad.e_box->signal_button_press_event().connect(sigc::bind<int>(
					sigc::mem_fun(*this, &ExampleWindow::on_play_radio_clicked), 1) );
	play_chord_rad.e_box->signal_button_press_event().connect(sigc::bind<int>(
					sigc::mem_fun(*this, &ExampleWindow::on_play_radio_clicked), 2) );
	dont_play_rad.e_box->signal_button_press_event().connect(sigc::bind<int>(
					sigc::mem_fun(*this, &ExampleWindow::on_play_radio_clicked), 3) );
	
	area.signal_button_press_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_area_clicked) );
    	// standard buttons events here
    play_button.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_play_chord) );
    stop_button.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_stop_chord) );
    next_chord_button.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_next_chord) );
    previous_chord_button.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_previous_chord) );
    save_button.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_save) );
	copy_chord_button.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_copy_chord) );
    paste_chord_button.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_paste_chord) );
    delete_chord_button.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_delete_chord) );
    new_chord_button.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_new_chord) );
    set_velocity_b.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_set_velocity) );
	m_Button_Quit.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_button_quit) );
    
    
    /*////////////////////////////////////////////////////////////////////////////////////*/
    
    box_note_edit->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK
												 | Gdk::LEAVE_NOTIFY_MASK );
	box_note_edit->signal_button_press_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_note_edit_clicked) );
	box_note_edit->signal_leave_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_note_edit_leave) );
	box_note_edit->signal_enter_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_note_edit_enter) );         
	
	box_sequence->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK
													 | Gdk::LEAVE_NOTIFY_MASK );
	box_sequence->signal_button_press_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_sequence_clicked) );
	box_sequence->signal_leave_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_sequence_leave) );
	box_sequence->signal_enter_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_sequence_enter) );
	
	box_chord_edit->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK
												 | Gdk::LEAVE_NOTIFY_MASK );
	box_chord_edit->signal_button_press_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_chord_edit_clicked) );
	box_chord_edit->signal_leave_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_chord_edit_leave) );
	box_chord_edit->signal_enter_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_chord_edit_enter) );
	
	box_chord_play->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK
											 | Gdk::LEAVE_NOTIFY_MASK );
	box_chord_play->signal_button_press_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_chord_play_clicked) );
	box_chord_play->signal_leave_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_chord_play_leave) );
	box_chord_play->signal_enter_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_chord_play_enter) );
	
	box_sections->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK
												 | Gdk::LEAVE_NOTIFY_MASK );
	box_sections->signal_button_press_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_sections_clicked) );
	box_sections->signal_leave_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_sections_leave) );
	box_sections->signal_enter_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_sections_enter) );
	
	box_mult_select->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK | Gdk::LEAVE_NOTIFY_MASK );
	box_mult_select->signal_button_press_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_mult_select_clicked) );
	box_mult_select->signal_leave_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_mult_select_leave) );
	box_mult_select->signal_enter_notify_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_mult_select_enter) );
	
	// sequence window button events
	s_win.m_Button_Select.signal_clicked().connect(sigc::bind<Gtk::TreeView*>(
							sigc::mem_fun(*this, &ExampleWindow::select_sequence), &s_win.m_TreeView ) );
	s_win.m_Button_Delete.signal_clicked().connect(sigc::bind<Gtk::TreeView*>(
							sigc::mem_fun(*this, &ExampleWindow::delete_sequence), &s_win.m_TreeView ) );
	s_win.m_Button_New.signal_clicked().connect(
							sigc::mem_fun(*this, &ExampleWindow::new_sequence) );
	s_win.m_Button_Cancel.signal_clicked().connect(
							sigc::mem_fun(*this, &ExampleWindow::cancel_sequence) );						
	show_all_children();
	
	if(mode == 1)
	{
		chord_play_button_box.hide();
		note_chord_play_radio_box.hide();
		instrument_HBox.hide();
		scale_HBox.hide();
		display_VBox.hide();
		separator1.e_box->hide();
		section_edit_top_HBox.hide();
		section_edit_bottom_HBox.hide();
		puts("line 1215");	
		
		section_HBox.show_all_children();
		section_HBox.show();
		
	}
	puts("line 1223");
	read_saved_file();
	puts("line 1225");
}

ExampleWindow::~ExampleWindow()
{
	
}

// Called when the user clicks "Sequence" button and then clicks "Cancel"
void ExampleWindow::cancel_sequence()
{
	s_win.hide();
}

// This function should be embedded in a try/catch block in case of
// an exception.  It offers the user a choice of MIDI ports to open.
// It returns false if there are no ports available.
bool ExampleWindow::chooseMidiPort( RtMidiOut *rtmidi )
{
	/*
	std::cout << "\nWould you like to open a virtual output port? [y/N] ";

	std::string keyHit;
	std::getline( std::cin, keyHit );
	if ( keyHit == "y" )
	{
		rtmidi->openVirtualPort();
		return true;
	}
	*/
	
	
	std::string portName;
	unsigned int i = 0, nPorts = rtmidi->getPortCount();
	if ( nPorts == 0 )
	{
		std::cout << _("No output ports available!") << std::endl;
		return false;
	}

	if ( nPorts == 1 )
	{
		std::cout << "\n" << _("Opening") << rtmidi->getPortName() << std::endl;
	}
	else
	{
		for ( i=0; i<nPorts; i++ )
		{
			portName = rtmidi->getPortName(i);
			std::cout << _("  Output port #")  << i << ": " << portName << '\n';
		}

		do
		{
			std::cout << "\n" << _("Choose a port number: ");
			std::cin >> i;
		}	
		while ( i >= nPorts );
	}

	std::cout << "\n";
	rtmidi->openPort( i );

	return true;
}


bool ExampleWindow::on_display_radio_clicked(GdkEventButton* button_event, int data)
{
	// change active button
	for(int i = 0; i<5; i++)
	{
		if(i == data)
			display_group[i].inner->active = true;
		else
			display_group[i].inner->active = false;
		display_group[i].inner->queue_draw();
	}
	
	// change selected note display
	selected_note->display = data;

	selected_note->update_display();
	selected_note->update_x();
	area.queue_draw();
	
	return true;
}


 /*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*/
 
 // This function is called when modal button "Sections" clicked
bool ExampleWindow::on_sections_clicked(GdkEventButton* button_event)
{
	section_HBox.show_all_children();
	section_HBox.show();
	(void*) button_event;
	//puts("clicked");
	mode = 6; // sections edit mode
	separator1.e_box->hide();
	chord_edit_button_box.hide();
	note_chord_play_radio_box.hide();
	display_VBox.hide();
	instrument_HBox.hide();
	chord_play_button_box.hide();
	
	section_edit_top_HBox.show();
	section_edit_bottom_HBox.show();
	
	std::vector<Widget*> children = section_HBox.get_children();
	//std::cout << "Vector size is " << children.size() << std::endl;
	
	scale_HBox.hide();
	
	mode_chord_edit_button->pressed = false;
	mode_chord_play_button->pressed = false;
	mode_sequence_button->pressed = false; 
	mode_note_edit_button->pressed = false;
	mode_sections_button->pressed = true;
	
	mode_chord_edit_button->queue_draw ();
	mode_chord_play_button->queue_draw ();
	mode_sequence_button->queue_draw ();
	mode_note_edit_button->queue_draw ();
	mode_sections_button->queue_draw ();
	return true; 
}
 
 // This function is called when mouse enters "Sections" modal button
bool ExampleWindow::on_sections_enter(GdkEventCrossing* crossing_event)
{
	mode_sections_button->over = true;
	mode_sections_button->queue_draw ();
	return true;
}

// This function is called when mouse leaves "Sections" modal button
bool ExampleWindow::on_sections_leave(GdkEventCrossing* crossing_event)
{
	mode_sections_button->over = false;
	mode_sections_button->queue_draw ();
	return true;
}
 
// This function is called when modal button "edit note" clicked
bool ExampleWindow::on_note_edit_clicked(GdkEventButton* button_event)
{
	mode = 3;
	sharpsharp_rad.inner->hide();
	flatflat_rad.inner->hide();
	normal_rad.inner->hide();
	flat_rad.inner->hide();
	sharp_rad.inner->hide();
	section_edit_top_HBox.hide();
	section_edit_bottom_HBox.hide();
		
	chord_edit_button_box.hide();
	chord_play_button_box.hide();
	instrument_HBox.hide();
	section_HBox.hide();
	
	display_VBox.show();
	note_chord_play_radio_box.show();
	separator1.e_box->show();
	scale_HBox.show();
		
	if(multiple_select == false && selected_note != NULL)
	{
		display_note_options(selected_note);
		sc->set_value(selected_note->velocity);
	}
	
	mode_chord_edit_button->pressed = false;
	mode_chord_play_button->pressed = false;
	mode_sequence_button->pressed = false; 
	mode_note_edit_button->pressed = true;
	mode_sections_button->pressed = false;
	
	mode_chord_edit_button->queue_draw ();
	mode_chord_play_button->queue_draw ();
	mode_sequence_button->queue_draw ();
	mode_note_edit_button->queue_draw ();
	mode_sections_button->queue_draw ();
	return true;
}

// This function is called when mouse leaves modal button "edit note"
bool ExampleWindow::on_note_edit_leave(GdkEventCrossing* crossing_event)
{
	mode_note_edit_button->over = false;
	mode_note_edit_button->queue_draw ();
	return true;
}

// This function is called when mouse enters modal button "edit note"
bool ExampleWindow::on_note_edit_enter(GdkEventCrossing* crossing_event)
{
	mode_note_edit_button->over = true;
	mode_note_edit_button->queue_draw ();
	return true;
}
 /*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*/
 
bool ExampleWindow::on_sequence_clicked(GdkEventButton* button_event)
{
	(void*) button_event;
	mode_chord_edit_button->pressed = false;
	mode_chord_play_button->pressed = false;
	mode_sequence_button->pressed = true; 
	mode_note_edit_button->pressed = false;
	mode_sections_button->pressed = false;
	
	mode_chord_edit_button->queue_draw ();
	mode_chord_play_button->queue_draw ();
	mode_sequence_button->queue_draw ();
	mode_note_edit_button->queue_draw ();
	mode_sections_button->queue_draw ();
	
	scale_HBox.hide();
	section_HBox.show_all_children();
	section_HBox.show();
	
	if(s_win.get_visible() )
		s_win.hide();
	else
	{
		mode = 4;
		s_win.update();
		s_win.show();
	}
	return true;
}

bool ExampleWindow::on_sequence_leave(GdkEventCrossing* crossing_event)
{
	mode_sequence_button->over = false;
	mode_sequence_button->queue_draw ();
	return true;
}

bool ExampleWindow::on_sequence_enter(GdkEventCrossing* crossing_event)
{
	mode_sequence_button->over = true;
	mode_sequence_button->queue_draw ();
	return true;
}	
 /*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*/
 
// this function is called when modal "Edit chord" button clicked
bool ExampleWindow::on_chord_edit_clicked(GdkEventButton* button_event)
{
	//puts("clicked");
	mode = 1; // chord edit mode
	
	instrument_HBox.hide();
	display_VBox.hide();
	separator1.e_box->hide();
	chord_play_button_box.hide();
	note_chord_play_radio_box.hide();
	scale_HBox.hide();
	section_edit_top_HBox.hide();
	section_edit_bottom_HBox.hide();
	chord_edit_button_box.show();
	chord_edit_button_box.show_all_children();
	section_HBox.show_all_children();
	section_HBox.show();
	
	mode_chord_edit_button->pressed = true;
	mode_chord_play_button->pressed = false;
	mode_sequence_button->pressed = false; 
	mode_note_edit_button->pressed = false;
	mode_sections_button->pressed = false;
	
	mode_chord_edit_button->queue_draw ();
	mode_chord_play_button->queue_draw ();
	mode_sequence_button->queue_draw ();
	mode_note_edit_button->queue_draw ();
	mode_sections_button->queue_draw ();
	return true;
}

// this function is called when mouse leaves modal "Edit chord" button
bool ExampleWindow::on_chord_edit_leave(GdkEventCrossing* crossing_event)
{
	mode_chord_edit_button->over = false;
	mode_chord_edit_button->queue_draw ();
	return true;
}

// this function is called when mouse enters modal "Edit chord" button
bool ExampleWindow::on_chord_edit_enter(GdkEventCrossing* crossing_event)
{
	mode_chord_edit_button->over = true;
	mode_chord_edit_button->queue_draw ();
	return true;
}	
 /*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*/
 
// This function is called when modal button "play chord" clicked  
bool ExampleWindow::on_chord_play_clicked(GdkEventButton* button_event)
{
	(void*) button_event;
	mode = 2; // chord play mode
	separator1.e_box->hide();
	chord_edit_button_box.hide();
	note_chord_play_radio_box.hide();
	display_VBox.hide();
	section_edit_top_HBox.hide();
	section_edit_bottom_HBox.hide();
	section_HBox.show_all_children();
	section_HBox.show();

	instrument_HBox.show();
	chord_play_button_box.show();
	chord_play_button_box.show_all_children();
	scale_HBox.hide();
	
	mode_chord_edit_button->pressed = false;
	mode_chord_play_button->pressed = true;
	mode_sequence_button->pressed = false; 
	mode_note_edit_button->pressed = false;
	mode_sections_button->pressed = false;
	
	mode_chord_edit_button->queue_draw ();
	mode_chord_play_button->queue_draw ();
	mode_sequence_button->queue_draw ();
	mode_note_edit_button->queue_draw ();
	mode_sections_button->queue_draw ();
	return true;
}

// This function is called when mouse leaves modal button "play chord"
bool ExampleWindow::on_chord_play_leave(GdkEventCrossing* crossing_event)
{
	mode_chord_play_button->over = false;
	mode_chord_play_button->queue_draw ();
	return true;
}

// This function is called when mouse moves over modal button "play chord"
bool ExampleWindow::on_chord_play_enter(GdkEventCrossing* crossing_event)
{
	mode_chord_play_button->over = true;
	mode_chord_play_button->queue_draw ();
	return true;
}	
/*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*/
// This function is called when one of 64 buttons below the area clicked
bool ExampleWindow::on_chord_button_pressed(GdkEventButton* button_event, int data)
{
	//printf("Pressed button %d\n", data);
	int length = Dlist::dl_count(area.current_sequence);
		
	if(data < length )
	{
	// change current chord
	selected_chord_number = data + 1; // start counting chords from 1
	// still counting from 0 here:
	area.current_chord = (Dlnode * ) Dlist::dl_nth_data (area.current_sequence, data);
	
	//printf("Selected chord %d\n", data + 1);
	
		// mark button as selected
		chord_radio_buttons[data]->pressed = true;
		for (int i=0; i<64; i++)
		{
			if (i != data)
			{
				chord_radio_buttons[i]->pressed = false;
			}
			chord_radio_buttons[i]->queue_draw (); 
		}
	}
	area.queue_draw();
	return true;
}

// This function is called when mouse leaves one of 64 buttons below the area
bool ExampleWindow::on_chord_button_leave(GdkEventCrossing* crossing_event, int data)
{
	chord_radio_buttons[data]->over = false;
	chord_radio_buttons[data]->queue_draw ();
	return true;
}

// This function is called when mouse moves over one of 64 buttons below the area
bool ExampleWindow::on_chord_button_enter(GdkEventCrossing* crossing_event, int data)
{
	chord_radio_buttons[data]->over = true;
	chord_radio_buttons[data]->queue_draw ();
	return true;
}	
/*)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) */

// This function is called when "new chord" button is pressed
void ExampleWindow::on_new_chord()
{
	int length = Dlist::dl_count (area.current_sequence);
	
	// every chord has at least one note, dummy note, which 
	// is not counted or displayed
	Dlnode * new_chord = Dlist::dl_create();
	Note * dummy_note = new Note(-1000);
	new_chord->data = dummy_note;
	
	// find out which of the chords is selected:
	// and insert new chord AFTER it.
	// find out if selected chord is the last one:
	if(length == selected_chord_number) // selected chord is last one
		// this returns the new start of the list
		// and adds new chord to the end of the list
		area.current_sequence =  Dlist::dl_insert_before(area.current_sequence,
														NULL, new_chord);
	else
	{	
		// this points to the next chord after selected
		Dlnode * after_selected_chord_link = Dlist::dl_nth_node (area.current_sequence,
												selected_chord_number);
		// this returns the new start of the list
		area.current_sequence = Dlist::dl_insert_before(area.current_sequence,
								after_selected_chord_link, new_chord);
	}
	
	// make new chord selected
	selected_chord_number++;
	// 0 start notation
	area.current_chord = (Dlnode * ) Dlist::dl_nth_data (area.current_sequence,
										selected_chord_number - 1);
	// mark corresponding chord buttons - 0 start notation
	chord_radio_buttons[selected_chord_number - 2]->pressed = false;
	chord_radio_buttons[selected_chord_number - 1]->pressed = true;
	chord_radio_buttons[selected_chord_number - 2]->queue_draw();
	chord_radio_buttons[selected_chord_number - 1]->queue_draw();
	
	// change position_x for all notes in all chords to the right of new one
	// change position_x for all notes in all chords to the right of new one
	Dlnode * buffer;
	Note * n;
	for(int i=selected_chord_number; i< Dlist::dl_count(area.current_sequence); i++)
	{
		buffer = (Dlnode *) Dlist::dl_nth_node (area.current_sequence, i)->data;
		for(int j=1; j< Dlist::dl_count(buffer); j++)
		{
			n = (Note *) (Dlist::dl_nth_node(buffer, j)->data);
			(n->position_x) += 53;
		}
	}
	
	// update all occupied fields in chord buttons
	int len = Dlist::dl_count(area.current_sequence);
	for(int i=0; i<64; i++)
	{
		if(i < len)
			chord_radio_buttons[i]->occupied = true;
		else
			chord_radio_buttons[i]->occupied = false;
		chord_radio_buttons[i]->queue_draw();
	}







	
	// update all section bases
	Dlnode * buf_base_node = (Dlnode *) area.curs_node->section_bases;
	Section_base * buf_base;
	while(buf_base_node != NULL)
	{
		// find which section new chord was located in and change it:
		buf_base = (Section_base *) buf_base_node->data;
		int s = buf_base->chord_start; // counted from 1
		int e = buf_base->chord_end;	// counted from 1
		printf("base's s is %d, e is %d\n", s, e);
		printf("selected chord number is %d\n", selected_chord_number);
		
		if(selected_chord_number-1 >= s && selected_chord_number-1 <= e)
		{
			(buf_base->chord_end)++;
			(buf_base->length)++;
		}
		else if(selected_chord_number-1 < s)
		{
			// update all bases to the right of selected chord
			(buf_base->chord_start)++;
			(buf_base->chord_end)++;
		}
		
		buf_base_node = buf_base_node->next;
	}
	
	// update all section buttons
	Dlnode * buf_sect_node = (Dlnode *) area.curs_node->sections;
	MyButton * buf_button;
	while(buf_sect_node != NULL)
	{
		// find which section new chord was located in and change it:
		buf_button = (MyButton *) buf_sect_node->section_button;
		int s = buf_button->sect_chord_start; // counted from 1
		int e = buf_button->sect_chord_end;	// counted from 1
		
		printf("button's s is %d, e is %d\n", s, e);
		printf("selected chord number is %d\n", selected_chord_number);
		
		if(selected_chord_number-1 >= s && selected_chord_number-1 <= e)
		{
			(buf_button->sect_chord_end)++;
			(buf_button->sect_chord_length)++;
		}
		else if(selected_chord_number-1 < s)
		{
			// update all section buttons to the right of selected chord
			(buf_button->sect_chord_start)++;
			(buf_button->sect_chord_end)++;
		}
		
		buf_sect_node = buf_sect_node->next;
	}
	
	recalculate_section_buttons();
	update_section_buttons();
	area.queue_draw();
} // end on_new_chord()

// This function recalculates sect_start, sect_end and sect_pix_length 
// for all section buttons, taking into account sect_chord_length.
void ExampleWindow::recalculate_section_buttons()
{	
/*	
	// Check if the button chord length is still there
	Dlnode * buf_sect_node = (Dlnode *) area.curs_node->sections;
	while(buf_sect_node != NULL)
	{
		MyButton * buf_button = (MyButton *) buf_sect_node->section_button;
		buf_button->queue_draw();
		printf("At the start of recalculate section buttons chord length is %d\n", 
								buf_button->sect_chord_length);
		buf_sect_node = buf_sect_node->next;		
	}
*/	
	// calculate new rate first by first finding the sum of chord length
	// of all sections buttons
	puts("recalculating...");
	Dlnode * buf_sect = (Dlnode*) area.curs_node->sections;
	MyButton * button;
	int total_length = 0;
	int section_count = 0;
	while(buf_sect != NULL)
	{
		button = (MyButton *) buf_sect->section_button;
		int but_len  = button->sect_chord_length;
		
		int but_ch_st = button->sect_chord_start;
		printf("button chord start is %d\n", but_ch_st);

		
		total_length = total_length + button->sect_chord_length;
		printf("button length is %d\n", but_len);
		printf("total length is %d\n", total_length);
		
		buf_sect = buf_sect->next;
		section_count++;
	}
	
	// recalculate rate
	std::cout << "section count is " << section_count << std::endl;
	double rate = (430.0 - 1 * section_count )/ (double) total_length;
	std::cout << "Rate is " << rate << std::endl;
	
	// apply new rate to all section buttons
	int initial_length, final_pix_length, initial_pix_length;
	buf_sect = (Dlnode*) area.curs_node->sections;
	while(buf_sect != NULL)
	{
		button = (MyButton *) buf_sect->section_button;
		initial_length = button->sect_chord_length;
		initial_pix_length = button->sect_pix_length;
		final_pix_length = (floor) (rate * initial_length);
		button->sect_pix_length = final_pix_length;
		button->set_size_request(final_pix_length, 30);
		button->queue_draw();
		
		std::cout<< "Changed button length from " << initial_pix_length;
		std::cout<< " to " << final_pix_length << std::endl;
		buf_sect = buf_sect->next;
	}
} // end recalculate_section_buttons()

void ExampleWindow::on_delete_chord()
{
	if(Dlist::dl_count(area.current_sequence) == 1) // sequence has only one chord
	{	 // sequence always must have at least one chord:
		 // delete notes only, leaving buffer note
		Dlnode * buffer = (Dlnode *)Dlist::dl_nth_node (area.current_sequence, 
										selected_chord_number - 1 )->data;
		// Change this code later to use better glist iteration
		int length = Dlist::dl_count(buffer);
		for(int i=1; i < length; i++)
		{
			//printf("Deleting note # %d\n", i);
			delete ( (Note *) (Dlist::dl_nth_node (buffer, 1)->data) ); 
			buffer = Dlist::dl_remove_node(buffer, Dlist::dl_nth_node(buffer, 1) );
		}
		area.queue_draw();
		return;
	}
	
	int init_sel_chord_num;
	// this will delete all nodes except for the head node
	Dlnode * buf_head_chord_node = Dlist::dl_nth_node (area.current_sequence, 
									selected_chord_number - 1 );
	Dlnode * buf_head_note_node = (Dlnode *) buf_head_chord_node->data;
	Dlnode * buf_node = buf_head_note_node->next;
	Note * n;
	while(buf_node != NULL)
	{
		buf_head_note_node->next = buf_node->next;
		buf_node->next = NULL;
		n = (Note *) buf_node->data;
		if(n == selected_note)
			selected_note = NULL;
			
		Dlnode * sel_notes_node = Dlist::dl_find(selected_notes, n);
		if(sel_notes_node != NULL)
			selected_notes = Dlist::dl_delete_node(selected_notes, 
														sel_notes_node);
		
		delete (Note *) buf_node->data;
		delete buf_node; 
		buf_node = buf_head_note_node->next;
	}
	
	// delete head node data and head node itself
	delete((Note *)buf_head_note_node->data);
	delete((Dlnode *) buf_head_chord_node->data);
	area.current_sequence = Dlist::dl_remove_node(area.current_sequence, 
												buf_head_chord_node);
	area.curs_node->data = area.current_sequence;

	
	
	// change selected_chord_number and the chord itself
	if(Dlist::dl_count(area.current_sequence) == selected_chord_number - 1)
	{	// means no more chords to the right
		init_sel_chord_num = selected_chord_number;
		selected_chord_number--;
		
		// 0 start notation
		area.current_chord = (Dlnode * ) Dlist::dl_nth_data (area.current_sequence,
											selected_chord_number - 1);
		// mark corresponding chord buttons - 0 start notation
		chord_radio_buttons[selected_chord_number]->pressed = false;
		chord_radio_buttons[selected_chord_number - 1]->pressed = true;
		chord_radio_buttons[selected_chord_number]->queue_draw();
		chord_radio_buttons[selected_chord_number - 1]->queue_draw();
	}
	else // means there are chords to the right
	{
		// selected_chord_number is unchanged, changing chord itself 
		// to one to the right of the deleted
		area.current_chord = (Dlnode * ) Dlist::dl_nth_data (area.current_sequence,
											selected_chord_number - 1);
		init_sel_chord_num = selected_chord_number;
		// change position_x in all notes to the right of deleted chord
		Dlnode * buffer;
		Note * n;
		for(int i=selected_chord_number-1; i< Dlist::dl_count(area.current_sequence); i++)
		{
			buffer = (Dlnode *)Dlist::dl_nth_node (area.current_sequence, i)->data;
			for(int j=1; j< Dlist::dl_count(buffer); j++)
			{
				n = (Note *) (Dlist::dl_nth_node(buffer, j)->data);
				(n->position_x) -= 53;
			}
		}
 	}
 		// update all occupied fields in chord buttons
	int len = Dlist::dl_count(area.current_sequence);
	for(int i=0; i<64; i++)
	{
		if(i < len)
			chord_radio_buttons[i]->occupied = true;
		else
			chord_radio_buttons[i]->occupied = false;
		chord_radio_buttons[i]->queue_draw();
	}
 	
 	
 	
 	
 	
 	// update all section bases
	Dlnode * buf_base_node = (Dlnode *) area.curs_node->section_bases;
	Section_base * buf_base;
	Dlnode * node_to_remove = NULL;
	while(buf_base_node != NULL)
	{
		// find which section base new chord was located in and change it:
		buf_base = (Section_base *) buf_base_node->data;
		int s = buf_base->chord_start; // counted from 1
		int e = buf_base->chord_end;	// counted from 1
		printf("base's s is %d, e is %d\n", s, e);
		printf("init_sel_chord_num is %d\n", init_sel_chord_num);
		if(init_sel_chord_num >= s && init_sel_chord_num <= e)
		{
			if(buf_base->length == 1)
			{
				node_to_remove = buf_base_node;
			}
			else
			{
				(buf_base->chord_end)--;
				(buf_base->length)--;
			}
		}
		else if(s > init_sel_chord_num)
		{
			// update all bases to the right of selected chord
			(buf_base->chord_start)--;
			(buf_base->chord_end)--;
		}
		buf_base_node = buf_base_node->next;
	}
	puts("line 1985");
	
	
	// if the section base had just one chord before deletion, delete base
	if(node_to_remove != NULL)
	{
		if(node_to_remove->name != NULL)
			delete ( (Glib::ustring *) node_to_remove->name);
		delete((Section_base*) node_to_remove->data);
		area.curs_node->section_bases = Dlist::dl_delete_node( (Dlnode*)
				area.curs_node->section_bases, node_to_remove);
		node_to_remove = NULL;
	}
		// update all section buttons
	Dlnode * buf_sect_node = (Dlnode *) area.curs_node->sections;
	MyButton * buf_button;
	Dlnode * section_node_to_remove = NULL;
	while(buf_sect_node != NULL)
	{
		// find which section new chord was located in and change it:
		buf_button = (MyButton *) buf_sect_node->section_button;
		int s = buf_button->sect_chord_start; // counted from 1
		int e = buf_button->sect_chord_end;	// counted from 1
		
		printf("button's s is %d, e is %d\n", s, e);
		printf("init_sel_chord_num is %d\n", init_sel_chord_num);
		
		if(init_sel_chord_num >= s && init_sel_chord_num <= e)
		{
			if(buf_button->sect_chord_length == 1)
			{
				section_node_to_remove = buf_sect_node;
			}
			else
			{
				(buf_button->sect_chord_end)--;
				(buf_button->sect_chord_length)--;
			}
		}
		else if(init_sel_chord_num < s)
		{
			// update all section buttons to the right of selected chord
			(buf_button->sect_chord_start)--;
			(buf_button->sect_chord_end)--;
		}
		
		buf_sect_node = buf_sect_node->next;
		
		// delete section and everything inside it
		bool remove_first_section = false;
		if(section_node_to_remove != NULL)
		{
			if(section_node_to_remove == selected_section)
				selected_section = NULL;
		
			if(section_node_to_remove == (Dlnode *) area.curs_node->sections)
				// head section node
				remove_first_section = true; // will do it later
			else // not the head section node
				selected_section = (Dlnode *) area.curs_node->sections;
			
			MyButton * b = (MyButton *)section_node_to_remove->section_button;
			
			if(b->sect_name != NULL)
				delete ((Glib::ustring * ) b->sect_name);
			delete(b);
			puts("line 2033");
			Gtk::EventBox * eb = ( Gtk::EventBox*) section_node_to_remove->eventbox;
			puts("line 2034");
			//section_HBox.remove(*eb);
			puts("line 2035");
			delete((Gtk::EventBox*) section_node_to_remove->eventbox);
			puts("line 2037");
			area.curs_node->sections = Dlist::dl_delete_node( (Dlnode*)
							area.curs_node->sections, section_node_to_remove);
							
			if(remove_first_section == true)
				selected_section = (Dlnode *) area.curs_node->sections;
			section_node_to_remove = NULL;
		}
		
		puts("line 2028");
		
	} // end while
	
	
 	puts("line 2038");
 	recalculate_section_buttons();
 	update_section_buttons();
	area.queue_draw();
} // end on_delete_chord()

// this function is called when user presses "delete section" button
void ExampleWindow::delete_section()
{
	if( selected_section == NULL )
	{
		// no section selected
		Glib::ustring message(_("No section is selected to delete") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	
	
	// Check if selected section is the only representation of the one
	// of the section bases
	Section_base * buf_base;
	MyButton * selected_button = (MyButton *) selected_section->section_button;
	//Dlnode * buf_base_node = area.curs_node->section_bases;
	int s_start = selected_button->sect_chord_start;
	int s_end = selected_button->sect_chord_end;
	
	// find and count number of occurences of this base in sections:
	Dlnode * buf_sect_node = (Dlnode*) area.curs_node->sections;
	int count = 0;
	MyButton * buff_button;
	while(buf_sect_node != NULL)
	{
		buff_button = (MyButton *) buf_sect_node->section_button;
		int b_start = buff_button->sect_chord_start;
		int b_end = buff_button->sect_chord_end;
		if( b_start == s_start && b_end == s_end)
			count++;
		buf_sect_node = buf_sect_node->next;
	}
	
	if(count <= 1)
	{
		Glib::ustring message(_("You cannot delete this section because \
 it is the only representation of the certain chords of the sequence. If \
 you delete it, those chords will be permanently lost for music playback. \
 If you do want to get rid of those chords, you need to delete them individually \
 chord by chord, and the section will be deleted automatically after that.") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}

	// ask are you sure want to delete?
	ausure_dialog = new Gtk::Window;
	Gtk::Box * areusure_vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0) );
	ausure_dialog->add(*areusure_vbox);
	Gtk::Grid *areusure_grid = Gtk::manage(new Gtk::Grid);
	areusure_grid->set_border_width(10);
	areusure_grid->set_row_spacing(5);
	areusure_vbox->add(*areusure_grid);
	Gtk::Label *areusure_lb = Gtk::manage(new Gtk::Label(_("Are you sure you want to delete this section?")));
	areusure_grid->attach(*areusure_lb, 0, 0, 2, 1);
	
	Gtk::Button * button_yes = Gtk::manage(new Gtk::Button(_("Delete") ) );
	button_yes->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
			(*this, &ExampleWindow::delete_section_yes), ausure_dialog) );
	areusure_grid->attach(*button_yes, 0, 1, 1, 1);
	
	Gtk::Button * button_no = Gtk::manage(new Gtk::Button(_("Cancel") ) );
	button_no->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
			(*this, &ExampleWindow::cancel_delete_section), ausure_dialog) );
	areusure_grid->attach(*button_no, 1, 1, 1, 1);		
	areusure_vbox->show_all();
	ausure_dialog->show();		
} // end delete_section()

void ExampleWindow::cancel_delete_section(Gtk::Window* window)
{
	puts(_("canceling...") );
	window->hide();
}

void ExampleWindow::delete_section_yes(Gtk::Window* window)
{
		// delete section and everything inside it
	puts("deleting...");
	Dlnode * section_node_to_remove = selected_section;
	puts("line 2176");
	bool remove_first_section = false;
	if(section_node_to_remove != NULL)
	{
		puts("line 2180");
		MyButton * b = (MyButton *)section_node_to_remove->section_button;
		
		if(b->sect_name != NULL)
			delete ((Glib::ustring * ) b->sect_name);
		delete(b);
		puts("line 2033");
		Gtk::EventBox * eb = ( Gtk::EventBox*) section_node_to_remove->eventbox;
		puts("line 2034");
		//section_HBox.remove(*eb);
		puts("line 2035");
		delete((Gtk::EventBox*) section_node_to_remove->eventbox);
		puts("line 2037");
		area.curs_node->sections = Dlist::dl_delete_node( (Dlnode*)
						area.curs_node->sections, section_node_to_remove);
						
		section_node_to_remove = NULL;
	}
	else
	{
		// no section selected
		Glib::ustring message(_("No section is selected to delete") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
	}
	
	recalculate_section_buttons();
	selected_section = NULL;
	copied_section = NULL;
	update_section_buttons();
	puts("line 2221");
	window->hide();
	puts("line 2223");
} // end delete_section_yes


void ExampleWindow::on_button_quit()
{
	for (int i=0; i<79; i++)
	{
		delete  boxes[i];
	}
	for (int i=0; i<83; i++)
	{
		delete keys[i];
	}
	delete midiout;
	delete selected_notes;
	delete dummy_selected_note;
	delete mode_note_edit_button;
	delete mode_sequence_button;
	delete mode_chord_edit_button;
	delete mode_chord_play_button;
	delete mult_select_b;
	delete box_note_edit;
	delete box_sequence;
	delete box_chord_edit;
	delete box_sections;
	delete box_chord_play;
	delete box_mult_select;
	delete sc;
	for(int i=0; i<64; i++)
	{
		delete chord_buttons[i];
		delete chord_radio_buttons[i];
	}
	
	exit(0);
}

// finds midi number based on pressed key
int ExampleWindow::findMidiNumber(int number)
{
	int octave; // 0 for the bottom octave
	octave = (number - 1 - (number - 1) % 19) / 19 ;
	
	switch (number - octave * 19)
	{
		case 1: case 2:	
			return 36 + octave * 12;
		case 3: 		
			return 37 + octave * 12;
		case 4: case 5: 
			return 38 + octave * 12;
		case 6:
			return 39 + octave * 12;
		case 7: case 8:
			return 40 + octave * 12;
		case 9: case 10:
			return 41 + octave * 12;
		case 11:
			return 42 + octave * 12;
		case 12: case 13:
			return 43 + octave * 12;
		case 14:
			return 44 + octave * 12;
		case 15: case 16:
			return 45 + octave * 12;
		case 17:
			return 46 + octave * 12;
		case 18: case 19:
			return 47 + octave * 12;
	}
}

// this function is called when one of the piano keys is pressed
bool ExampleWindow::on_key_pressed(GdkEventButton* button_event, int data)
{
	Dlnode * buffer_list;
	// Find out the MIDI note number based on data:
	// The lowest C in this application is    36
	
	int number = findMidiNumber(data);
	bool note_exist = false;
	//printf("%d is pressed\n", number);
	
	// if note already exist in the currently selected chord, delete it
	Note * n;
	for(uint k=1; k<Dlist::dl_count (area.current_chord); k++)
	{
		n = (Note *) (Dlist::dl_nth_node(area.current_chord, k)->data);
		int midi_num = n->midi_number;
		//printf("Note number %d, position_y = %d\n", k, pos_y);
		if (number == midi_num)
		{	
			//puts("note found");
			// if note is selected, remove it from selected_notes Dlnode
			if(n->selected)
			{
				int index = Dlist::dl_index (selected_notes, n);
				buffer_list = Dlist::dl_nth_node(selected_notes, index);
				selected_notes = Dlist::dl_delete_node(selected_notes, buffer_list);
			}
			note_exist = true;
			if(multiple_select == false && n == selected_note)
				selected_note = NULL;
			
			delete n;
			area.current_chord = Dlist::dl_delete_node(area.current_chord, 
						Dlist::dl_nth_node(area.current_chord, k) );
			break;
		}
	}
	
	if(! note_exist)
	{
		Note * note = new Note(number);
		note->normal_x = (selected_chord_number - 1) * 53 ;
		note->update_x();
		area.current_chord = Dlist::dl_append(area.current_chord, note ) ;
	}
	area.queue_draw();
	return true;
}

// this function is called when mouse moves over one of the piano keys
bool ExampleWindow::on_box_enter(GdkEventCrossing* crossing_event, int data )
{	
	int d = data;
	int temp1, temp2;
		
	for(int i=0; i<30; i++)
	{
		temp1 = pairs[i].first;
		temp2 = pairs[i].second;
		if ( temp1 == d  )
		{
			if(keys[temp2]->over == false)
			{
				keys[temp2]->over = true;
				keys[temp2]->queue_draw ();
			}
		}
		if ( temp2 == d )
		{
			if(keys[temp1]->over == false)
			{
				keys[temp1]->over = true;
				keys[temp1]->queue_draw ();
			}
		}
	}
	
	keys[d]->over = true;
	keys[d]->queue_draw ();
	return true;
}

// this function is called when mouse moves out of one of the piano keys
bool ExampleWindow::on_box_leave(GdkEventCrossing* crossing_event, int data)
{
	int d = data;
	int temp1, temp2;
	for(int i=0; i<30; i++)
	{
		temp1 = pairs[i].first;
		temp2 = pairs[i].second;
		if ( temp1 == d  )
		{
			if(keys[temp2]->over == true)
			{
				keys[temp2]->over = false;
				keys[temp2]->queue_draw ();
			}
		}
		if ( temp2 == d )
		{
			if(keys[temp1]->over == true)
			{
				keys[temp1]->over = false;
				keys[temp1]->queue_draw ();
			}
		}
	}

	keys[d]->over = false;
	keys[d]->queue_draw ();
	return true;
}

bool ExampleWindow::on_play_radio_clicked(GdkEventButton* button_event, int data)
{
	Dlnode * buffer;
	Note * n;
	int note_number;
	int note_velocity;
	if(data == 1) // Play Note option
	{
		if(selected_note != NULL)
		{
			note_number = selected_note->midi_number;
			note_velocity = selected_note->velocity;
	
			// Note On: 144, 64, 90 - second channel
			message[0] = 144  + channel - 1;
			message[1] = note_number;
			message[2] = note_velocity;
			midiout->sendMessage( &message );
		}
		play_note_rad.inner->active = true;
		play_note_rad.inner->queue_draw();
		play_chord_rad.inner->active = false;
		play_chord_rad.inner->queue_draw();
		dont_play_rad.inner->active = false;
		dont_play_rad.inner->queue_draw();
	}
	else if(data == 2) // Play Chord
	{
		for( int i = 1; i < Dlist::dl_count(area.current_chord); i++)
		{
			n = (Note *) Dlist::dl_nth_data(area.current_chord, i);
			note_number = n->midi_number;
			note_velocity = n->velocity;
			message[0] = 144  + channel - 1;
			message[1] = note_number;
			message[2] = note_velocity;
			midiout->sendMessage( &message );
		}
		
		
		play_note_rad.inner->active = false;
		play_note_rad.inner->queue_draw();
		play_chord_rad.inner->active = true;
		play_chord_rad.inner->queue_draw();
		dont_play_rad.inner->active = false;
		dont_play_rad.inner->queue_draw();
	}
	else if(data == 3) // Don't Play option
	{
		// All notes off
		message[0] = 176  + channel - 1;
		message[1] = 123;
		message[2] = 0;
		midiout->sendMessage( &message );
		
		play_note_rad.inner->active = false;
		play_note_rad.inner->queue_draw();
		play_chord_rad.inner->active = false;
		play_chord_rad.inner->queue_draw();
		dont_play_rad.inner->active = true;
		dont_play_rad.inner->queue_draw();
	}

	return true;
}

// This function displays note options, which are possible choices of 
// how the note will be displayed (flat, sharp, double flat, double sharp
// or clear).
void ExampleWindow::display_note_options(Note * n)
{

	// Show corresponding display options
	int  options = n->display_options;
	int disp = n->display;
	int options_length;
	int opt;
	if(options >= 100) // 3 digits
	{
		options_length = 3;
		int opt1 = (options - options % 100) / 100;
		int tens = options - opt1 * 100;
		int opt2 = (tens - tens % 10) / 10;
		int opt3 = tens % 10;
		
		for(int i=4; i>-1; i--)
		{
			if( (i == opt1) || (i == opt2) || (i == opt3) )
				display_group[i].inner->show();
			else 
				display_group[i].inner->hide();
				
			if(disp == i)
				display_group[i].inner->active = true;
			else 
				display_group[i].inner->active = false;
			display_group[i].inner->queue_draw();
		}
		
	}
	else // 2 digits
	{
		options_length = 2;
		int opt1 = (options - options % 10) / 10;
		int opt2 = options % 10;
		
		for(int i=4; i>-1; i--)
		{
			if( (i == opt1) || (i == opt2) )
				display_group[i].inner->show();
			else 
				display_group[i].inner->hide();
				
			if(disp == i)
				display_group[i].inner->active = true;
			else 
				display_group[i].inner->active = false;
			display_group[i].inner->queue_draw();
		}
	}	
	//printf("Selected options inside on_area_clicked are %d\n", options);
}

// This function is called when the user clicks on existing note, which
// will either select or deselect it. It is also called when user misses 
// the note and clicks on empty area space.
bool ExampleWindow::on_area_clicked(GdkEventButton* button_event)
{
	Note * candidate_note, * clicked_note;
	Dlnode * buffer_list;
	bool found = false;
	int x = button_event->x;
	int y = button_event->y;
	int y_correction;
//	printf("Area clicked at %d, %d\n", x, y);
	int chord_index = (x - (x % 53) ) / 53; // starts from 0
//	printf("chord index is  %d\n", chord_index);
	
	// find if any chords are there at this x:
	int length = Dlist::dl_count (area.current_sequence);
	if( chord_index < length )
	{
		Dlnode * clicked_chord = (Dlnode *) (Dlist::dl_nth_node
					(area.current_sequence, chord_index)->data);
		//printf("This chord has %d notes\n", Dlist::dl_count(clicked_chord) );

			// find if any notes are there in this chord at this y:
		for(int i = 0; i < Dlist::dl_count (clicked_chord); i++) 
		{   
			
			candidate_note = (Note *) (Dlist::dl_nth_node
					(clicked_chord, i)->data);
			int candidate_y = candidate_note->position_y;
			int interval = 0;
			if( (candidate_y > 0 && candidate_y < 62) || (candidate_y > 420 ) )
			{ 		interval = 15;	y_correction = 12;}	
			else {  interval = 18;	y_correction = 12;}	
			
			candidate_y += y_correction;	
			
			//printf("Note %d, candidate_y is %d\n", i, candidate_y);
			if(y > candidate_y && y < candidate_y + interval)
			{
	//			puts("found note to be selected or deselected");
				clicked_note = candidate_note;
				found = true;
			}
	
		}
	} 
	
	if (found == false) // clicked on empty area
		return true;
	
	// Now that we found the selected note, let's do something with it
	if(clicked_note->selected == false)
	{
		if(multiple_select == false)
		{
			
			if(Dlist::dl_count(selected_notes) > 1) // there are already
											// selected notes in it
			{	
			// deselect previously selected note and make clicked note selected
				buffer_list = Dlist::dl_nth_node(selected_notes, 1);
				selected_note->selected = false;
				selected_notes = Dlist::dl_delete_node(selected_notes, buffer_list);
			
				clicked_note->selected = true;
				selected_note = clicked_note;	
				selected_notes = Dlist::dl_append(selected_notes, clicked_note ) ;
			}
			else // no selected notes yet
			{
				// add clicked note to selected_notes and make it selected
				clicked_note->selected = true;
				selected_notes = Dlist::dl_append(selected_notes, clicked_note );
				selected_note = clicked_note;
				if(mode == 3)
				{
					set_velocity_b.set_sensitive(true);
					sc->set_sensitive(true);
				}
			}
		
	//		printf("Number of selected notes: %d\n", Dlist::dl_count(selected_notes) );
			
			if(mode == 3) // Edit Note Mode
			{	// Due to the unique nature of select options for each
				// individual note, the only way to change of view them is
				// to use single note select mode.
	
				display_note_options(clicked_note);
				display_VBox.show();
					// set the velocity scale value
				sc->set_value(selected_note->velocity );
			}
		}
		else  // multiple_select is true
		{
			// add clicked note to selected_notes and make it selected
	//		puts("inside if multiple_select is true and note selected false");
			clicked_note->selected = true;
			selected_notes = Dlist::dl_append(selected_notes, clicked_note );
		}
	}
	else if(clicked_note->selected == true)
	{
		
		
		if( Dlist::dl_count(selected_notes) == 2 && multiple_select == false)
		// this means that if there is one selected note (without dummy note)
		// in the list of selected notes and it needs to be deselected, so 
		// there will be no selected notes on the screen. First argument is not
		// necessary, it is there just for clarification.
		{
			// only one note is selected in single select mode and it needs
			// to be deselected
			selected_note = NULL;
			set_velocity_b.set_sensitive(false);
			sc->set_sensitive(false);
			display_VBox.hide();
		}
		clicked_note->selected = false;
		int index = Dlist::dl_index (selected_notes, clicked_note);
		buffer_list = Dlist::dl_nth_node(selected_notes, index);
		selected_notes = Dlist::dl_delete_node(selected_notes, buffer_list);
		
			
	}
	area.queue_draw();
	return true;
}

bool ExampleWindow::on_mult_select_clicked(GdkEventButton* button_event)
{
	Dlnode * buffer_list;
	Note * buffer_note;
	if(mult_select_b->pressed == false)
	{
		multiple_select = true;
		mult_select_b->pressed = true;
		
		// hide all display radio buttons
		sharpsharp_rad.inner->hide();
		flatflat_rad.inner->hide();
		normal_rad.inner->hide();
		flat_rad.inner->hide();
		sharp_rad.inner->hide();
		selected_note = NULL;
	}
	else if(mult_select_b->pressed == true)
	{
		multiple_select = false;
		mult_select_b->pressed = false;
		// deselect all notes
		while( Dlist::dl_count(selected_notes) > 1 )
		{	
			buffer_list = Dlist::dl_nth_node(selected_notes, 1);
			buffer_note = (Note *) (buffer_list->data);
			buffer_note->selected = false;
					
			selected_notes = Dlist::dl_delete_node(selected_notes, buffer_list);
		}
		selected_note = NULL;
	}
	mult_select_b->queue_draw ();
	area.queue_draw();
	return true;
}

bool ExampleWindow::on_mult_select_leave(GdkEventCrossing* crossing_event)
{
	mult_select_b->over = false;
	mult_select_b->queue_draw ();
	return true;
}

bool ExampleWindow::on_mult_select_enter(GdkEventCrossing* crossing_event)
{
	mult_select_b->over = true;
	mult_select_b->queue_draw ();
	return true;
}

void ExampleWindow::on_set_velocity()
{
	Note * n;
	
	if(multiple_select == false)
	{
		if(selected_note != NULL)
		{
			selected_note->velocity = adj->get_value();
			std::cout << (_("velocity set") ) << "\n";
		}
	}
	else // multiple select is true
	{
		for(int i=1; i<Dlist::dl_count(selected_notes); i++)
		{
			n = (Note *) Dlist::dl_nth_data(selected_notes, i);
			n->velocity = adj->get_value();
			std::cout << (_("velocity set") ) << "\n";
		}
	}
	
}

void ExampleWindow::on_inst_combo_changed()
{
	int id;
	Glib::ustring name;
	Gtk::TreeModel::iterator iter = inst_combo.get_active();
	
	if(iter)
	{
		Gtk::TreeModel::Row row = *iter;
		if(row)
		{
			//Get the data for the selected row, using our knowledge 
			//of the tree model:
			id = row[m_Columns.m_col_id];
			name = row[m_Columns.m_col_name];
						
			message[0] = 192  + channel - 1; 
			message[1] =  id;
			message.pop_back();
			midiout->sendMessage( &message );
			message.push_back(0);
	//		puts("inside combo changed");
		}
	}
	else
		std::cout << _("invalid combo iterator") << std::endl;
}

void ExampleWindow::on_copy_chord()
{
	// You cannot delete the original chord, if you do, paste will not work
	copied_chord = area.current_chord;	
}

void ExampleWindow::on_paste_chord()
{
	if(copied_chord != NULL)
	{	
		Note * buffer_note;
		int length = Dlist::dl_count(copied_chord);
		Dlnode * buffer = area.current_chord;
		int buffer_length = Dlist::dl_count(buffer);

		if (buffer_length > 1)
		{
			Glib::ustring  message ( _("Sorry, but you cannot paste over existing chord.\n\
 First create a space for it using New Chord button.") );
			
			Gtk::MessageDialog dialog(*this,  message );
			dialog.run();
			return;
		}
		
		// copy all notes to new location
		for(int i = 1; i<length; i++)
		{
			buffer_note = (Note *) Dlist::dl_nth_data(copied_chord, i);
			Note * n = new Note(buffer_note->midi_number);
			n->normal_x = (selected_chord_number - 1) * 53 ;
			n->update_x();
			n->velocity = buffer_note->velocity;
			n->midi_channel = buffer_note->midi_channel;
			n->midi_instrument = buffer_note->midi_instrument;
			n->display = buffer_note->display;
			n->update_display();
			area.current_chord = Dlist::dl_append(area.current_chord, n );
		}
		area.queue_draw();
	}	
}

// This function is called two times in the code, one from close_and_save(), 
// and one from clicking save button in the main window
// This function shows window with entry box where new name can be entered,
// saves current sequence along with other sequences
// into a file saved_sequences.txt
void ExampleWindow::on_save()
{
	Dlnode  * buffer_chord;
	Dlnode * buffer_chord_link;
	int chord_length, sequence_length;
    bool is_empty = true;
    sequence_length = Dlist::dl_count(area.current_sequence);
    
    // check if current sequence is empty (not counting dummy notes)
    for(int i = 0; i < sequence_length; i++)
	{
		buffer_chord_link = Dlist::dl_nth_node(area.current_sequence, i);
		buffer_chord = (Dlnode *) buffer_chord_link->data; //chord
			
	//	std::cout << "i is " << i << std::endl;
		
		chord_length = Dlist::dl_count(buffer_chord);
		//std::cout << "Chord length is " << chord_length << std::endl;
		if(chord_length > 1)
		{
			is_empty = false;
			break;
		}
	}
	
	if(is_empty)
	{
		Glib::ustring  message ( _("Nothing to save") );
		
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	
	// if sequence is saved, i.e. has a name, display a dialog that will
	// give a choice whether to rename the current sequence or not
	if(is_sequence_named)
	{
		rename_dialog = new Gtk::Window;
		Gtk::Box *r_vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0) );
		rename_dialog->add(*r_vbox);
		Gtk::Grid *r_grid = Gtk::manage(new Gtk::Grid);
		r_grid->set_border_width(10);
		r_grid->set_row_spacing(5);
		r_vbox->add(*r_grid);
		Gtk::Label *r_lb = Gtk::manage(new Gtk::Label(_("Do you want to rename or save current sequence?") ) );
		r_grid->attach(*r_lb, 0, 0, 3, 1);
		
		Gtk::Button * button_rename = Gtk::manage(new Gtk::Button(_("Rename") ) );
		button_rename->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
				(*this, &ExampleWindow::rename_current_sequence), rename_dialog) );
		r_grid->attach(*button_rename, 0, 1, 1, 1);
		
		Gtk::Button * button_justsave = Gtk::manage(new Gtk::Button(_("Just Save") ) );
		button_justsave->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
				(*this, &ExampleWindow::just_save_current_sequence), rename_dialog) );
		r_grid->attach(*button_justsave, 1, 1, 1, 1);	
		
		Gtk::Button * button_cancel = Gtk::manage(new Gtk::Button(_("Cancel") ) );	
		button_cancel->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
				(*this, &ExampleWindow::cancel_rename_current_sequence), rename_dialog) );
		r_grid->attach(*button_cancel, 2, 1, 1, 1);
		r_vbox->show_all();
		rename_dialog->show();		
	}
	else
	{
	// if current sequence is not saved yet, pop up a dialog that asks
	// for a name

	save_dialog = new Gtk::Window;
	Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0) );
    save_dialog->add(*vbox);
	Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    vbox->add(*grid);
	Gtk::Label *lb = Gtk::manage(new Gtk::Label(
					_("Please enter descriptive name for this sequence:") ));
    grid->attach(*lb, 0, 0, 1, 1);
	Gtk::Entry *name = Gtk::manage(new Gtk::Entry() );
    name->set_hexpand(true);
	grid->attach(*name, 0, 1, 1, 1);
	
	Gtk::Button *blogin = Gtk::manage(new Gtk::Button(_("Save Sequence") ) );
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*>(sigc::mem_fun 
				(*this, &ExampleWindow::save_current_sequence), name) );
    grid->attach(*blogin, 0, 2, 1, 1);

    vbox->show_all();
	save_dialog->show();
	}

}// end on_save()

// This function names or renames current sequence and saves it
void ExampleWindow::save_current_sequence(Gtk::Entry *name)
{
	Glib::ustring * buffer, * second_buffer;
	Sequence * buf_node;
	buffer = new Glib::ustring(name->get_text() );

	if(buffer->length() == 0) // empty string
	{
		Glib::ustring message(_("You did not enter the name") );
		
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	// check if name already exist in the list of other names
	buf_node = g_sequences;
	while(buf_node != NULL)
	{	
		if(buf_node->name != NULL)
		{
			second_buffer = buf_node->name;
			if(*buffer == *second_buffer)
			{
				Glib::ustring message(_("This name is already in the list") );
				
				Gtk::MessageDialog dialog(*this, message);
				dialog.run();
				return;
			}
		}
		buf_node = buf_node -> next;
	}

	// if we got here, that means name is not on the list: add it to the list

	// if sequence is named,  change the name
	if(is_sequence_named)
	{ 
		// change name in the sequence_names
		//Dlnode * link = Dlist::dl_find(sequence_names, current_sequence_name);
		//delete current_sequence_name;
		//current_sequence_name = buffer;
		//link->data = current_sequence_name;
		
		// change name in the sequence
		current_sequence_name = (Glib::ustring*) area.curs_node->name; 
		delete current_sequence_name;
		area.curs_node->name = buffer;
		
		Glib::ustring title = "Chord Sequencer : " + *buffer;
		set_title(title);
	}	
	else // (! is_sequence_named)
	{
		// new unnamed sequence is always at index 0
		// sequence_names = Dlist::dl_prepend(sequence_names, buffer ) ;
			
		// change name in the sequence
		current_sequence_name = (Glib::ustring*) area.curs_node->name; 
		delete current_sequence_name;
		area.curs_node->name = buffer;
		current_sequence_name = buffer;
		
		Glib::ustring title = "Chord Sequencer : " + *buffer;
		set_title(title);
	}	
	is_sequence_named = true;
	
	// Save all sequences into a file:
	save_all();
	save_dialog->hide();
} 

// This function saves all sequences into a file saved_sequences.txt
// It should be called only when there are no unnamed new sequences.
// All sequences should be named before calling this function.
void ExampleWindow::save_all()
{
	Glib::ustring * buffer;
	int total_length;
	//std::ofstream out("saved_sequences.txt");
	std::ofstream out("saved_sequences.txt");
	if(!out)
	{
		std::cout << _("Cannot open file saved_sequences.txt") << std::endl;
		return;
	}
	
	//std::cout << "Inside save_all()\n";
	if(is_sequence_named)
		total_length = Dlist::dl_count(g_sequences);
	else
		total_length = Dlist::dl_count(g_sequences) - 1;
	int sequence_length, chord_length;
	Dlnode * buffer_sequence;
	Sequence * buffer_seq_node;
	Dlnode * buffer_chord;
	Note * buffer_note;
	Glib::ustring * buffer_name;
	puts("inside save all");
	for(int i=0; i<total_length; i++)
	{
		if(is_sequence_named)
			buffer_sequence = (Dlnode *) (Dlist::dl_nth_node(g_sequences, i)->data);
		else
			buffer_sequence = (Dlnode *) (Dlist::dl_nth_node(g_sequences, i + 1)->data);
		
		buffer_seq_node = Dlist::dl_find(g_sequences, buffer_sequence);	
		buffer_name = (Glib::ustring *) buffer_seq_node->name;
		sequence_length = Dlist::dl_count(buffer_sequence);
		out << "Sequence <" << *buffer_name << ">, size=" << sequence_length << std::endl;
	
		for(uint j=0; j < sequence_length; j++)
		{
			buffer_chord = (Dlnode *) (Dlist::dl_nth_node(buffer_sequence, j)->data);
			chord_length = Dlist::dl_count(buffer_chord);
			out << "\tChord <" << (j+1) << ">" << std::endl;
	
			for(uint k=1; k < chord_length; k++)
			{
				buffer_note = (Note *) (Dlist::dl_nth_node(buffer_chord, k)->data);
				// write down all 6 attributes of the note, 
				// skipping buffer notes
				out << "\t\tNote <" << buffer_note->midi_number << ">" << std::endl;
				out << "\t\t\tvelocity = " << buffer_note->velocity << std::endl;
				out << "\t\t\tmidi_instrument = " << buffer_note->midi_instrument << std::endl;
				out << "\t\t\tdisplay_options = " << buffer_note->display_options << std::endl;
				out << "\t\t\tdisplay = " << buffer_note->display << std::endl;
				out << "\t\t\tmidi_channel = " << buffer_note->midi_channel << std::endl;
			}
		}
		
	// Write section bases
		Dlnode * buf_base_node = (Dlnode*)buffer_seq_node->section_bases;
		Section_base * buf_base;
		Glib::ustring * base_name;
		while(buf_base_node != NULL)
		{
			buf_base = (Section_base *) buf_base_node->data;
			base_name  = (Glib::ustring*) buf_base->name;
			if(base_name != NULL)
				out << "\tBase <" << *base_name	<< ">" << std::endl;
			else
				out << "\tBase <>" << std::endl;
			out << "\t\tChord start = " << buf_base->chord_start << std::endl;
			out << "\t\tChord end = " << buf_base->chord_end << std::endl;
			out << "\t\tLength = " << buf_base->length << std::endl;
			buf_base_node = buf_base_node->next;
		}
		
		// Write sections and section buttons
		Dlnode * buf_sect_node = (Dlnode*) buffer_seq_node->sections;
		MyButton * buf_btn;
		Glib::ustring * sect_name;
		while(buf_sect_node != NULL)
		{
			buf_btn = (MyButton *) buf_sect_node->section_button;
			sect_name = (Glib::ustring*) buf_btn->sect_name;
			if(sect_name != NULL)
				out << "\tSection <" << *sect_name << ">" << std::endl;
			else
				out << "\tSection <>" << std::endl;
			out << "\t\tsect_start = " << buf_btn->sect_start << std::endl;
			out << "\t\tsect_end = " << buf_btn->sect_end << std::endl;
			out << "\t\tsect_chord_start = " << buf_btn->sect_chord_start 
										<< std::endl;
			out << "\t\tsect_chord_end = " << buf_btn->sect_chord_end
										<< std::endl;
			out << "\t\tsect_chord_length = " << buf_btn->sect_chord_length
										<< std::endl;
			out << "\t\tsect_pix_length = " << buf_btn->sect_pix_length
										<< std::endl;
			buf_sect_node = buf_sect_node->next;
		}
	} 
	out.close();
	puts("saved");
}

void ExampleWindow::rename_current_sequence(Gtk::Window* win)
{
	save_dialog = new Gtk::Window;
	Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0) );
    save_dialog->add(*vbox);
	Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    vbox->add(*grid);
	Gtk::Label *lb = Gtk::manage(new Gtk::Label(
					_("Please enter descriptive name for this sequence:")));
    grid->attach(*lb, 0, 0, 1, 1);
	Gtk::Entry *name = Gtk::manage(new Gtk::Entry() );
    name->set_hexpand(true);
	grid->attach(*name, 0, 1, 1, 1);
	
	Gtk::Button *blogin = Gtk::manage(new Gtk::Button(_("Save Sequence") ) );
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*>(sigc::mem_fun 
				(*this, &ExampleWindow::save_current_sequence), name) );
    grid->attach(*blogin, 0, 2, 1, 1);

    vbox->show_all();
	save_dialog->show();
	win->hide();
}

// This function is called when user clicks save button and then chooses
// "Just Save" option from the popup dialog
void ExampleWindow::just_save_current_sequence(Gtk::Window* win)
{
	win->hide();
	save_all();
}

// This function is called when user clicks save button and then chooses
// "Cancel" option from the popup dialog
void ExampleWindow::cancel_rename_current_sequence(Gtk::Window* win)
{
	puts(_("canceling...") );
	win->hide();
}



ExampleWindow::SequenceWindow::SequenceWindow()
: m_Button_Select(_("Select") ),
m_Button_Delete(_("Delete") ), 
m_Button_New(_("New Sequence") ), 
m_Button_Cancel(_("Cancel") )  
{
	set_title(_("Sequences") );
	set_border_width(5);
	set_default_size(400, 200);
	add(m_VBox);
	//Add the TreeView, inside a ScrolledWindow, with the button underneath:
	m_ScrolledWindow.add(m_TreeView);
	//Only show the scrollbars when they are necessary:
	m_ScrolledWindow.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	m_VBox.pack_start(m_ScrolledWindow);
	m_VBox.pack_start(m_ButtonBox, Gtk::PACK_SHRINK);
	m_ButtonBox.pack_start(m_Button_New, Gtk::PACK_SHRINK);
	m_ButtonBox.pack_start(m_Button_Delete, Gtk::PACK_SHRINK);
	m_ButtonBox.pack_start(m_Button_Select, Gtk::PACK_SHRINK);
	m_ButtonBox.pack_start(m_Button_Cancel, Gtk::PACK_SHRINK);
	m_ButtonBox.set_border_width(5);
	m_ButtonBox.set_layout(Gtk::BUTTONBOX_START);
	
	//Create the Tree model:
	m_refTreeModel = Gtk::ListStore::create(m_Columns);
	m_TreeView.set_model(m_refTreeModel);

	//Add the TreeView’s view columns:
	//This number will be shown with the default numeric formatting.
	m_TreeView.append_column("ID", m_Columns.m_col_id);
	m_TreeView.append_column("Name", m_Columns.m_col_name);
	
}

ExampleWindow::SequenceWindow::~SequenceWindow()
{
}

void ExampleWindow::SequenceWindow::update()
{
	m_refTreeModel->clear();
	//Fill the TreeView’s model
	Gtk::TreeModel::Row row;

	// iterate through the sequence names and display each

	Sequence * buf_seq_node = g_sequences;
	puts("line 3021");
	Glib::ustring * name;
	int count = 1;
	while(buf_seq_node != NULL)
	{
		if(buf_seq_node->name != NULL)
		{
			name = (Glib::ustring *) buf_seq_node->name;
			row = *(m_refTreeModel->append());
			row[m_Columns.m_col_id] = count;
			row[m_Columns.m_col_name] = *name;
			count++;
		}
		buf_seq_node = buf_seq_node->next;
	}
	
	puts("line 3034");
	Glib::RefPtr<Gtk::TreeSelection> selection = m_TreeView.get_selection();
	selection->set_mode(Gtk::SELECTION_BROWSE);

	show_all_children();
}
	

// This function is called when m_Button_Select from SequenceWindow is clicked
void ExampleWindow::select_sequence(Gtk::TreeView * view)
{
	Dlnode  * buffer_note_link, * buffer_chord;
	Dlnode * buffer_chord_link;
	int chord_length, sequence_length;
    bool is_empty = true;
    sequence_length = Dlist::dl_count(area.current_sequence);
	
	Glib::RefPtr<Gtk::TreeSelection> selection = view->get_selection();
	Gtk::TreeModel::iterator selectedRow = selection->get_selected();
	Gtk::TreeModel::Row m_row = *selectedRow;
	const Glib::ustring str_val = m_row.get_value(m_Columns.m_col_name);
	Glib::ustring * str = new Glib::ustring(str_val);
	// str = &str_val;
	std::cout << "inside select seq " << *str << std::endl;
	
	
	// check if current sequence is empty (not counting dummy notes)
    for(int i = 0; i < sequence_length; i++)
	{
		buffer_chord_link = Dlist::dl_nth_node(area.current_sequence, i);
		buffer_chord = (Dlnode *) buffer_chord_link->data; //chord
			
	//	std::cout << "i is " << i << std::endl;
		
		chord_length = Dlist::dl_count(buffer_chord);
		//std::cout << "Chord length is " << chord_length << std::endl;
		if(chord_length > 1)
		{
			is_empty = false;
			break;
		}
	}
	
	if(is_empty && ! is_sequence_named)
	{
		close_and_select(NULL, str);
		return;
	}
	
	// if current sequence does not have a name, ask for a name to save it
	if(! is_sequence_named)
	{
		save_or_not_dialog = new Gtk::Window;
		Gtk::Box *sn_vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0) );
		save_or_not_dialog->add(*sn_vbox);
		Gtk::Grid *sn_grid = Gtk::manage(new Gtk::Grid);
		sn_grid->set_border_width(10);
		sn_grid->set_row_spacing(5);
		sn_vbox->add(*sn_grid);
		Gtk::Label * sn_lb = Gtk::manage(new Gtk::Label(_("Do you want to save the current sequence?")));
		sn_grid->attach(*sn_lb, 0, 0, 2, 1);
		
		Gtk::Button * sn_button_rename = Gtk::manage(new Gtk::Button(_("Save") ) );
		sn_button_rename->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
				(*this, &ExampleWindow::close_and_save), save_or_not_dialog) );
		sn_grid->attach(*sn_button_rename, 0, 1, 1, 1);
		
		// multiple arguments binding example !
		Gtk::Button * sn_button_cancel = Gtk::manage(new Gtk::Button(_("Don't save") ) );
		sn_button_cancel->signal_clicked().connect(sigc::bind<Gtk::Window*, Glib::ustring*>(sigc::mem_fun 
				(*this, &ExampleWindow::close_and_select), save_or_not_dialog, str) );
		sn_grid->attach(*sn_button_cancel, 1, 1, 1, 1);		
		sn_vbox->show_all();
		save_or_not_dialog->show();		
	}
	else // current sequence has a name
	{
		// make selected sequence current - display on the screen
		// find the number of selected sequence
		// At this point the length of sequence_names equals length of g_sequences

		load_sequence( str);
	}
	area.queue_draw();
	// close sequences window
	s_win.hide();
} // end select_sequence()

// This function is called when the user clicks on the "Delete" button 
// in the sequence window
void ExampleWindow::delete_sequence(Gtk::TreeView * view)
{
	Glib::RefPtr<Gtk::TreeSelection> selection = view->get_selection();
	Gtk::TreeModel::iterator selectedRow = selection->get_selected();
	Gtk::TreeModel::Row m_row = *selectedRow;
	Glib::ustring str = m_row.get_value(m_Columns.m_col_name);
	//std::cout << "inside delete seq " << str << std::endl;
	
	Sequence * seq_node = g_sequences;
	Sequence * node_to_delete;
	Glib::ustring * buf_string;
	while(seq_node != NULL)
	{
		if(seq_node->name != NULL)
		{
			buf_string = (Glib::ustring *) seq_node->name;
			if(*buf_string == str)
			{
				node_to_delete = seq_node;
				break;
			}
		}
		seq_node = seq_node->next;
	}
	
	Dlnode * seq_data_to_delete = (Dlnode*) node_to_delete->data;
	if( seq_data_to_delete == area.current_sequence )
	{
		Glib::ustring message(_("Cannot delete current sequence,\n\
 select another sequence first") );
		
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	
	
	
	
	// ask are you sure want to delete?
	areusure_dialog = new Gtk::Window;
	Gtk::Box * areusure_vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0) );
	areusure_dialog->add(*areusure_vbox);
	Gtk::Grid *areusure_grid = Gtk::manage(new Gtk::Grid);
	areusure_grid->set_border_width(10);
	areusure_grid->set_row_spacing(5);
	areusure_vbox->add(*areusure_grid);
	Gtk::Label *areusure_lb = Gtk::manage(new Gtk::Label(_("Are you sure you want to delete this sequence?")));
	areusure_grid->attach(*areusure_lb, 0, 0, 2, 1);
	
	Gtk::Button * button_yes = Gtk::manage(new Gtk::Button(_("Delete") ) );
	button_yes->signal_clicked().connect(sigc::bind<Gtk::Window*, Glib::ustring>(sigc::mem_fun 
			(*this, &ExampleWindow::delete_sequence_yes), areusure_dialog, str) );
	areusure_grid->attach(*button_yes, 0, 1, 1, 1);
	
	Gtk::Button * button_no = Gtk::manage(new Gtk::Button(_("Cancel") ) );
	button_no->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
			(*this, &ExampleWindow::cancel_delete_sequence), areusure_dialog) );
	areusure_grid->attach(*button_no, 1, 1, 1, 1);		
	areusure_vbox->show_all();
	areusure_dialog->show();		
} // end delete_sequence

// This function is called when "New sequence" button is pressed in 
// sequence window
void ExampleWindow::new_sequence()
{
	
	Dlnode  * buffer_note_link, * buffer_chord;
	Dlnode * buffer_chord_link;
	int chord_length, sequence_length;
    bool is_empty = true;
    sequence_length = Dlist::dl_count(area.current_sequence);
    
    // check if current sequence is empty (not counting dummy notes)
    for(int i = 0; i < sequence_length; i++)
	{
		buffer_chord_link = Dlist::dl_nth_node(area.current_sequence, i);
		buffer_chord = (Dlnode *) buffer_chord_link->data; //chord
		chord_length = Dlist::dl_count(buffer_chord);
		//std::cout << "Chord length is " << chord_length << std::endl;
		if(chord_length > 1)
		{
			is_empty = false;
			break;
		}
	}
	
	if(! is_sequence_named && is_empty)
	{
		// close sequences window
		area.queue_draw();
		s_win.hide();
		return;
	}
	// if current sequence does not have a name, ask for a name to save it
	else if(! is_sequence_named && ! is_empty )
	{
		save_or_not_dialog = new Gtk::Window;
		Gtk::Box *sn_vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0) );
		save_or_not_dialog->add(*sn_vbox);
		Gtk::Grid *sn_grid = Gtk::manage(new Gtk::Grid);
		sn_grid->set_border_width(10);
		sn_grid->set_row_spacing(5);
		sn_vbox->add(*sn_grid);
		Gtk::Label * sn_lb = Gtk::manage(new Gtk::Label(_("Do you want to save the current sequence?")));
		sn_grid->attach(*sn_lb, 0, 0, 2, 1);
		
		Gtk::Button * sn_button_rename = Gtk::manage(new Gtk::Button(_("Save") ) );
		sn_button_rename->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
				(*this, &ExampleWindow::close_and_save), save_or_not_dialog) );
		sn_grid->attach(*sn_button_rename, 0, 1, 1, 1);
		
		Gtk::Button * sn_button_cancel = Gtk::manage(new Gtk::Button(_("Don't save") ) );
		sn_button_cancel->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
				(*this, &ExampleWindow::close_and_new), save_or_not_dialog) );
		sn_grid->attach(*sn_button_cancel, 1, 1, 1, 1);		
		sn_vbox->show_all();
		save_or_not_dialog->show();		
		return;
	}
	
	// remove all eventboxes from section_HBox
	Dlnode * buf_sect = (Dlnode *) area.curs_node->sections;
	Gtk::EventBox * buf_evbox;
	while(buf_sect != NULL)
	{
		buf_evbox = (Gtk::EventBox*) buf_sect->eventbox;
		section_HBox.remove(*buf_evbox);
		buf_sect = buf_sect->next;
	}
	
	// empty selected_notes and selected_note
	for(int i=1; i<Dlist::dl_count(selected_notes); i++)
	{
		Dlnode * buffer_node = Dlist::dl_nth_node(selected_notes, 1);
		Note * buffer_note = (Note *) buffer_node->data;
		buffer_note->selected = false;
		selected_notes = Dlist::dl_delete_node(selected_notes, buffer_node);
	}
	if(selected_note != NULL)
		selected_note->selected = false;
	
	set_velocity_b.set_sensitive(false);
	sc->set_sensitive(false);
	
	
	// make a new sequence 
	Note * dummy_note = new Note(-1000);
	Dlnode * new_seq = Dlist::dl_create();
	Dlnode * new_chord = Dlist::dl_create();
	new_chord->data = dummy_note;
	new_seq->data = new_chord;
	
	// add it to the list - new unnamed sequence is always at index 0
	g_sequences = (Sequence *) Dlist::dl_prepend(g_sequences, new_seq);
	// make it current sequence - show on the screen
	area.current_sequence = new_seq;
	area.curs_node = Dlist::dl_find(g_sequences, new_seq);
	set_title("Chord Sequencer");
	// Do not change current sequence name - !!! --
	// this is done in save_current_sequence() when the proper button is
	// clicked
	
	// change section bases to new
	Dlnode * new_base_node =  Dlist::dl_create();
	area.curs_node->section_bases = new_base_node;
	Section_base * new_base = new Section_base();
	new_base_node->data = new_base;
	new_base->chord_start = 1;
	new_base->chord_end = 1;
	new_base->length = 1;
	new_base->name = NULL;

	
	// change sections  and section buttons with eventboxes to new
	Dlnode * init_sect = Dlist::dl_create();
	area.curs_node->sections = init_sect;  
	Gtk::EventBox * init_evbox = new Gtk::EventBox();
	init_sect->eventbox = init_evbox;
	MyButton * init_sec_but = new MyButton();
	init_sec_but->sect_chord_start = 1;
	init_sec_but->sect_chord_end = 1;
	init_sec_but->sect_chord_length = 1;
	init_sec_but->button_type = 4;
	init_sec_but->sect_start = 0;
	init_sec_but->sect_end = 430;
	init_sec_but->sect_pix_length = 430;
	init_sec_but->set_size_request(430, 30);
	init_sec_but->sect_name = NULL;
	init_sect->section_button = init_sec_but;
	init_evbox->add(*init_sec_but);
	section_HBox.add(*init_evbox);
		
	init_evbox->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK | Gdk::LEAVE_NOTIFY_MASK );
	init_evbox->signal_button_press_event().connect(sigc::bind<MyButton *>(
		sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_clicked), init_sec_but) );
	init_evbox->signal_enter_notify_event().connect(sigc::bind<MyButton *>(
		sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_enter), init_sec_but) );
	init_evbox->signal_leave_notify_event().connect(sigc::bind<MyButton *>(
		sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_leave), init_sec_but) );
	
	selected_section = NULL;
	
	// mark corresponding chord buttons - 0 start notation
	int cur_seq_length = Dlist::dl_count(area.current_sequence);
	for (int i=0; i<64; i++)
	{
		if(i<cur_seq_length)
			chord_radio_buttons[i]->occupied = true;
		else
			chord_radio_buttons[i]->occupied = false;
		chord_radio_buttons[i]->pressed = false;
		chord_radio_buttons[i]->queue_draw (); 
	}
	chord_radio_buttons[0]->pressed = true;
	chord_radio_buttons[0]->queue_draw();

	area.curs_node_copy = copy_sequence(area.curs_node);
		
	// change selected chord and selected chord number
	selected_chord_number = 1;
	area.current_chord = new_chord;
	is_sequence_named = false;
	section_HBox.show_all_children();
	section_HBox.show();
	// close sequences window
	area.queue_draw();
	s_win.hide();
	
} // end new_sequence()

// This function is called when the user selected another sequence or 
// clicked new sequence button and decided to save the current one. 
// The current sequence does not have a name yet.
void ExampleWindow::close_and_save(Gtk::Window* win)
{
	// This function will be called alone when the user clicks save button
	// in the main window
	on_save();
	
	win->hide();
	s_win.hide();
}


// This function is called when the user selected another sequence and
// decided not to save the current one, or the current sequence is empty
// (in that case it is called with win == NULL) The current sequence does not 
// have a name yet.

// Think of how to keep unedited versions of 
// sequences in case user makes changes and decides not to save them.
void ExampleWindow::close_and_select(Gtk::Window* win, Glib::ustring * str)
{
	std::cout << "Str is " << *str << std::endl;
	if(str->length() == 0)
	{
		Gtk::MessageDialog dialog(*this, _("Nothing to select") );
		dialog.run();
	}
	else
	{	
		// if we got here, that means selected sequence has a name, 
		// but current_sequence does not have a name.

		clear_new_sequence();
		
		// delete current sequence node data and the node itself. Asserted 
		// that there is more than one
		// sequence in the list, because we are in the process of selecting 
		// another one.
		Dlnode * current_sequence_node =  Dlist::dl_find (g_sequences, 
											area.current_sequence);
		delete(area.current_sequence);
		g_sequences = (Sequence *)Dlist::dl_delete_node (g_sequences,
										current_sequence_node);
		puts("Line 3059\n");
		// Sequence_names do not need to be changed
									
		load_sequence(str);
	} // end else
	area.queue_draw();
	
	if(win != NULL)
		win->hide();
	s_win.hide();
} // end close_and_select()


// This function deletes all data inside current sequence (which is 
// supposedly a new unnamed sequence), but does not delete current
// sequence node and current sequence node data (area.current_sequence)
void ExampleWindow::clear_new_sequence()
{
		Dlnode * current_sequence_node =  Dlist::dl_find (g_sequences, 
											area.current_sequence);
      //  Dlnode * current_name_node = Dlist::dl_find (sequence_names,
      //       current_sequence_name);
        Note * buffer_note;
        int chord_length, sequence_length;
        
		 // empty selected_notes and selected_note (leave dummy_selected_note)
		for(int i=1; i<Dlist::dl_count(selected_notes); i++)
		{
			Dlnode * buffer_list = Dlist::dl_nth_node(selected_notes, 1);
			Note * buffer_note = (Note *) buffer_list->data;
			buffer_note->selected = false;
			selected_notes = Dlist::dl_delete_node(selected_notes, buffer_list);
		}
		if(selected_note != NULL)
			selected_note->selected = false;
		// selected_note = NULL;
		set_velocity_b.set_sensitive(false);
		sc->set_sensitive(false);
		
		// delete current sequence node and everything inside
		sequence_length = Dlist::dl_count(area.current_sequence);
		std::cout << "Length is " << sequence_length << std::endl;
		// area.current_sequence is the head of the chords list
		Dlnode * l, * note_head, * note_node, * prev_node;
		Note * note;
	
		// This will delete all nodes except for head node 
		l = area.current_sequence->next;
		while(l != NULL)
		{
			area.current_sequence->next = l -> next;
			
			note_head = (Dlnode *) (l->data);
			// This will delete all nodes except for head node 
			note_node = note_head -> next;
			while(note_node != NULL)
			{
				note_head->next = note_node->next;
				// remove the data
				note = (Note *) note_node->data;
				delete(note);
				note_node->next = NULL;
				delete(note_node);
				note_node = note_head->next;
			}
			// Delete head node data and the head node
			note = (Note *) note_head->data;
			delete note;
			delete((Dlnode *) l->data); // note_head
			
			
			l -> next = NULL;
			delete (l);
			l = area.current_sequence->next;
		}
		
		// delete all notes except for dummy note in the first chord 
		// (the only one)
		// This will delete all nodes except for head node 
		note_head = (Dlnode*) area.current_sequence->data;
		note_node = note_head->next;
		Note * n;
		while(note_node != NULL)
		{
			note_head->next = note_node->next;
			note_node->next = NULL;
			// remove the data
			n = (Note *) note_node->data;
			delete(n);
			delete note_node;
			note_node = note_head->next;
		}
		
		// delete all section_bases, except for the head node
		// This will delete all nodes except for head node
		Section_base * buf_base;
		Dlnode* buf_base_head = (Dlnode*) area.curs_node->section_bases;
		Dlnode* buf_base_node = buf_base_head->next;
		while(buf_base_node != NULL)
		{
			buf_base_head->next = buf_base_node->next;
			buf_base_node->next = NULL;
			puts("deleting base");
			buf_base = (Section_base *) buf_base_node->data;
			delete buf_base;
			delete buf_base_node;
			
			buf_base_node = buf_base_node->next;
		}
		buf_base = (Section_base *) buf_base_head->data;
		buf_base->chord_start = 1;
		buf_base->chord_end = 1;
		buf_base->length = 1;
		buf_base->name = NULL;
		
		int count = Dlist::dl_count((Dlnode*) area.curs_node->section_bases);
		printf("Count of section base after deletion is %d\n", count);
		
		puts("line 3360");
		// delete all sections, section buttons and eventboxes, leave the head
		count = Dlist::dl_count((Dlnode*) area.curs_node->sections);
		printf("Count of sections before deletion is %d\n", count);
		
		
		Dlnode * buf_sect_head = (Dlnode*) area.curs_node->sections;
		MyButton * buf_button;
		Gtk::EventBox * buf_evbox;
		Dlnode * buf_sect_node = buf_sect_head->next;
		while(buf_sect_node != NULL)
		{
			buf_sect_head->next = buf_sect_node->next;
			buf_sect_node->next = NULL;
			puts("deleting section");
			buf_button = (MyButton *)buf_sect_node->section_button;
			buf_evbox = (Gtk::EventBox*) buf_sect_node->eventbox;
			section_HBox.remove(*buf_evbox);
			delete buf_evbox;
			delete buf_button;
			
			buf_sect_node = buf_sect_node->next;
		}
		
		selected_section = (Dlnode*) area.curs_node->sections;
		buf_button = (MyButton *) buf_sect_head->section_button;
		buf_button->sect_start = 0;
		buf_button->sect_end = 430;
		buf_button->sect_chord_start = 1;
		buf_button->sect_chord_end = 1;
		buf_button->sect_chord_length = 1;
		buf_button->sect_pix_length = 430;
		buf_button->sect_name = NULL;
		buf_button->button_type = 4;
		buf_button->set_size_request(430, 30);
		
		count = Dlist::dl_count((Dlnode*) area.curs_node->sections);
		printf("Count of sections after deletion is %d\n", count);
		
		// change selected chord
		area.current_chord = (Dlnode *) Dlist::dl_nth_data(area.current_sequence, 0);
		selected_chord_number = 1;
		
		// mark corresponding chord buttons - 0 start notation
		int cur_seq_length = Dlist::dl_count(area.current_sequence);
		for (int i=0; i<64; i++)
		{
			if(i<cur_seq_length)
				chord_radio_buttons[i]->occupied = true;
			else
				chord_radio_buttons[i]->occupied = false;
			chord_radio_buttons[i]->pressed = false;
			chord_radio_buttons[i]->queue_draw (); 
		}
		chord_radio_buttons[0]->pressed = true;
		chord_radio_buttons[0]->queue_draw();
			
		section_HBox.show_all_children();
		section_HBox.show();	

} // end clear_new_sequence()

void ExampleWindow::load_sequence(Glib::ustring * str)
{	
	// remove previous eventboxes from HBox:
	Dlnode * buf_node = (Dlnode *) area.curs_node->sections;
	Gtk::EventBox * buf_evbox;
	
	while(buf_node != NULL)
	{
		buf_evbox = (Gtk::EventBox *) buf_node->eventbox;
		section_HBox.remove(*buf_evbox);
		buf_node = buf_node->next;
	}
	
// Find sequence based on string str:
	
	Glib::ustring * buf_str;
	
	Dlnode * l = g_sequences;
	while(l != NULL)
	{
		buf_str = (Glib::ustring *) l->name;
		if(buf_str != NULL && *buf_str == *str)
			break;	
		l = l->next; 
	}
	if(l == NULL)
		puts("Sequence was not found");
	
	// THIS IS WHERE SEQUENCE IS LOADED	
	// make selected sequence current
	area.curs_node = l;
	area.current_sequence = (Dlnode *) l->data;
	area.curs_node_copy = copy_sequence(l);
	
	
	// empty selected_notes and selected_note
	for(int i=1; i<Dlist::dl_count(selected_notes); i++)
	{
		Dlnode * buffer_node = Dlist::dl_nth_node(selected_notes, 1);
		Note * buffer_note = (Note *) buffer_node->data;
		buffer_note->selected = false;
		selected_notes = Dlist::dl_delete_node(selected_notes, buffer_node);
	}
	if(selected_note != NULL)
		selected_note->selected = false;
	set_velocity_b.set_sensitive(false);
	sc->set_sensitive(false);
	
	// change the title
	current_sequence_name = buf_str;
	Glib::ustring title = "Chord Sequencer : " + *current_sequence_name;
	set_title(title);
	is_sequence_named = true;
		// change selected_chord_number and selected_chord
	area.current_chord = (Dlnode *) Dlist::dl_nth_data(area.current_sequence, 0);
	selected_chord_number = 1;
	
	// mark corresponding chord buttons - 0 start notation
	int cur_seq_length = Dlist::dl_count(area.current_sequence);
	for (int i=0; i<64; i++)
	{
		if(i<cur_seq_length)
			chord_radio_buttons[i]->occupied = true;
		else
			chord_radio_buttons[i]->occupied = false;
		chord_radio_buttons[i]->pressed = false;
		chord_radio_buttons[i]->queue_draw (); 
	}
	chord_radio_buttons[0]->pressed = true;
	chord_radio_buttons[0]->queue_draw();
	
	// Dlnode * sections = (Dlnode *) area.curs_node->sections;


	// add all section_eventboxes to the section_HBox
	Dlnode * buf_n = (Dlnode *) area.curs_node->sections;
	MyButton * but;
	
	while(buf_n != NULL)
	{
		buf_evbox = (Gtk::EventBox *) buf_n->eventbox;
		section_HBox.add(*buf_evbox);
		but = (MyButton *) buf_n->section_button;
		// std::cout << "Btn length is" << but->sect_pix_length << std::endl;
		buf_n = buf_n->next;
	}
	
	selected_section = (Dlnode*) area.curs_node->sections;

	int count = Dlist::dl_count((Dlnode*) area.curs_node->sections);
	printf("Count of sections after loading is %d\n", count);
		
	scale_HBox.hide();
	update_section_buttons();
	section_HBox.show_all_children();
	section_HBox.show();

} // end load_sequence()

// This function is called when the user pushed new sequence button and
// decided not to save the current one. The current sequence does not 
// have a name yet. This function needs to be rewritten. It does not delete
// the current sequence, just deletes everything inside it, to make it new.
void ExampleWindow::close_and_new(Gtk::Window* win)
{
	clear_new_sequence();
	
	area.queue_draw();
	win->hide();
	s_win.hide();
	
} // end close_and_new()

void ExampleWindow::cancel_delete_sequence(Gtk::Window* w)
{
	puts(_("canceling...") );
	w->hide();
}

// This function is called after the user confirms deleting sequence in the 
// sequence window
void ExampleWindow::delete_sequence_yes(Gtk::Window* wind, Glib::ustring stri)
{
	std::cout << "Inside delete sequence name is " << stri << std::endl;
	// find the number of the sequence to delete
	Glib::ustring * buf_str;
	int sequence_number, sequence_name_number;
	
	int length_names, length_seqs;
	//length_names = Dlist::dl_count(sequence_names);
	length_seqs = Dlist::dl_count(g_sequences);
		
	Sequence * seq_node = g_sequences;
	Sequence * node_to_delete;
	Glib::ustring * buf_string;
	while(seq_node != NULL)
	{
		if(seq_node->name != NULL)
		{
			buf_string = (Glib::ustring *) seq_node->name;
			if(*buf_string == stri)
			{
				node_to_delete = seq_node;
				break;
			}
		}
		seq_node = seq_node->next;
	}
	
	Dlnode * seq_data_to_delete = (Dlnode*) node_to_delete->data;
	
	// delete all notes and chords from the sequence to delete
	Dlnode * note_head, * note_node;
	Note * note;
	// This will delete all nodes except for head node 
	Dlnode * l = seq_data_to_delete->next;
	while(l != NULL)
	{
		seq_data_to_delete->next = l -> next;
		note_head = (Dlnode *) (l->data);
		
		// This will delete all nodes except for head node 
		note_node = note_head -> next;
		while(note_node != NULL)
		{
			note_head->next = note_node->next;
			// remove the data
			note = (Note *) note_node->data;
			delete(note);
			note_node->next = NULL;
			delete(note_node);
			note_node = note_head->next;
		}
		// Delete head node data and the head node
		note = (Note *) note_head->data;
		delete note;
		delete((Dlnode *) l->data); // note_head
		
		
		l -> next = NULL;
		delete (l);
		l = seq_data_to_delete->next;
	}
	

	// delete all notes except for dummy note in the first chord 
	// (the only one)
	// This will delete all nodes except for head node 
	note_head = (Dlnode*) seq_data_to_delete->data;
	note_node = note_head->next;
	Note * n;
	while(note_node != NULL)
	{
		note_head->next = note_node->next;
		note_node->next = NULL;
		// remove the data
		n = (Note *) note_node->data;
		delete(n);
		delete note_node;
		note_node = note_head->next;
	}
	
	delete note_head;
	delete seq_data_to_delete;
	
	
	// delete all sequence bases
	// delete all section_bases, except for the head node
	// This will delete all nodes except for head node
	Section_base * buf_base;
	Dlnode* buf_base_head = (Dlnode*) node_to_delete->section_bases;
	Dlnode* buf_base_node = buf_base_head->next;
	Glib::ustring * buf_name;
	while(buf_base_node != NULL)
	{
		buf_base_head->next = buf_base_node->next;
		buf_base_node->next = NULL;
		puts("deleting base");
		buf_base = (Section_base *) buf_base_node->data;
		if(buf_base->name != NULL)
		{
			buf_name = (Glib::ustring *) buf_base->name;
			delete buf_name;
		}
		delete buf_base;
		delete buf_base_node;
		
		buf_base_node = buf_base_node->next;
	}
	delete buf_base_head;
	
	
	//int count = Dlist::dl_count((Dlnode*) node_to_delete->sections);
	//printf("Count of sections before deletion is %d\n", count);
	
	// delete all sequences, sequence buttons and eventboxes
	// delete all sections, section buttons and eventboxes, leave the head
	Dlnode * buf_sect_head = (Dlnode*) node_to_delete->sections;
	MyButton * buf_button;
	Gtk::EventBox * buf_evbox;
	// This will delete all nodes except for head node
	Dlnode * buf_sect_node = buf_sect_head->next;
	while(buf_sect_node != NULL)
	{
		buf_sect_head->next = buf_sect_node->next;
		buf_sect_node->next = NULL;
		puts("deleting section");
		buf_button = (MyButton *)buf_sect_node->section_button;
		if(buf_button->sect_name != NULL)
		{
			buf_name = (Glib::ustring*) buf_button->sect_name;
			delete buf_name;
		}
		buf_evbox = (Gtk::EventBox*) buf_sect_node->eventbox;
		// For some reason this throws an error:
		//if(buf_evbox != NULL)
		//	section_HBox.remove(*buf_evbox);
		delete buf_evbox;
		delete buf_button;
		
		buf_sect_node = buf_sect_head->next;
	}
	
	// count = Dlist::dl_count((Dlnode*) node_to_delete->sections);
	// printf("Count of sections after deletion is %d\n", count);
	
	buf_button = (MyButton *)buf_sect_head->section_button;
	delete buf_button;
	buf_evbox = (Gtk::EventBox *) buf_sect_head->eventbox;
	delete buf_evbox;
	delete buf_sect_head;
	
	buf_name = (Glib::ustring*) node_to_delete->name;
	delete buf_name;
		
			
	// delete sequence
	g_sequences = (Sequence *) Dlist::dl_delete_node (g_sequences, node_to_delete);
	
	
	save_all();
	// close dialog window
	wind->hide();
	s_win.hide();

} // end delete_sequence_yes

// This function is called only once, in the program initialization.
// This function reads the file, and appends to the sequence list as many sequences
// as it finds there, current sequence remains at the index 0 unchanged
void ExampleWindow::read_saved_file()
{
	Sequence * last_sequence_link;
	Dlnode * last_base_link, * last_section_link;
	Dlnode * sequence_head;
	Section_base * last_base;
	MyButton * last_button;
	int mode = 0; // 0 for sequence/chord/note and 1 for section, 2 for section base
	std::string delimiter;
	int number, pos, chord_number, count;
	//std::ifstream file("saved_sequences.txt");
	std::ifstream file("saved_sequences.txt");
	if(!file)
	{
		std::cout << Glib::ustring::compose(
             _("Cannot open file %1."), 
			"saved_sequences.txt") << std::endl;
		return;
	}
    std::string line, token, token_buffer, name_buffer; 
    Glib::ustring * name, *name_copy;
    count = 0;
    while (std::getline(file, line))
    {
		count++;
	//	std::cout << "Processing line " << count << std::endl;
		delimiter = "<";
		if ( (pos = line.find(delimiter) ) != std::string::npos)// delimiter found
		{
			token_buffer = line.substr(0, pos);
			//std::cout << "main token " << token_buffer << std::endl;
			line.erase(0, pos + delimiter.length() );
			delimiter = ">";
			pos = line.find(delimiter);
			name_buffer = line.substr(0, pos); // this is what is inside < >
			// don't trim the name!
			token = trim(token_buffer);
	//		std::cout << "Trimmed token:" << token << "end" << std::endl;
			if(token.compare("Sequence") == 0 )
			// this is a sequence line
			{
				// puts("found sequence line");
				mode = 0;
				// create a new sequence
				Dlnode * new_seq = Dlist::dl_create();
				g_sequences = (Sequence *) Dlist::dl_append(g_sequences, new_seq );
				
				Sequence * new_seque_node = Dlist::dl_find(g_sequences, new_seq);

				// create a name for the sequence
	//			std::cout << "Name is " << name_buffer << std::endl;
				// in case of sequence, < > is sequence name
				name = new Glib::ustring(name_buffer);
				//sequence_names = Dlist::dl_append(sequence_names, name);
				//const Glib::ustring string_val = *name;
				//name_copy = new Glib::ustring(string_val);
				new_seque_node->name = name;
			}
			else if(token.compare("Chord") == 0 )
			// this is a chord line, every sequence must have at least 1 chord
			{
	//			puts("found chord line");
				mode = 0;
				// in case of chord, < > is chord number in this sequence
				number = std::stoi(name_buffer);
	//			std::cout << "Name is " << name_buffer << std::endl;
				// create a new chord
				Dlnode * new_chord_link = Dlist::dl_create();
				
				last_sequence_link = (Sequence *) Dlist::dl_last(g_sequences);
				
		//		std::cout << "Number is " << number << std::endl;
				if(number == 1) // first chord
					last_sequence_link->data = new_chord_link;
				else
				{
					sequence_head = (Dlnode *) last_sequence_link->data;
					sequence_head = Dlist::dl_append(sequence_head, new_chord_link);
				}	// add dummy note to the new chord
				Note * dummy_note = new Note(-1000);
				Dlnode * note_link = Dlist::dl_create();
				new_chord_link->data = note_link;
				note_link->data = dummy_note;
				Dlnode * last_sequence_link_data = (Dlnode*) last_sequence_link->data;
				int l = Dlist::dl_count( last_sequence_link_data);
	//			std::cout << "Length of last sequence is " << l << std::endl;
			}
			else if(token.compare("Note") == 0 )
			// this is a note line
			{
	//			puts("found note line");
				mode = 0;
				// in case of a note, < > is note midi number
				number = std::stoi(name_buffer); 
	//			std::cout << "Name is " << name_buffer << std::endl;
				// create a new note
				Note * new_note = new Note(number);
				
				last_sequence_link = (Sequence *) Dlist::dl_last(g_sequences);
				sequence_head =  (Dlnode *)last_sequence_link->data;
				
				
				Dlnode * last_chord_link = Dlist::dl_last( sequence_head );
				Dlnode * last_chord_head = (Dlnode *) last_chord_link->data;
				last_chord_head = Dlist::dl_append(last_chord_head, new_note);
				chord_number = Dlist::dl_count(sequence_head);
				new_note->normal_x = (chord_number - 1) * 53 ;
				new_note->update_x();
			}
			else if(token.compare("Base") == 0 )
			{
				// This is a section base line
				// puts("found section base line");
				mode = 2; 
				// In case of a section base, < >  is a base name
				last_sequence_link = (Sequence *) Dlist::dl_last(g_sequences);
				Dlnode * base_head, * base_node;
				Section_base * new_base = new Section_base();
				if(last_sequence_link->section_bases == NULL)
				{
					base_head = Dlist::dl_create();
					last_sequence_link->section_bases = base_head;
					base_head->data = new_base;
					last_base_link =  base_head;
				}
				else
				{
					base_node = Dlist::dl_create();
					last_base_link->next = base_node;
					base_node->prev = last_base_link;
					base_node->data = new_base;
					last_base_link = base_node;
				}
				Glib::ustring * base_name = new Glib::ustring(name_buffer);
				if(base_name->length() > 0)
					new_base->name = base_name;
				else
					new_base->name = NULL;
			}
			else if(token.compare("Section") == 0 )
			{
				// This is a section button line
				// puts("found section button line");
				mode = 1;
				// in case of a section button < > is a section name
				last_sequence_link = (Sequence *) Dlist::dl_last(g_sequences);
				Dlnode * section_head, *section_node;
				MyButton * new_button = new MyButton();
				new_button->button_type = 4;
				Gtk::EventBox * new_evbox = new Gtk::EventBox();
				if(last_sequence_link->sections == NULL)
				{
					section_head = Dlist::dl_create();
					last_sequence_link->sections = section_head;
					section_head->section_button = new_button;
					section_head->eventbox = new_evbox;
					last_section_link = section_head;
				}
				else
				{
					section_node = Dlist::dl_create();
					last_section_link->next = section_node;
					section_node->prev = last_section_link;
					section_node->section_button = new_button;
					section_node->eventbox = new_evbox;
					last_section_link = section_node;
				}
				new_evbox->add(*new_button);
				new_evbox->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK | Gdk::LEAVE_NOTIFY_MASK );
				new_evbox->signal_button_press_event().connect(sigc::bind<MyButton *>(
					sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_clicked), new_button) );
				new_evbox->signal_enter_notify_event().connect(sigc::bind<MyButton *>(
					sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_enter), new_button) );
				new_evbox->signal_leave_notify_event().connect(sigc::bind<MyButton *>(
					sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_leave), new_button) );

				Glib::ustring * section_name = new Glib::ustring(name_buffer);
				if(section_name->length() > 0)
					new_button->sect_name = section_name;
				else
					new_button->sect_name = NULL;
			}
			else
			// must be some error
			{
				std::cout << _("Unknown token") << std::endl;
			}
		}
        else // must be note attribute line - delimiter not found
		{	//  or section base attribute line, or section attribute line
        
			// Process line
			delimiter = "=";
			if ( (pos = line.find(delimiter) ) != std::string::npos)// delimiter found
			{
	//			puts("Delimiter = found");
				token_buffer = line.substr(0, pos);
				token = trim(token_buffer); // this is a name of note attribute
				line.erase(0, pos + delimiter.length() );
				
				// the rest of the line must be just a number after trimming
				name_buffer = trim(line);
				number = std::stoi(name_buffer); // this is a value of the attribute
				//puts("line 3783");
				last_sequence_link = (Sequence *) Dlist::dl_last(g_sequences);
				sequence_head = (Dlnode *)last_sequence_link->data;
				Dlnode * last_chord_link = Dlist::dl_last(sequence_head);
				Dlnode * chord_head = (Dlnode *) last_chord_link->data;
	
				Dlnode * last_note_link = (Dlnode *) Dlist::dl_last(chord_head);
				if(mode == 1) // section mode
					last_button = (MyButton *) last_section_link->section_button;
				else if(mode == 2)
					last_base = (Section_base *) last_base_link->data; 
				//puts("line 3793");						
				Note * last_note = (Note *) last_note_link->data;
				// Note attributes:
				if(token.compare("velocity") == 0 )
					last_note->velocity = number;
				else if(token.compare("midi_instrument") == 0 )
					last_note->midi_instrument = number;
				else if(token.compare("display_options") == 0 )
					last_note->display_options = number;
				else if(token.compare("display") == 0 )
				{
					last_note->display = number;
					last_note->update_display();
				} 
				else if(token.compare("midi_channel") == 0 )
					last_note->midi_channel = number;
				// Section base attributes:
				else if(token.compare("Chord start") == 0 )
					last_base->chord_start = number;
				else if(token.compare("Chord end") == 0 )
					last_base->chord_end = number;
				else if(token.compare("Length") == 0 )
					last_base->length = number;
				// Section button attributes;
				else if(token.compare("sect_start") == 0 )
					last_button->sect_start = number;
				else if(token.compare("sect_end") == 0 )
					last_button->sect_end = number;
				else if(token.compare("sect_chord_start") == 0 )
					last_button->sect_chord_start = number;
				else if(token.compare("sect_chord_end") == 0 )
					last_button->sect_chord_end = number;
				else if(token.compare("sect_chord_length") == 0 )
					last_button->sect_chord_length = number;
				else if(token.compare("sect_pix_length") == 0 )
				{
					last_button->sect_pix_length = number;
					last_button->set_size_request(number, 30);
				}
				else
					std::cout << _("Found unknown note attribute: ") << 
									token << std::endl;
			}
			else
			{
				// delimiter not found, must be an empty line
				std::cout << _("found line without any delimiter") << std::endl;
			}
		}
    }
	file.close();
} // end read_saved_file()

// trims white space on both ends and tab in front
std::string ExampleWindow::trim(const std::string& str)
{
    size_t first = str.find_first_not_of(' ');
    if (std::string::npos == first) // white space not found
    {
		size_t pos = str.find_first_not_of('\t');
		if(pos != std::string::npos) // tab found
			return str.substr(pos);
		else // tab not found
			return str;
    }
    size_t last = str.find_last_not_of(' ');
    std::string sub_string = str.substr(first, (last - first + 1));
    
    size_t pos = sub_string.find_first_not_of('\t');
    if(pos != std::string::npos)
		return sub_string.substr(pos);
	else
		return sub_string;
}



// These four functions below go with play chord mode (not radio buttons)
void ExampleWindow::on_play_chord()
{
	Note * n;
	int note_number;
	int note_velocity;
	
	// All notes off
	message[0] = 176 + channel - 1;
	message[1] = 123;
	message[2] = 0;
	midiout->sendMessage( &message );
	
	for( int i = 1; i < Dlist::dl_count(area.current_chord); i++)
	{
		n = (Note *) Dlist::dl_nth_data(area.current_chord, i);
		note_number = n->midi_number;
		note_velocity = n->velocity;
		message[0] = 144  + channel - 1;
		message[1] = note_number;
		message[2] = note_velocity;
		midiout->sendMessage( &message );
	}
	playing = true;
	area.queue_draw();
}

void ExampleWindow::on_stop_chord()
{
	// All notes off
	message[0] = 176 + channel - 1;
	message[1] = 123;
	message[2] = 0;
	midiout->sendMessage( &message );
	playing = false;
	area.queue_draw();

}

void ExampleWindow::on_next_chord()
{
	Note * n;
	int note_number;
	int note_velocity;
	int previous_selected_chord_num;
	//Dlnode * cur_section = selected_section;
	Dlnode * buf_section;
	MyButton * buffer_button, * previous_button, * butt;
	int sequence_length = Dlist::dl_count(area.current_sequence);
	
	// All notes off
	message[0] = 176 + channel - 1;
	message[1] = 123;
	message[2] = 0;
	midiout->sendMessage( &message );
	//puts("line 4369");
	if(selected_section ==  NULL)
	{
	//	puts("Selected section is NULL");
	// find first section that has this chord in it and select it
		Dlnode * buff = (Dlnode*) area.curs_node->sections;
		while(buff != NULL)
		{
			butt = (MyButton*) buff->section_button;
			if(butt->sect_chord_start <= selected_chord_number && 
				butt->sect_chord_end >= selected_chord_number)
			{
				selected_section = buff;
				butt->pressed = true;
				butt->queue_draw();
				break;
			}
			buff = buff->next;
		}
	}
	else // selected_section is not NULL
	{
		// check if the selected section is correct for this chord number
		butt = (MyButton*) selected_section->section_button;
		if(butt->sect_chord_start <= selected_chord_number && 
				butt->sect_chord_end >= selected_chord_number)
			; // do nothing
		else
		{
			butt->pressed = false;
			butt->queue_draw();		
			// find first section that has this chord in it and select it
			Dlnode * buff = (Dlnode*) area.curs_node->sections;
			while(buff != NULL)
			{
				butt = (MyButton*) buff->section_button;
				if(butt->sect_chord_start <= selected_chord_number && 
					butt->sect_chord_end >= selected_chord_number)
				{
					selected_section = buff;
					butt->pressed = true;
					butt->queue_draw();
					break;
				}
				buff = buff->next;
			}
		}
	}


	//puts("line 4380");
	buffer_button = (MyButton*) selected_section->section_button;
	previous_button = buffer_button;
	

	//printf("selected chord # before switching was %d\n", selected_chord_number);
	if(selected_chord_number == buffer_button->sect_chord_end) // last chord of section
	{
		previous_selected_chord_num = selected_chord_number;
		buffer_button->pressed = false;
		
		//puts("line 4390");		
		// make next section selected
		if(selected_section->next != NULL)
			selected_section = selected_section->next;
		else // last chord of the last section - loop to the beginning
			selected_section = (Dlnode*) area.curs_node->sections;
		buffer_button = (MyButton*) selected_section->section_button;
		//printf("Next section start is %d\n", buffer_button->sect_chord_start);
		
		// jump to the first chord of that section
		selected_chord_number = buffer_button->sect_chord_start;
		area.current_chord = (Dlnode *) Dlist::dl_nth_data(area.current_sequence,
											selected_chord_number - 1);
		// play it
		for( int i = 1; i < Dlist::dl_count(area.current_chord); i++)
		{
			n = (Note *) Dlist::dl_nth_data(area.current_chord, i);
			note_number = n->midi_number;
			note_velocity = n->velocity;
			message[0] = 144 + channel - 1;
			message[1] = note_number;
			message[2] = note_velocity;
			midiout->sendMessage( &message );
		}
		//puts("line 4414");
		playing = true;
		buffer_button->pressed = true;
		buffer_button->queue_draw();
		chord_radio_buttons[previous_selected_chord_num-1]->pressed = false;
		chord_radio_buttons[selected_chord_number-1]->pressed = true;
		chord_radio_buttons[previous_selected_chord_num-1]->queue_draw();
		chord_radio_buttons[selected_chord_number-1]->queue_draw();
		
		previous_button->pressed = false;
		previous_button->queue_draw();
		
	}
	else // not the end of the section
	{
		//puts("line 4429");		
// change selected chord
		if(selected_chord_number < sequence_length) // always true
		{
			area.current_chord = (Dlnode *) Dlist::dl_nth_data(area.current_sequence,
													selected_chord_number);
			// play it
			for( int i = 1; i < Dlist::dl_count(area.current_chord); i++)
			{
				n = (Note *) Dlist::dl_nth_data(area.current_chord, i);
				note_number = n->midi_number;
				note_velocity = n->velocity;
				message[0] = 144 + channel - 1;
				message[1] = note_number;
				message[2] = note_velocity;
				midiout->sendMessage( &message );
			}
			playing = true;										
			//puts("line 4446");												
			selected_chord_number++;
			chord_radio_buttons[selected_chord_number-2]->pressed = false;
			chord_radio_buttons[selected_chord_number-1]->pressed = true;
			chord_radio_buttons[selected_chord_number-2]->queue_draw();
			chord_radio_buttons[selected_chord_number-1]->queue_draw();
		}
		// else not needed, because the end of sequence would be the end
		// of section too, which case is taken care of before already

	}

	//puts("line 4458");	
	// adjust scroller 
	if(sequence_length > 16)
	{
		double v;
		//printf("selected chord is %d\n", selected_chord_number);
		//double upper = scroll_adj->get_upper();
		if( selected_chord_number <= sequence_length)
			v = 53 * (selected_chord_number - 10);
		else
			v = 0;
		scroll_adj->set_value(v);
	}
	//puts("line 4471");
	area.queue_draw();
} // end on_next_chord()

void ExampleWindow::on_previous_chord()
{
	Note * n;
	int note_number;
	int note_velocity;
	int previous_selected_chord_num;
	MyButton * buffer_button, *previous_button, * butt;
	int sequence_length = Dlist::dl_count(area.current_sequence);
	
	// All notes off
	message[0] = 176 + channel - 1;
	message[1] = 123;
	message[2] = 0;
	midiout->sendMessage( &message );
	
	if(selected_section ==  NULL)
	{
	//	puts("Selected section is NULL");
	// find first section that has this chord in it and select it
		Dlnode * buff = (Dlnode*) area.curs_node->sections;
		while(buff != NULL)
		{
			butt = (MyButton*) buff->section_button;
			if(butt->sect_chord_start <= selected_chord_number && 
				butt->sect_chord_end >= selected_chord_number)
			{
				selected_section = buff;
				butt->pressed = true;
				butt->queue_draw();
				break;
			}
			buff = buff->next;
		}
	}
	else // selected_section is not NULL
	{
		// check if the selected section is correct for this chord number
		butt = (MyButton*) selected_section->section_button;
		if(butt->sect_chord_start <= selected_chord_number && 
				butt->sect_chord_end >= selected_chord_number)
			; // do nothing
		else
		{
			butt->pressed = false;
			butt->queue_draw();		
			// find first section that has this chord in it and select it
			Dlnode * buff = (Dlnode*) area.curs_node->sections;
			while(buff != NULL)
			{
				butt = (MyButton*) buff->section_button;
				if(butt->sect_chord_start <= selected_chord_number && 
					butt->sect_chord_end >= selected_chord_number)
				{
					selected_section = buff;
					butt->pressed = true;
					butt->queue_draw();
					break;
				}
				buff = buff->next;
			}
		}
	}

	buffer_button = (MyButton*) selected_section->section_button;
	previous_button = buffer_button;
	
	
	//printf("selected chord # before switching was %d\n", selected_chord_number);
	if(selected_chord_number == buffer_button->sect_chord_start) // first chord of section
	{
		previous_selected_chord_num = selected_chord_number;
		buffer_button->pressed = false;
		
			
			// make previous section selected
		if(selected_section->prev != NULL)
			selected_section = selected_section->prev;
		else // first chord of the first section - loop to the end
		{
			selected_section = (Dlnode*) Dlist::dl_last( (Dlnode *)
								area.curs_node->sections);
		}	
		
		buffer_button = (MyButton*) selected_section->section_button;
		//printf("Previous section end is %d\n", buffer_button->sect_chord_end);
		
		// jump to the last chord of that section
		selected_chord_number = buffer_button->sect_chord_end;
		area.current_chord = (Dlnode *) Dlist::dl_nth_data(area.current_sequence,
												selected_chord_number - 1);	
		
		// play it
		for( int i = 1; i < Dlist::dl_count(area.current_chord); i++)
		{
			n = (Note *) Dlist::dl_nth_data(area.current_chord, i);
			note_number = n->midi_number;
			note_velocity = n->velocity;
			message[0] = 144 + channel - 1;
			message[1] = note_number;
			message[2] = note_velocity;
			midiout->sendMessage( &message );
		}
		playing = true;	
	
		buffer_button->pressed = true;
		buffer_button->queue_draw();
		chord_radio_buttons[previous_selected_chord_num-1]->pressed = false;
		chord_radio_buttons[selected_chord_number-1]->pressed = true;
		chord_radio_buttons[previous_selected_chord_num-1]->queue_draw();
		chord_radio_buttons[selected_chord_number-1]->queue_draw();
		
		previous_button->pressed = false;
		previous_button->queue_draw();
	}
	else // not the end of the section
	{
		int sequence_length = Dlist::dl_count(area.current_sequence);
		if(selected_chord_number > 1) // always true
		{
			area.current_chord = (Dlnode *) Dlist::dl_nth_data( 
						area.current_sequence, selected_chord_number - 2);
						
				// play it
			for( int i = 1; i < Dlist::dl_count(area.current_chord); i++)
			{
				n = (Note *) Dlist::dl_nth_data(area.current_chord, i);
				note_number = n->midi_number;
				note_velocity = n->velocity;
				message[0] = 144 + channel - 1;
				message[1] = note_number;
				message[2] = note_velocity;
				midiout->sendMessage( &message );
			}
			playing = true;
						
			selected_chord_number--;
			chord_radio_buttons[selected_chord_number]->pressed = false;
			chord_radio_buttons[selected_chord_number-1]->pressed = true;
			chord_radio_buttons[selected_chord_number]->queue_draw();
			chord_radio_buttons[selected_chord_number-1]->queue_draw();
		}
		// else not needed because the beginning of the sequence is a 
		// beginning of the section too, which case was taken care already
	}
	
	// adjust scroller 
	if(sequence_length > 16)
	{
		double v;
		
		if( selected_chord_number <= sequence_length)
			v = 53 * (selected_chord_number - 10);
		else
			v = 0;
		scroll_adj->set_value(v);
	}

	area.queue_draw();
} // end on_previous_chord()

bool ExampleWindow::onKeyRelease(GdkEventKey* event)
{
	guint keyvalue =  event->keyval;
	if(ks_window.total_keys_pressed > 0)
		ks_window.total_keys_pressed--;
		
	// is key in a shortcut list?
	for(int i = 0; i < ks_window.number_of_shortcuts; i++)
	{
		if(keyvalue == ks_window.shortcut_keys[i][0] || 
				keyvalue == ks_window.shortcut_keys[i][1] ) 
		{	// key is in the shortcut list
			ks_window.shortcut_keys_pressed--;
			return true;
		}
	}
	return true;
} // en donKeyRelease()


// Binding of the pedal to the next chord button, previous chord button
// and  to stop button
bool ExampleWindow::onKeyPress(GdkEventKey* event)
{
	guint keyvalue =  event->keyval;
	/*
	gchar * label = gtk_accelerator_get_label (keyvalue, (GdkModifierType ) 0 );
	gchar * name =  gdk_keyval_name (keyvalue);
	printf("Accelerator label: %s\n", label);
	printf("Accelerator name: %s\n", name);
	*/
	
	//printf("Caught key press event keyval %u\n", keyvalue);
	ks_window.total_keys_pressed++;
	// find if the key is one of the shortcut keys
	
	for(int i = 0; i < ks_window.number_of_shortcuts; i++)
	{
		if(keyvalue == ks_window.shortcut_keys[i][0] || 
				keyvalue == ks_window.shortcut_keys[i][1] ) 
		{	// key is in the shortcut list
			ks_window.shortcut_keys_pressed++;
			// check if this command has two key shortcut or one key
			if(ks_window.shortcut_keys[i][1] == 0) // one key command
			{
					activate_command(i);
					return true;
			}
			else // key found in the two key command
			{
				if(ks_window.shortcut_keys_pressed > 1)
				// at least one shortcut key is already pressed
				{
					if(ks_window.first_key_guint != 0)
					{
						int result = ks_window.two_key_search(ks_window.first_key_guint, 
										keyvalue, ks_window.shortcut_keys);
						if(result >= 0)
							activate_command(result);
						else
							std::cout << "Error: two_key_search returned negative value"
										<< std::endl;
						return true;
					}
					else
					{
						std::cout << "Error: first_key_guint is 0" << std::endl;
						return true;
					}
				}
				else // this is first shortcut key pressed
				{
					ks_window.first_key_guint = keyvalue;
					return true;
				}
			}
		}
		else // key is not in the shortcut list
			continue;
	} // end for
	return true;
} // end onKeyPress()



ExampleWindow::KeyShortcutsWindow::KeyShortcutsWindow()
: ks_grid(),
doc_label(),
sep(),
sep1(),
command_label(_("Command:") ),
shortcut_label(_("Shortcut:") ),
play_label(_("Play Chord") ),
previous_label(_("Previous Chord") ),
stop_label(_("Stop All Sounds") ),
new_label(_("New Chord") ),
copy_label(_("Copy Chord") ),
paste_label(_("Paste Chord") ),
play_entry(),
previous_entry(),
new_entry(),
stop_entry(),
copy_entry(),
paste_entry(),
learn_play_button(_("Learn") ),
learn_previous_button(_("Learn") ),
learn_new_button(_("Learn") ),
learn_stop_button(_("Learn") ),
learn_copy_button(_("Learn") ),
learn_paste_button(_("Learn") ),
button_close(_("Close") )
{
	number_of_shortcuts = 6;
	learn_mode = false;
	shortcuts_changed = false;
	learn_index = -1;
	learn_keys_pressed = 0;
	first_learn_key_pressed = 0;
	int entry_width = 150;
	int entry_width_char = 20;
	
	set_title(_("Manage Keyboard Shortcuts") );
	set_border_width(10);
	set_default_size(300,70);
	ks_grid.set_row_spacing(5);
	ks_grid.set_column_homogeneous(false);
	add((Gtk::Widget&)ks_grid);
	doc_label_string = _("To change a shortcut, click on the corresponding \
learn button, release it, then press and release \
the new key, or combination of two new keys. \
In case of two keys, it could be any two keys.");
	doc_label.set_text(doc_label_string);
	
	total_keys_pressed = 0;
	shortcut_keys_pressed = 0;
	first_key_guint = 0;
	ks_grid.attach(doc_label, 0, 0, 3, 1);
	ks_grid.attach(command_label, 0, 1, 1, 1);
	ks_grid.attach(shortcut_label, 1, 1, 1, 1);
	ks_grid.attach(sep, 0, 2, 3, 1);
	ks_grid.attach(play_label, 0, 3, 1, 1);
	
	play_entry.set_width_chars(entry_width_char);
	play_entry.set_hexpand_set(true);
	play_entry.set_size_request(entry_width, 10);
	play_entry.set_margin_left(25);
	play_entry.set_margin_right(25);
	play_entry.set_hexpand(true);
	ks_grid.attach(play_entry, 1, 3, 1, 1);
	ks_grid.attach(learn_play_button, 2, 3, 1, 1);
	
	ks_grid.attach(previous_label, 0, 4, 1, 1);
	previous_entry.set_width_chars(entry_width_char);
	previous_entry.set_hexpand_set(true);
	previous_entry.set_size_request(entry_width, 10);
	previous_entry.set_margin_left(25);
	previous_entry.set_margin_right(25);
	previous_entry.set_hexpand(true);
	ks_grid.attach(previous_entry, 1, 4, 1, 1);
	ks_grid.attach(learn_previous_button, 2, 4, 1, 1);
	
	
	ks_grid.attach(stop_label, 0, 5, 1, 1);
	stop_entry.set_width_chars(entry_width_char);
	stop_entry.set_hexpand_set(true);
	stop_entry.set_size_request(entry_width, 10);
	stop_entry.set_margin_left(25);
	stop_entry.set_margin_right(25);
	stop_entry.set_hexpand(true);
	ks_grid.attach(stop_entry, 1, 5, 1, 1);
	ks_grid.attach(learn_stop_button, 2, 5, 1, 1);
	
	ks_grid.attach(new_label, 0, 6, 1, 1);
	new_entry.set_width_chars(entry_width_char);
	new_entry.set_hexpand_set(true);
	new_entry.set_size_request(entry_width, 10);
	new_entry.set_margin_left(25);
	new_entry.set_margin_right(25);
	new_entry.set_hexpand(true);
	ks_grid.attach(new_entry, 1, 6, 1, 1);
	ks_grid.attach(learn_new_button, 2, 6, 1, 1);
	
	ks_grid.attach(copy_label, 0, 7, 1, 1);
	copy_entry.set_width_chars(entry_width_char);
	copy_entry.set_hexpand_set(true);
	copy_entry.set_size_request(entry_width, 10);
	copy_entry.set_margin_left(25);
	copy_entry.set_margin_right(25);
	copy_entry.set_hexpand(true);
	ks_grid.attach(copy_entry, 1, 7, 1, 1);
	ks_grid.attach(learn_copy_button, 2, 7, 1, 1);
	
	ks_grid.attach(paste_label, 0, 8, 1, 1);
	paste_entry.set_width_chars(entry_width_char);
	paste_entry.set_hexpand_set(true);
	paste_entry.set_size_request(entry_width, 10);
	paste_entry.set_margin_left(25);
	paste_entry.set_margin_right(25);
	paste_entry.set_hexpand(true);
	ks_grid.attach(paste_entry, 1, 8, 1, 1);
	ks_grid.attach(learn_paste_button, 2, 8, 1, 1);
	
	ks_grid.attach(sep1, 0, 9, 3, 1);
	
	ks_grid.attach(button_close, 0, 10, 3, 1);
	ks_grid.set_halign(Gtk::ALIGN_START);
	ks_grid.show_all();
	
	entries[0] = &play_entry;
	entries[1] = &previous_entry;
	entries[2] = &stop_entry;
	entries[3] = &new_entry;
	entries[4] = &copy_entry;
	entries[5] = &paste_entry;
	
	
	// Events section
	this->signal_key_press_event().connect(
		sigc::mem_fun(*this, &KeyShortcutsWindow::onSKeyPress), false);
	this->signal_key_release_event().connect(
		sigc::mem_fun(*this, &KeyShortcutsWindow::onSKeyRelease), false);
	
	
	learn_play_button.signal_clicked().connect(sigc::bind<int>(
				sigc::mem_fun(*this, &KeyShortcutsWindow::on_learn_button_clicked), 0) );
	learn_previous_button.signal_clicked().connect(sigc::bind<int>(
				sigc::mem_fun(*this, &KeyShortcutsWindow::on_learn_button_clicked), 1) );
	learn_stop_button.signal_clicked().connect(sigc::bind<int>(
				sigc::mem_fun(*this, &KeyShortcutsWindow::on_learn_button_clicked), 2) );
	learn_new_button.signal_clicked().connect(sigc::bind<int>(
				sigc::mem_fun(*this, &KeyShortcutsWindow::on_learn_button_clicked), 3) );
	learn_copy_button.signal_clicked().connect(sigc::bind<int>(
				sigc::mem_fun(*this, &KeyShortcutsWindow::on_learn_button_clicked), 4) );
	learn_paste_button.signal_clicked().connect(sigc::bind<int>(
				sigc::mem_fun(*this, &KeyShortcutsWindow::on_learn_button_clicked), 5) );
	
	
	button_close.signal_clicked().connect( sigc::mem_fun(*this, 
							&KeyShortcutsWindow::on_close_button_clicked) );
										
	//	m_button1.signal_clicked().connect( sigc::bind<Glib::ustring>( sigc::mem_fun(*this, 
	//				&HelloWorld::on_button_clicked), "button 1") );				
} // end KeyShortcutsWindow constructor

ExampleWindow::KeyShortcutsWindow::~KeyShortcutsWindow()
{ }

// This function searches 2D array for index that has both keys,
// and returns that index, if it is found, or -1 if it is not found.
int ExampleWindow::KeyShortcutsWindow::two_key_search(guint first_key,
						guint second_key, guint  two_d_array[6][2])
{
	//puts("inside two_key_search\n");
	int result = -1;
	for(int i=0; i<number_of_shortcuts; i++)
	{
		if(two_d_array[i][1] == 0)
		{
			// single key shortcut row, proceed to the next row
			continue;
		}
		else // two key shortcut row
		{
			if(two_d_array[i][0] == first_key)
			{
				if(two_d_array[i][1] == second_key)
				{
					result = i;
					break;
				}
				else
				{
					// continue search
					continue;
				}
			}
			else
			{
				if(two_d_array[i][0] == second_key)
				{
					if(two_d_array[i][1] == first_key)
					{
						result = i;
						break;
					}
					else
						continue;
				}
				else 
					continue;
			}
		}
	}
	return result;
} // end two_key_search

// trims white space on both ends and tab in front
std::string ExampleWindow::KeyShortcutsWindow::trim(const std::string& str)
{
    size_t first = str.find_first_not_of(' ');
    if (std::string::npos == first) // white space not found
    {
		size_t pos = str.find_first_not_of('\t');
		if(pos != std::string::npos) // tab found
			return str.substr(pos);
		else // tab not found
			return str;
    }
    size_t last = str.find_last_not_of(' ');
    std::string sub_string = str.substr(first, (last - first + 1));
    
    size_t pos = sub_string.find_first_not_of('\t');
    if(pos != std::string::npos)
		return sub_string.substr(pos);
	else
		return sub_string;
}

void ExampleWindow::on_action_keyboard_shortcuts()
{
   ks_window.show();
   ks_window.raise();
}

void ExampleWindow::on_action_select_sequence()
{
   //std::cout << "Inside on_action_select_sequence()." << std::endl;
   on_sequence_clicked(NULL);
   return;
}

void ExampleWindow::about_sequencer()
{
	Glib::ustring header("	Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com> \n\n");
	
	Glib::ustring aboutinfo(_( 
	"			This is Chord Sequencer. \n\n\
\
Chord Sequencer is a program to create and interactively play \
series of chords in the live performance, controlling chord \
change by pedal (or other similar device). It uses midi and \
must be connected to an external synthesizer. \n\n\
\
Chord Sequencer is free software: you can redistribute it and/or modify \
it under the terms of the GNU General Public License as published by \
the Free Software Foundation, either version 3 of the License, or \
(at your option) any later version. \n\n\
\
Chord Sequencer is distributed in the hope that it will be useful, \
but WITHOUT ANY WARRANTY; without even the implied warranty of \
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the \
GNU General Public License for more details. \n\n\
\
You should have received a copy of the GNU General Public License \
along with Chord Sequencer. \
If not, see <https://www.gnu.org/licenses/>.\n\n\
\
Author: ") );
	Glib::ustring footer("Marvin Eagle <trailblazer77_2000@yahoo.com>");
	
	Glib::ustring composed_ustring(header + aboutinfo + footer);
	
	Gtk::MessageDialog dialog(*this, composed_ustring);
	dialog.run();
	
	return;
}

void ExampleWindow::on_action_play_chord()
{
	on_chord_play_clicked(NULL);
	on_play_chord();
	return;
}

void ExampleWindow::on_action_next_chord()
{
	on_chord_play_clicked(NULL);
	on_next_chord();
	return;
}

void ExampleWindow::on_action_previous_chord()
{
	on_chord_play_clicked(NULL);
	on_previous_chord();
	return;
}

void ExampleWindow::on_action_stop_chord()
{
	on_chord_play_clicked(NULL);
	on_stop_chord();
	return;
}

void ExampleWindow::on_action_copy_chord()
{
	on_chord_edit_clicked(NULL);
	on_copy_chord();
}

void ExampleWindow::on_action_paste_chord()
{
	on_chord_edit_clicked(NULL);
	on_paste_chord();
}

void ExampleWindow::on_action_new_chord()
{
	on_chord_edit_clicked(NULL);
	on_new_chord();
}
void ExampleWindow::on_action_delete_chord()
{
	on_chord_edit_clicked(NULL);
	on_delete_chord();
}

// This function reads file saved_shortcuts.txt and parses every line to tokens.
// First token is name of the command, second is the keyvalue (integer)
// Third token is optional and is the second key keyvalue (integer).
void ExampleWindow::KeyShortcutsWindow::read_shortcuts_file()
{
	//puts("inside read_shortcuts_file\n");
	std::ifstream file("saved_shortcuts.txt");
	std::string delimiter;
	std::string line, name_token, value_token, u_value_buffer, name_buffer;
	Glib::ustring u_line, u_name_token, u_value_token, u_second_value_token;
	Glib::ustring u_name_buffer;
	int shortcut_index, pos, count;
	
	if(!file)
	{
		std::cout << Glib::ustring::compose(_("Cannot open file %1"), 
												"saved_shortcuts.txt");
		return;
	}
	
	count = 0;
    while (std::getline(file, line))
    {
		guint u_value_guint, u_second_value_guint;
		gchar * u_value_gchar;
		gchar * u_second_value_gchar;
		
		delimiter = "=";
		count++;
		if(count > number_of_shortcuts)
		{
			//printf("number_of_shortcuts is %d\n", number_of_shortcuts);
			break;
		}
			
		//puts("inside read_shortcuts_file while loop\n");	
		u_line = (Glib::ustring) line;
		if ( (pos = u_line.find(delimiter) ) != Glib::ustring::npos)// delimiter found
		{
			//puts("delimiter found\n");
			u_name_buffer = u_line.substr(0, pos);
			u_name_token = trim(u_name_buffer);
			u_line.erase(0, pos + delimiter.length() );
						
			// find the index of the shortcut
			for(int i=0; i<number_of_shortcuts; i++)
			{
				if(u_name_token == *shortcut_strings[i])
				{
					//puts("found shortcut name\n");
					shortcut_index = i;
				}
				
			}
			// Index found. Now check how many keys are in this shortcut
			delimiter = "+";
			if ( (pos = u_line.find(delimiter) ) != Glib::ustring::npos)// delimiter found
			{
				// we have two keys
				u_value_buffer = u_line.substr(0, pos);
				u_value_token = trim(u_value_buffer);
				u_value_guint = (guint) atoi(u_value_token.c_str() );
				u_value_gchar = gdk_keyval_name ( u_value_guint);
				Glib::ustring u_value_string(u_value_gchar);
				
				u_line.erase(0, pos + delimiter.length() );
				u_second_value_token = trim(u_line);
				u_second_value_guint = (guint) atoi(u_second_value_token.c_str() );
				u_second_value_gchar = gdk_keyval_name ( u_second_value_guint);
				Glib::ustring u_second_value_string(u_second_value_gchar);
				
				// Create a ustring by placing " + " between two ustrings
				Glib::ustring u_compound_string = u_value_string + " + " +
									u_second_value_string;

				entries[shortcut_index]->set_text(u_compound_string);
						
				shortcut_keys[shortcut_index][0] = u_value_guint;
				shortcut_keys[shortcut_index][1] = u_second_value_guint;
				
			}
			else // we have one key
			{
				u_value_token = trim(u_line);
				
				u_value_guint = (guint) atoi(u_value_token.c_str() );
				// find key name
				u_value_gchar =  gdk_keyval_name ( u_value_guint);
				//printf("Key name is %s\n", u_value_gchar);
				Glib::ustring u_value_string (u_value_gchar);
	
				entries[shortcut_index]->set_text(u_value_string);	
				shortcut_keys[shortcut_index][0] = u_value_guint;
				shortcut_keys[shortcut_index][1] = 0;
			}
	
		}
		else
		{
			std::cout << Glib::ustring::compose(
             _("Error parsing file %1"), "saved_shortcuts.txt\n");
			return;
		}
	
	} // end while(std::getline(file, line))
	for (int i = 0;i<number_of_shortcuts;i++)
	{
		//printf("Shortcut_keys[i][0] is %u\n", shortcut_keys[i][0]);
	}
	
	file.close();
}


// This function is called when a key (or two key) shortcut is pressed.
// index is the index of the command in 
// ks_window.shortcut_keys and ks_window.shortcut_strings
void ExampleWindow::activate_command(int index)
{
	if(index == 0)
	{
		if(playing)
			on_next_chord();
		else
			on_play_chord();
	}
	else if(index == 1)
		on_previous_chord();
	else if(index == 2)
		on_stop_chord();
	else if(index == 3)
		on_new_chord();
	else if(index == 4)
		on_copy_chord();
	else if(index == 5)
		on_paste_chord();
	else
		puts("Error: invalid index\n");
		
}

void ExampleWindow::KeyShortcutsWindow::on_learn_button_clicked(int data)
{
	learn_mode = true;
	learn_index = data;
	//printf("Learn button clicked with data = %d\n", data);
	
	// wait for the user to click new shortcut(s)
}


// This function implements non-ordinary key shortcut system.
// First, it is inclusive in the sense that several shortcuts can be 
// activated at the same time. Second, when two shortcut keys are assigned
// to an action, it could be any two keys, not necessarily a modifier key.
// Two keys is a maximum length of a shortcut.
bool ExampleWindow::KeyShortcutsWindow::onSKeyPress(GdkEventKey* event)
{
	
	//printf("event.is_modifier = %u\n", event->is_modifier);

	if(learn_mode == true)
	{
		guint keyvalue =  event->keyval;
		learn_keys_pressed++;
		
		if(learn_keys_pressed == 1) // only one key pressed
			first_learn_key_pressed = keyvalue;
		else if(learn_keys_pressed == 2)
		{
			// save the shortcuts (two keys)
			save_two_shortcuts(first_learn_key_pressed, keyvalue, shortcut_keys,
												learn_index);
			learn_mode = false;
			learn_keys_pressed = 0;
			learn_index = -1;
		}
		//printf("learn_keys_pressed = %d\n", learn_keys_pressed);
	}
	return true;
}

bool ExampleWindow::KeyShortcutsWindow::onSKeyRelease(GdkEventKey* event)
{
	guint keyvalue =  event->keyval;
	//puts("inside onSKeyRelease\n");
	if(learn_mode == true)
	{
		learn_mode = false;
	}
	
	if(learn_keys_pressed > 0) // save the shortcut (single key)
	{
		if(first_learn_key_pressed != keyvalue)
			puts("Error: released key is not the same as pressed key\n");
		save_shortcut(keyvalue, shortcut_keys, learn_index);
		first_learn_key_pressed = 0;
		learn_keys_pressed = 0;
		learn_index = -1;
	}
	return true;
}

void ExampleWindow::KeyShortcutsWindow::save_shortcut(guint key, 
								guint two_d_array[6][2], int index)
{
	// check if the key is already used
	for(int i= 0; i<number_of_shortcuts; i++)
	{
		if(shortcut_keys[i][1] == 0 && shortcut_keys[i][0] == key)
		{
			Glib::ustring message(_("This shortcut key is already being used") );
			Gtk::MessageDialog dialog(*this, message);
			dialog.run();
			return;
		}
	}
	// update two_d_array
	two_d_array[index][0] = key;
	two_d_array[index][1] = 0;
	
	// get string representation of this two key shortcut
	gchar * key_gchar = gdk_keyval_name (key);
	//printf("key name  is %s\n", key_gchar);
	Glib::ustring key_string(key_gchar);
	// update ks_window Gtk::Entry 
	
	entries[index]->set_text(key_string);
	shortcuts_changed = true; // used later to update labels
							// inside menus
	write_shortcuts_file();
}

void ExampleWindow::KeyShortcutsWindow::save_two_shortcuts(guint first_key, 
				guint second_key, guint two_d_array[6][2], int index)
{
	//puts("inside save two shortcuts\n");
	
	// check if the key combination is already used
	int ind = two_key_search(first_key, second_key, two_d_array);
	if(ind > -1)
	{
		Glib::ustring message(_("This two key combination is already being used") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	else
	{
	// update two_d_array
		two_d_array[index][0] = first_key;
		two_d_array[index][1] = second_key;
	
		// update menu label -> this can only be done after the ks_window
		// closes and control returns to on_action_keyboard_shortcuts() 
		
		// get string representation of this two key shortcut
		gchar * first_key_gchar = gdk_keyval_name (first_key);
		gchar * second_key_gchar = gdk_keyval_name (second_key);
		Glib::ustring first_key_string(first_key_gchar);
		Glib::ustring second_key_string(second_key_gchar);
					
			// Create a ustring by placing " + " between two ustrings
		Glib::ustring u_compound_string = first_key_string + " + " +
										second_key_string;
		
		// update ks_window Gtk::Entry 
		entries[index]->set_text(u_compound_string);
		shortcuts_changed = true; // used later to update labels
							// inside menus
		write_shortcuts_file();
								
	}
} // end save_two_shortcuts()

void ExampleWindow::KeyShortcutsWindow::write_shortcuts_file()
{
	Glib::ustring * buffer;
	
	std::ofstream out("saved_shortcuts.txt");
	if(!out)
	{
		std::cout << Glib::ustring::compose(
             _("Cannot open file %1"), "saved_shortcuts.txt.\n");
		return;
	}
	for(int i=0; i<number_of_shortcuts; i++)
	{
		out << *shortcut_strings[i] << " = ";
		out << shortcut_keys[i][0] ;
		if (shortcut_keys[i][1] != 0)
			out << " + " << shortcut_keys[i][1] << std::endl;
		else
			out << std::endl;
	}

	out.close();
	out << _("file saved") << std::endl;
}

void ExampleWindow::KeyShortcutsWindow::on_close_button_clicked()
{
	hide();
}

void ExampleWindow::update_menu_labels()
{
	//puts("inside update menu labels\n");
	const gchar * s = "\t\t\t\t\t";
	size_t total_label_length = 30;
	Glib::ustring spacer(s);
	const gchar * plus = "+";
	Glib::ustring plus_sign(plus);
	
	for(int i = 0; i<ks_window.number_of_shortcuts; i++)
	{
		//  get short string representation of this two key shortcut
		gchar * first_key_gchar = gtk_accelerator_get_label( 
					ks_window.shortcut_keys[i][0],(GdkModifierType ) 0 );
		Glib::ustring first_key_string(first_key_gchar);
		size_t first_string_size = first_key_string.length();
		//printf("Index %d: size of first string is %ld\n", i, first_string_size);
		size_t command_string_size = ks_window.shortcut_strings[i]->length();	
		//printf("Index %d: size of command string is %ld\n", i, command_string_size);
		
				
		if(ks_window.shortcut_keys[i][1] != 0) // two key shortcut
		{
			gchar * second_key_gchar = gtk_accelerator_get_label( 
					ks_window.shortcut_keys[i][1],(GdkModifierType ) 0 );
			Glib::ustring second_key_string(second_key_gchar);		
			size_t second_string_size = second_key_string.length();
			
			
			//printf("Index %d: size of second string is %ld\n", i, second_string_size);
					
					
			// Create a ustring by placing " + " between two ustrings
			Glib::ustring u_compound_string = first_key_string;
			u_compound_string.append(1, '+');
			u_compound_string.append(second_key_string);
			size_t number_of_spaces = 30 - first_string_size - second_string_size - command_string_size - 1;
			size_t number_of_tabs = 0;
			if (number_of_spaces > 6)
			{
				number_of_tabs = (number_of_spaces / 4) ;
				number_of_spaces = number_of_spaces - number_of_tabs * 4 + 1;
			
			}
			
			
			//printf("Adding %ld spaces\n", number_of_spaces);							
			// Create a menu label string by adding menu item name
			
			Glib::ustring u_label_string = * ks_window.shortcut_strings[i];
			u_label_string.append(number_of_tabs, '\t');
			u_label_string.append(number_of_spaces, ' ');
			u_label_string.append(u_compound_string);
								
								
			// change menu label
			menu_items_with_shotrcuts[i]->set_label(u_label_string);
		}
		else //one key shortcut
		{
			// Create a menu label string by adding menu item name
			size_t number_of_spaces = 30 - first_string_size - command_string_size;
			size_t number_of_tabs = 0;
			if (number_of_spaces > 6)
			{
				number_of_tabs = (number_of_spaces / 4) ;
				number_of_spaces = number_of_spaces - number_of_tabs * 4;
			
			}
			//printf("Adding %ld spaces\n", number_of_spaces);
			
			
			
			Glib::ustring u_label_string = * ks_window.shortcut_strings[i];
			u_label_string.append(number_of_tabs, '\t');
			u_label_string.append(number_of_spaces, ' ');
			u_label_string.append(first_key_string);	
			// change menu label
			menu_items_with_shotrcuts[i]->set_label(u_label_string);
		}
		puts("\n");
	}
}// end update_menu_labels();

void ExampleWindow::on_action_select_chord()
{
	Glib::ustring message = _("To select a chord, when there is more than one \
chord on the screen, just click on the purple \
chord button right below the chord you want to \
select on the chord screen");
	Gtk::MessageDialog dialog(*this, message);
	dialog.run();
	return;
}

void ExampleWindow::on_action_select_note()
{
	Glib::ustring message = _("To select a note, just click on it. \
The note should turn orange when selected");
	Gtk::MessageDialog dialog(*this, message);
	dialog.run();
	return;
}

void ExampleWindow::on_action_deselect_note()
{
	Glib::ustring message = _("To deselect a note, just click on it. \
The note should turn back to light green when deselected");
	Gtk::MessageDialog dialog(*this, message);
	dialog.run();
	return;
}

void ExampleWindow::on_action_new_note()
{
	Glib::ustring message = _("To create a new note, first select the chord, \
where you want the note to appear. \
It could be either empty chord made by pressing \
New Chord button, or a chord with some other \
notes in it. Then press on one of the keys \
on the keyboard to the left.");
	Gtk::MessageDialog dialog(*this, message);
	dialog.run();
	return;
}

void ExampleWindow::on_action_delete_note()
{
	Glib::ustring message = _("To delete an existing note, first select the chord, \
where the note is located. Then press on the \
corresponding to the note key on the keyboard \
to the left (the same key that you pressed to \
create this note).");
	Gtk::MessageDialog dialog(*this, message);
	dialog.run();
	return;
}

void ExampleWindow::show_manual()
{
	manual.show();
	manual.raise();
}

void ExampleWindow::on_channel_change(Gtk::RadioMenuItem * item, int index)
{
	if(item->get_active() )
	{
		// change channel
		channel = index + 1;
		// save it to a file
		std::ofstream out("channel.txt");
		if(!out)
		{
			std::cout << Glib::ustring::compose(
             _("Cannot open file %1"), "channel.txt.\n");
			return;
		}
		out << channel;
		out.close();
		//puts("saved\n");
		
	}
}

void ExampleWindow::read_channel_file()
{
	std::string line;
	std::ifstream file("channel.txt");
	if(!file)
	{
		std::cout << Glib::ustring::compose(
             _("Cannot open file %1"), "channel.txt.\n");
		return;
	}
	std::getline(file, line);
	channel = std::stoi(line);
	
	file.close();
	
}

// This function splits section base and every corresponding section,
// creating new section button, eventbox and adding it to section_HBox.
// Split line is the right edge of selected chord.
void ExampleWindow::split_section()
{
	puts("\nsplitting...");
	int spacer = 1; // space between sections
	int len = Dlist::dl_count(area.current_sequence);
	if(len < 2)
	{
		Glib::ustring message(_("Cannot split: number of chords is less than 2") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	else if(selected_chord_number == len)
	{
		Glib::ustring message(_("Cannot split: selected chord is the last one") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	
	// find Section_base to split
	Section_base * base;
	int num_bases = Dlist::dl_count( (Dlnode*)area.curs_node->section_bases);
	printf("num_bases is %d\n", num_bases);
	
	Dlnode * buf_base_node = (Dlnode*) area.curs_node->section_bases;
	while(buf_base_node != NULL)
	{
		Section_base * buffer = (Section_base *) buf_base_node->data;
		int s = buffer->chord_start;
		int e = buffer->chord_end;
		printf("s is %d, e is %d\n", s, e);
		printf("selected chord number is %d\n", selected_chord_number);
		if(selected_chord_number >= s && selected_chord_number <= e)
		{
			if(selected_chord_number == buffer->chord_end)
			{
				Glib::ustring message(_("Cannot split: selected chord is the last one \
 in the section") );
				Gtk::MessageDialog dialog(*this, message);
				dialog.run();
				return;
			}
			puts("base is found\n");
			base = buffer;
			break;
		}
		buf_base_node = buf_base_node->next;
	}
	
	// create new Section_base
	Section_base * new_base = new Section_base();
	// add it to the Dlnode in the right order
	buf_base_node = (Dlnode*) area.curs_node->section_bases;
	Section_base * buf_base;
	while(buf_base_node != NULL)
	{
		buf_base = (Section_base*) buf_base_node->data;
		if(buf_base->chord_end >= selected_chord_number)
		{
			area.curs_node->section_bases = Dlist::dl_insert_before( (Dlnode*)
				area.curs_node->section_bases, buf_base_node->next, new_base);
			break;
		} 
		buf_base_node = buf_base_node->next;
	}
	
	// update original base
	new_base->chord_end = base->chord_end;
	base->chord_end = selected_chord_number;
	new_base->chord_start = selected_chord_number + 1;
	new_base->length = new_base->chord_end - new_base->chord_start + 1;
	base->length = base->chord_end - base->chord_start + 1;
	
	
	// SPLIT SECTION
	// find which section(s) to split based on sect_chord_start and sect_chord_end
		
	int count = 1;
	Dlnode * sections_head = (Dlnode*) area.curs_node->sections;
	Dlnode * buf_sect_node = (Dlnode*) area.curs_node->sections;
	MyButton * buf_button;
	
	while(buf_sect_node != NULL)
	{
		printf("inside split: count = %d\n", count);
		buf_button = (MyButton *) buf_sect_node->section_button;
		int s = buf_button->sect_chord_start;
		int e = buf_button->sect_chord_end;
		printf("inside split: s is %d, e is %d\n", s, e);
		if(selected_chord_number >= s && selected_chord_number < e)
		{
			puts("\nFound section to split");
			// create new section (== section button)
			MyButton * new_section_btn = new MyButton();
			new_section_btn->button_type = 4;
			new_section_btn->sect_name = NULL;
			
			// calculate new start and end of the button using total pixel
			// length and chord length of the original section and chord
			// length of each of two split sections:
			
			int original_pix = buf_button->sect_pix_length;
			int original_chord = buf_button->sect_chord_length;
			float rate = (float) (original_pix - spacer)/ original_chord;
			printf("rate is %f\n", rate);
			
			int right_split_pix = floor((double) (new_base->length * rate) );
			int left_split_pix = floor((double) (base->length * rate) );
			printf("rsp = %d, lsp = %d\n", right_split_pix, left_split_pix);
			new_section_btn->sect_chord_start = selected_chord_number + 1;
			new_section_btn->sect_chord_end = buf_button->sect_chord_end;
			new_section_btn->sect_end = buf_button->sect_end;
			new_section_btn->sect_start = buf_button->sect_end - right_split_pix;
			new_section_btn->sect_chord_length = new_base->length;
			new_section_btn->sect_pix_length = right_split_pix;
			new_section_btn->set_size_request(right_split_pix, 30);
			
			Gtk::EventBox * new_eventbox = new Gtk::EventBox();
			
			new_eventbox->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK | Gdk::LEAVE_NOTIFY_MASK );
			new_eventbox->signal_button_press_event().connect(sigc::bind<MyButton *>(
					sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_clicked), new_section_btn) );
			new_eventbox->signal_enter_notify_event().connect(sigc::bind<MyButton *>(
					sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_enter), new_section_btn) );
			new_eventbox->signal_leave_notify_event().connect(sigc::bind<MyButton *>(
					sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_leave), new_section_btn) );
			
			printf("Created new section with start = %d, end = %d\n", new_section_btn->sect_start,
											new_section_btn->sect_end);
			printf("sect_pix_length of new button is %d\n", new_section_btn->
													sect_pix_length);

			new_eventbox->add(*new_section_btn);
			// update the original section
			buf_button->sect_pix_length = left_split_pix;
			printf("sect_pix_length of left button is %d\n", buf_button->
													sect_pix_length);
			buf_button->sect_chord_length = base->length;
			buf_button->sect_end = buf_button->sect_start + left_split_pix - 1;
			buf_button->sect_chord_end = base->chord_end;
			printf("sect_chord_length of left button is %d\n", buf_button->
													sect_chord_length);
			buf_button->set_size_request(left_split_pix, 30);
			buf_button->queue_draw();
						
			// check how many sections are in sections Dlist
			int num_sections = Dlist::dl_count(sections_head);
			printf("Length of section_buttons Dlnode is %d\n", num_sections);
			// check if this section is the last one in section_buttons
			int section_index = Dlist::dl_node_index(sections_head, buf_sect_node);
			printf("Index of current section in section_buttons is %d\n", 
											section_index); // starts from 0
											
			
			// create new section and insert or append it to the sections Dlist
			// add new_section_btn to the new section
			bool last = false;
			if(num_sections == section_index + 1) // last section
			{
				sections_head = Dlist::dl_append_but(sections_head, new_section_btn);
				last = true;
			}
			else
			{
				Dlnode * buffer_link = Dlist::dl_find_but(sections_head, buf_button);
				buffer_link = buffer_link->next;
				sections_head = Dlist::dl_insert_before_but(sections_head, 
									buffer_link, new_section_btn);
			}
			puts("line 4944");
			// add new_eventbox to the new section
			Dlnode * new_sect = Dlist::dl_find_but(sections_head, new_section_btn);
			new_sect->eventbox = new_eventbox;
			
			// add new eventbox to the section_HBox
			section_HBox.add(*new_eventbox);
			section_HBox.reorder_child(*new_eventbox, count);
					
		} // end if
		buf_sect_node = buf_sect_node->next;
		count++;
	} // end while
	
	// repaint all section buttons
	copied_section = NULL;
	selected_section = NULL;
	update_section_buttons();
	puts("line 4966");
	
	section_HBox.show_all_children();
	area.queue_draw();
} // end split

bool ExampleWindow::on_section_buttons_enter(GdkEventCrossing* crossing_event,
							MyButton * button)
{
	button->over = true;
	button->queue_draw();
	return true;
}

bool ExampleWindow::on_section_buttons_clicked(GdkEventButton* button_event,
								MyButton * button)
{
	Dlnode * new_sel_sect;
	if(button->pressed )
	{
		button->pressed = false;
		selected_section = NULL;
	}
	else
	{
		//Only one section button can be pressed at a time
		Dlnode * buffer_sect = (Dlnode *) area.curs_node->sections;
		MyButton * buffer_but;
		while(buffer_sect != NULL)
		{
			buffer_but = (MyButton *) buffer_sect->section_button;
			buffer_but->pressed = false;
			buffer_but->queue_draw();
			if(buffer_but == button)
				selected_section = buffer_sect;
				
			buffer_sect = buffer_sect->next;
		}
		// find the section corresponding to the pressed button:
		new_sel_sect = Dlist::dl_find_but((Dlnode*) area.curs_node->sections, 
														button);
		selected_section = new_sel_sect;
		// change selected chord to the selected section start
		selected_chord_number = button->sect_chord_start;
		area.current_chord = (Dlnode * ) Dlist::dl_nth_data 
					(area.current_sequence, selected_chord_number - 1);
		
		// mark chord button as selected
		chord_radio_buttons[selected_chord_number - 1]->pressed = true;
		for (int i=0; i<64; i++)
		{
			if (i != (selected_chord_number - 1) )
			{
				chord_radio_buttons[i]->pressed = false;
			}
			chord_radio_buttons[i]->queue_draw (); 
		}
		button->pressed = true;
	} // end else
	button->queue_draw();
	
		// adjust scroller 
	int sequence_length = Dlist::dl_count(area.current_sequence);
	if(sequence_length > 16)
	{
		double v;
		
		if( selected_chord_number <= sequence_length)
			v = 53 * (selected_chord_number - 10);
		else
			v = 0;
		scroll_adj->set_value(v);
	}

	area.queue_draw();
	return true;
} // end on_section_buttons_clicked()

bool ExampleWindow::on_section_buttons_leave(GdkEventCrossing* crossing_event,
								MyButton * button)
{
	button->over = false;
	button->queue_draw();	
	return true;
}


// This function deep copies all sequences to new Dlist, without
// binding the eventboxes to the event handlers. Returns head of the new
// sequences Dlist. 
Sequence * ExampleWindow::copy_all_sequences(Sequence * seque_to_copy)
{
	Sequence * new_seque_head = NULL;
	Sequence * new_seque_node;
	Dlnode * new_chord_head = NULL;
	Dlnode * new_chord_node;
	Dlnode * new_note_head = NULL;
	Dlnode * new_note_node;
	Dlnode * chord_node;
	Dlnode * note_node;
	Note * new_note;
	Note * note;
	Dlnode * prev_seque_node = NULL;
	Dlnode * prev_chord_node = NULL;
	Dlnode * prev_note_node = NULL;
	Sequence * sequence_node;
	
	Dlnode * section_node, *new_section_node;
	Dlnode * new_section_head = NULL;
	Dlnode * prev_section_node = NULL;
	Gtk::EventBox * new_eventbox;
	MyButton * new_button, * button;
	
	Dlnode * new_base_head = NULL;
	Dlnode * prev_base_node = NULL;
	Dlnode * base_node, * new_base_node;
	Section_base * new_base, * base;
	
	
	sequence_node = seque_to_copy;
	while(sequence_node != NULL)
	{
		new_seque_node = Dlist::dl_create();
		if(new_seque_head == NULL) // first node
		{
			new_seque_head = new_seque_node;
			prev_seque_node = new_seque_node;
		}
		else
		{
			prev_seque_node->next = new_seque_node;
			prev_seque_node = prev_seque_node->next;
		}
		// copy sequence name ustring
		if(sequence_node->name != NULL)
		{
			Glib::ustring * seque_name = (Glib::ustring *)sequence_node->name;
			const Glib::ustring& con_seque_name = *seque_name;
			new_seque_node->name = new Glib::ustring(con_seque_name);	
			
		}
		
		// copy chords and notes
		chord_node = (Dlnode *) sequence_node->data;
		while(chord_node != NULL)
		{			
			new_chord_node =  Dlist::dl_create();
			if(new_chord_head == NULL) // first node
			{
				new_chord_head = new_chord_node;
				prev_chord_node = new_chord_node;
				new_seque_node->data = new_chord_head;
			}
			else
			{
				prev_chord_node->next = new_chord_node;
				prev_chord_node = prev_chord_node->next;
			}
			note_node = (Dlnode *) chord_node->data;
			while(note_node != NULL)
			{
				note = (Note *) note_node->data;
				int midi_num = note->midi_number;
				new_note_node = Dlist::dl_create();
				new_note = new Note(midi_num);
				new_note->velocity = note->velocity;
				new_note->midi_instrument = note->midi_instrument;
				new_note->position_x = note->position_x;
				new_note->position_y = note->position_y;
				new_note->normal_x = note->normal_x;
				new_note->midi_channel = note->midi_channel;
				new_note->display = note->display;
				new_note->display_options = note->display_options;
				new_note->black = note->black;
				
				if(new_note_head == NULL) // first node
				{
					new_note_head = new_note_node;
					prev_note_node = new_note_node;
					prev_chord_node->data = new_note_head;
				}
				else
				{
					prev_note_node->next = new_note_node;
					prev_note_node = prev_note_node->next;
				}
				new_note_node->data = new_note;
			}
		}
		// copy sections, section_buttons and eventboxes
		section_node = (Dlnode *) sequence_node->sections;
		while(section_node != NULL)
		{
			new_section_node =  Dlist::dl_create();
			if(new_section_head == NULL) // first node
			{
				new_section_head = new_section_node;
				prev_section_node = new_section_node;
				prev_seque_node->sections = new_section_head;
			}
			else
			{
				prev_section_node->next = new_section_node;
				prev_section_node = prev_section_node->next;
			}
			
			if(section_node->eventbox != NULL)
			{
				new_eventbox = new Gtk::EventBox();
				new_section_node->eventbox = new_eventbox;
			}
			
			if(section_node->section_button != NULL)
			{
				button = (MyButton*) section_node->section_button;
				new_button = new MyButton();
				new_section_node->section_button = new_button;
				new_button->button_type = button->button_type;
				new_button->button_name = button->button_name;
				new_button->sect_start = button->sect_start;
				new_button->sect_end = button->sect_end;
				new_button->sect_chord_start = button->sect_chord_start;
				new_button->sect_chord_end = button->sect_chord_end;
				new_button->sect_chord_length = button->sect_chord_length;
				new_button->sect_pix_length = button->sect_pix_length;
				new_button->set_size_request(new_button->sect_pix_length, 30);
				if(new_button->sect_name != NULL)
				{
					// copy section name ustring
					Glib::ustring * sect_name = (Glib::ustring*)button->sect_name;
					const  Glib::ustring& con_sect_name = *sect_name;
					new_button->sect_name = new Glib::ustring(con_sect_name);
				}
			}
			
			if(section_node->eventbox != NULL && 
							section_node->section_button != NULL)
				new_eventbox->add(*new_button);
			
		}
		// copy section_bases
		base_node = ( Dlnode *) sequence_node->section_bases;
		while(base_node != NULL)
		{
			Section_base * base = (Section_base *) base_node->data;
			new_base_node =  Dlist::dl_create();
			if(new_base_head == NULL) // first node
			{
				new_base_head = new_base_node;
				prev_base_node = new_base_node;
				prev_seque_node->section_bases = new_base_head;
			}
			else
			{
				prev_base_node->next = new_base_node;
				prev_base_node = prev_base_node->next;
			}
			
			new_base = new Section_base();
			new_base_node->data = new_base;
			new_base->chord_start = base->chord_start;
			new_base->chord_end = base->chord_end;
			new_base->length = base->length;
			if(base_node->name != NULL)
			{
				// copy section base name ustring
				Glib::ustring * base_name = (Glib::ustring *)base->name;
				const Glib::ustring& con_base_name = *base_name;
				new_base->name = new Glib::ustring(con_base_name);				
			}
		}
	}
	return new_seque_head;
} // end copy_all_sequences()


// This function deep copies one sequence, without binding the eventboxes 
// to the event handlers. Returns head of the new sequence Dlist;
// Provided: sequence node * seque_to_copy
Sequence * ExampleWindow::copy_sequence(Sequence * seque_to_copy)
{
	//Sequence * new_seque_head = NULL;
	Sequence * new_seque_node;
	Dlnode * new_chord_head = NULL;
	Dlnode * new_chord_node;
	Dlnode * new_note_head = NULL;
	Dlnode * new_note_node;
	Dlnode * chord_node;
	Dlnode * note_node;
	Note * new_note;
	Note * note;
	//Dlnode * prev_seque_node = NULL;
	Dlnode * prev_chord_node = NULL;
	Dlnode * prev_note_node = NULL;
	Sequence * sequence_node;
	
	Dlnode * section_node, *new_section_node;
	Dlnode * new_section_head = NULL;
	Dlnode * prev_section_node = NULL;
	Gtk::EventBox * new_eventbox;
	MyButton * new_button, * button;
	
	Dlnode * new_base_head = NULL;
	Dlnode * prev_base_node = NULL;
	Dlnode * base_node, * new_base_node;
	Section_base * new_base, * base;
	
	
	sequence_node = seque_to_copy;
	new_seque_node = Dlist::dl_create();

	// copy sequence name ustring
	if(sequence_node->name != NULL)
	{
		Glib::ustring * seque_name = (Glib::ustring *)sequence_node->name;
		const Glib::ustring& con_seque_name = *seque_name;
		new_seque_node->name = new Glib::ustring(con_seque_name);	
		
	}
	// copy chords and notes
	chord_node = (Dlnode *) sequence_node->data;
	int n = 0;
	while(chord_node != NULL)
	{	
		n++;
		if(n > 100)
		{
			puts("n > 100");
			break;
		}
		//puts("inside outer while");
		new_chord_node =  Dlist::dl_create();
		if(new_chord_head == NULL) // first node
		{
			new_chord_head = new_chord_node;
			prev_chord_node = new_chord_node;
			new_seque_node->data = new_chord_head;
		}
		else
		{
			prev_chord_node->next = new_chord_node;
			prev_chord_node = prev_chord_node->next;
		}
		note_node = (Dlnode *) chord_node->data;
		int m=0;
		while(note_node != NULL)
		{
			m++;
			if(m>100)
			{
				puts(" m > 100 ");
				break;
			}
			//puts("inside inner while");
			note = (Note *) note_node->data;
			int midi_num = note->midi_number;
			new_note_node = Dlist::dl_create();
			new_note = new Note(midi_num);
			new_note->velocity = note->velocity;
			new_note->midi_instrument = note->midi_instrument;
			new_note->position_x = note->position_x;
			new_note->position_y = note->position_y;
			new_note->normal_x = note->normal_x;
			new_note->midi_channel = note->midi_channel;
			new_note->display = note->display;
			new_note->display_options = note->display_options;
			new_note->black = note->black;

			if(new_note_head == NULL) // first node
			{
				new_note_head = new_note_node;
				prev_note_node = new_note_node;
				prev_chord_node->data = new_note_head;
			}
			else
			{
				prev_note_node->next = new_note_node;
				prev_note_node = prev_note_node->next;
			}
			new_note_node->data = new_note;
			note_node = note_node->next;
		}
		chord_node = chord_node->next;
	}
	
	// copy sections, section_buttons and eventboxes
	section_node = (Dlnode *) sequence_node->sections;
	int d=0;
	while(section_node != NULL)
	{
		d++;
		if(d > 100)
		{
			puts("d > 100");
			break;
		}
		new_section_node =  Dlist::dl_create();
		if(new_section_head == NULL) // first node
		{
			new_section_head = new_section_node;
			prev_section_node = new_section_node;
			new_seque_node->sections = new_section_head;
		}
		else
		{
			prev_section_node->next = new_section_node;
			prev_section_node = prev_section_node->next;
		}
		
		if(section_node->eventbox != NULL)
		{
			new_eventbox = new Gtk::EventBox();
			new_section_node->eventbox = new_eventbox;
		}
		
		if(section_node->section_button != NULL)
		{
			button = (MyButton*) section_node->section_button;
			new_button = new MyButton();
			new_section_node->section_button = new_button;
			new_button->button_type = button->button_type;
			new_button->button_name = button->button_name;
			new_button->sect_start = button->sect_start;
			new_button->sect_end = button->sect_end;
			new_button->sect_chord_start = button->sect_chord_start;
			new_button->sect_chord_end = button->sect_chord_end;
			new_button->sect_chord_length = button->sect_chord_length;
			new_button->sect_pix_length = button->sect_pix_length;
			new_button->set_size_request(new_button->sect_pix_length, 30);
			if(new_button->sect_name != NULL)
			{
				// copy section name ustring
				Glib::ustring * sect_name = (Glib::ustring*)button->sect_name;
				const  Glib::ustring& con_sect_name = *sect_name;
				new_button->sect_name = new Glib::ustring(con_sect_name);
			}
		}
		
		if(section_node->eventbox != NULL && 
						section_node->section_button != NULL)
			new_eventbox->add(*new_button);
			
		section_node = section_node->next;
		
	}
	
	// copy section_bases
	base_node = ( Dlnode *) sequence_node->section_bases;
	int f = 0;
	while(base_node != NULL)
	{
		//puts("inside base_node while");
		f++;
		if(f > 100)
		{
			puts("f > 100");
			break;
		}
		Section_base * base = (Section_base *) base_node->data;
		new_base_node =  Dlist::dl_create();
		if(new_base_head == NULL) // first node
		{
			new_base_head = new_base_node;
			prev_base_node = new_base_node;
			new_seque_node->section_bases = new_base_head;
		}
		else
		{
			prev_base_node->next = new_base_node;
			prev_base_node = prev_base_node->next;
		}
		new_base = new Section_base();
		new_base_node->data = new_base;
		new_base->chord_start = base->chord_start;
		new_base->chord_end = base->chord_end;
		new_base->length = base->length;
		if(base->name != NULL)
		{
			// copy section base name ustring
			Glib::ustring * base_name = (Glib::ustring *)base->name;
			const Glib::ustring& con_base_name = *base_name;
			new_base->name = new Glib::ustring(con_base_name);				
		}
		base_node = base_node->next;
	}
	puts("line 5509");
	return new_seque_node;
} // end copy_sequence

void ExampleWindow::copy_section()
{
	copied_section = selected_section;
}

void ExampleWindow::paste_before_section()
{
	if(copied_section == NULL)
	{
		Glib::ustring  message ( _("Nothing to paste") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	if(selected_section == NULL)
	{
		Glib::ustring  message ( _("Select a section to paste before") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	
	puts("pasting...");
	int selected_sect_index = Dlist::dl_node_index( (Dlnode*) 
						area.curs_node->sections, 	selected_section);
		// create new section, button and event box
	MyButton * copied_button = (MyButton*) copied_section->section_button;
	MyButton * new_button = new MyButton();
	Gtk::EventBox * new_evbox = new Gtk::EventBox();
	
	new_button->button_type = 4;
	new_button->sect_chord_start = copied_button->sect_chord_start;
	new_button->sect_chord_end = copied_button->sect_chord_end;
	new_button->sect_chord_length = copied_button->sect_chord_length;
	new_button->sect_name = NULL;
	puts("line 6265");
	
	// check if the corresponding base has a name
	Glib::ustring * base_name = NULL;
	Dlnode * base_node = (Dlnode *) area.curs_node->section_bases;
	Section_base * buf_base;
	while(base_node != NULL)
	{
		buf_base = (Section_base *) base_node->data;
		if(buf_base->chord_start == copied_button->sect_chord_start &&
			buf_base->chord_end == copied_button->sect_chord_end)
		{
			if(buf_base->name != NULL)
				base_name = buf_base->name;
			break;
		}
		base_node = base_node->next;
	}
	puts("line 6281");
	if(base_name != NULL)
	{ // the corresponding base has a name
		new_button->sect_name = copy_ustring(base_name);
	}
	else // the corresponding base does not have a name
	{
		new_button->sect_name = NULL;
	}
	puts("line 6290");
	
	// Create new section by inserting button:
	area.curs_node->sections = Dlist::dl_insert_before_but( (Dlnode*)
			area.curs_node->sections, selected_section, new_button);
	Dlnode * new_section = Dlist::dl_find_but( (Dlnode*)
								area.curs_node->sections, new_button);
	new_section->eventbox = new_evbox;
	new_evbox->add(*new_button);
	
	// connect new eventbox to events
	new_evbox->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK | Gdk::LEAVE_NOTIFY_MASK );
	new_evbox->signal_button_press_event().connect(sigc::bind<MyButton *>(
		sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_clicked), new_button) );
	new_evbox->signal_enter_notify_event().connect(sigc::bind<MyButton *>(
		sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_enter), new_button) );
	new_evbox->signal_leave_notify_event().connect(sigc::bind<MyButton *>(
		sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_leave), new_button) );
	// add eventbox to section_HBox
	section_HBox.add(*new_evbox);
	
	section_HBox.reorder_child(*new_evbox, selected_sect_index);
	recalculate_section_buttons();
	copied_section = NULL;
	selected_section = NULL;
	update_section_buttons();
	section_HBox.show_all_children();
} // end paste_before_section()

// This function makes sure that all section button are deselected except
// for selected_section.
void ExampleWindow::update_section_buttons()
{
	puts("updating...");
	Dlnode * buf_node = (Dlnode *) area.curs_node->sections;
	MyButton * buf_button;
	while(buf_node != NULL)
	{
		buf_button = (MyButton*) buf_node->section_button;
		puts("line 6333");
		if(buf_node == selected_section)
		{
			buf_button->pressed = true;
		}
		else
			buf_button->pressed = false;
		buf_button->queue_draw();
		
		buf_node = buf_node->next;
		puts("line 6344");
	}
}

void ExampleWindow::paste_after_section()
{
	if(copied_section == NULL)
	{
		Glib::ustring  message ( _("Nothing to paste") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	if(selected_section == NULL)
	{
		Glib::ustring  message ( _("Select a section to paste before") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	
	puts("pasting...");
	int selected_sect_index = Dlist::dl_node_index( (Dlnode*) 
						area.curs_node->sections, 	selected_section);
		// create new section, button and event box
	MyButton * copied_button = (MyButton*) copied_section->section_button;
	MyButton * new_button = new MyButton();
	Gtk::EventBox * new_evbox = new Gtk::EventBox();
	
	new_button->button_type = 4;
	new_button->sect_chord_start = copied_button->sect_chord_start;
	new_button->sect_chord_end = copied_button->sect_chord_end;
	new_button->sect_chord_length = copied_button->sect_chord_length;
	new_button->sect_name = NULL;
	
	// check if the corresponding base has a name
	Glib::ustring * base_name = NULL;
	Dlnode * base_node = (Dlnode *) area.curs_node->section_bases;
	Section_base * buf_base;
	while(base_node != NULL)
	{
		buf_base = (Section_base *) base_node->data;
		if(buf_base->chord_start == copied_button->sect_chord_start &&
			buf_base->chord_end == copied_button->sect_chord_end)
		{
			if(buf_base->name != NULL)
				base_name = buf_base->name;
			break;
		}
		base_node = base_node->next;
	}
	puts("line 6281");
	if(base_name != NULL)
	{ // the corresponding base has a name
		new_button->sect_name = copy_ustring(base_name);
	}
	else // the corresponding base does not have a name
	{
		new_button->sect_name = NULL;
	}

	// Create new section by inserting button:
	area.curs_node->sections = Dlist::dl_insert_before_but( (Dlnode*)
			area.curs_node->sections, selected_section->next, new_button);
	Dlnode * new_section = Dlist::dl_find_but( (Dlnode*)
								area.curs_node->sections, new_button);
	new_section->eventbox = new_evbox;
	new_evbox->add(*new_button);
	
	// connect new eventbox to events
	new_evbox->set_events(Gdk::BUTTON_PRESS_MASK |	Gdk::ENTER_NOTIFY_MASK | Gdk::LEAVE_NOTIFY_MASK );
	new_evbox->signal_button_press_event().connect(sigc::bind<MyButton *>(
		sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_clicked), new_button) );
	new_evbox->signal_enter_notify_event().connect(sigc::bind<MyButton *>(
		sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_enter), new_button) );
	new_evbox->signal_leave_notify_event().connect(sigc::bind<MyButton *>(
		sigc::mem_fun(*this, &ExampleWindow::on_section_buttons_leave), new_button) );
	// add eventbox to section_HBox
	section_HBox.add(*new_evbox);
	section_HBox.reorder_child(*new_evbox, selected_sect_index + 1);
	
	recalculate_section_buttons();
	copied_section = NULL;
	selected_section = NULL;
	update_section_buttons();
	section_HBox.show_all_children();

} // end paste_after_section()

//This function joins two section bases, the one that has a selected chord
// in it and the one to the right. All corresponding consecutive sections
// that follow the same pattern as bases will be joined. All corresponding
// non-consecutive sections will be deleted. 
void ExampleWindow::join_sections()
{
	// find section bases to be joined
	Dlnode * base_node = (Dlnode *) area.curs_node->section_bases;
	Section_base * base, * left_base, * right_base;
	Dlnode * right_base_node;
	int left_start, left_end, right_start, right_end;
	bool ready_to_join_bases = false;
	int count = 0;
	while(base_node != NULL)
	{
		base = (Section_base *) base_node->data;
		int start = base->chord_start;
		int end = base->chord_end;
		
		count++;
		printf("number of base node iteration is %d\n", count);
		printf("base start is %d, end is %d\n", start, end);
		if(selected_chord_number >= start && selected_chord_number <= end)
		{
			// section base found
			puts("inside if");
			left_base = base;
			if(base_node->next != NULL) // base to the right exists
			{
				right_base_node = base_node->next;
				right_base = (Section_base *) right_base_node->data;
				left_start = left_base->chord_start;
				left_end = left_base->chord_end;
				right_start = right_base->chord_start;
				right_end = right_base->chord_end;
			}
			else // no base to the right of the left base
			{
				Glib::ustring message(_("Left section to join was found; \n \
 right section was not found.") );
				Gtk::MessageDialog dialog(*this, message);
				dialog.run();
				return;
			}
			break;
		} // end if
		
		base_node = base_node->next;
	} // end while
	
	
	// find sections to be joined
	 Dlnode * section_node = (Dlnode *) area.curs_node->sections;
	 MyButton * button;
	 Dlnode * left_section = NULL;
	 Dlnode * right_section = NULL;
	 bool ready_to_join_sections = false;
	 Dlnode * section_node_to_delete = NULL;
	 count = 0;
	 printf("selected chord number is %d\n", selected_chord_number);
	 
	 //make quick test if there are any joinable sections without deletion
	 while(section_node != NULL)
	 {
		 count++;
	
		button = (MyButton*) section_node->section_button;
		int start = button->sect_chord_start;
		int end = button->sect_chord_end;
		printf("\nnumber of section node iteration is %d\n", count);
		printf("section start is %d, end is %d\n", start, end);
		if(section_node->prev == NULL)
			puts("section_node->prev == NULL");
		if(section_node->next == NULL)
			puts("section_node->next == NULL");
		
		if(right_start == start && right_end == end)
		{
			// right section found
			puts("found right section");
			if(section_node->prev == NULL)
				puts("section_node->prev == NULL");
			if(left_section == NULL)
				puts("left_section == NULL");
			if(section_node->prev == left_section)
				puts("section_node->prev == left_section");
			if(section_node->prev != NULL && left_section != NULL && 
									section_node->prev == left_section)
			{
				// mark sections for joining
				right_section = section_node;
				ready_to_join_sections = true;
				puts("it is a joinable right section");
			}
			else
			{
				// section_node_to_delete = section_node;
				puts("it is a separated right section");
			}
		}
		else if(left_start == start && left_end == end)
		{
			// left section found - peek next section
			puts("found left section");
			if(section_node->next != NULL)
			{
				Dlnode * buff = section_node->next;
				MyButton * buff_but = (MyButton *) buff->section_button;
				if(buff_but->sect_chord_start == right_start &&
									buff_but->sect_chord_end == right_end)
			// right section is next, but we will wait until next iteration 
			// to perform a join
				{
					left_section = section_node;
					puts("it is a joinable left section");
				}
				else
				{
					// section_node_to_delete = section_node;
					puts("it is a separated left section");
				}
			}
		}
		else
		{
			left_section = NULL;
		}
		section_node = section_node->next;
		 
	} // end while
	 
	 // check if join can be performed and display dialog otherwise
	if(ready_to_join_sections == false)
	{
		Glib::ustring message(_("Join cannot be performed: sections out of order.") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	
	 
	 // Here comes the real thing:
	 section_node = (Dlnode *) area.curs_node->sections;
	 left_section = NULL;
	 right_section = NULL;
	 ready_to_join_sections = false;
	 section_node_to_delete = NULL;
	 printf("left start is %d, left end is %d\n", left_start, left_end);
	 printf("right start is %d, right end is %d\n", right_start, right_end);
	 count = 0;
	 while(section_node != NULL)
	 {
		count++;
	
		button = (MyButton*) section_node->section_button;
		int start = button->sect_chord_start;
		int end = button->sect_chord_end;
		printf("number of section node iteration is %d\n", count);
		printf("section start is %d, end is %d\n", start, end);
		
		if(right_start == start && right_end == end)
		{
			// right section found
			puts("found right section");
			if(section_node->prev == NULL)
				puts("section_node->prev == NULL");
			if(left_section == NULL)
				puts("left_section == NULL");
			if(section_node->prev == left_section)
				puts("section_node->prev == left_section");
			if(section_node->prev != NULL && left_section != NULL && 
									section_node->prev == left_section)
			{
				// join sections
				right_section = section_node;
				ready_to_join_sections = true;
				puts("it is a joinable right section");
			}
			else
			{
				section_node_to_delete = section_node;
				puts("it is a separated right section");
			}
		}
		else if(left_start == start && left_end == end)
		{
			// left section found - peek next section
			puts("found left section");
			if(section_node->next != NULL)
			{
				Dlnode * buff = section_node->next;
				MyButton * buff_but = (MyButton *) buff->section_button;
				if(buff_but->sect_chord_start == right_start &&
									buff_but->sect_chord_end == right_end)
			// right section is next, but we will wait until next iteration 
			// to perform a join
				{
					left_section = section_node;
					puts("it is a joinable left section");
				}
				else
				{
					section_node_to_delete = section_node;
					puts("it is a separated left section");
				}
			}
		}
		else
		{
			left_section = NULL;
		}
		
		section_node = section_node->next;
		
		// join sections if needed
		if(ready_to_join_sections)
		{
			MyButton * left_button = (MyButton*) left_section->section_button;
			MyButton * right_button = (MyButton*) right_section->section_button;
			left_button->sect_chord_end = right_button->sect_chord_end;
			left_button->sect_chord_length = left_button->sect_chord_length + 
										right_button->sect_chord_length;
			
			// delete right section
			section_node_to_delete = right_section;
			ready_to_join_sections = false;
			ready_to_join_bases = true;
			puts("changed left section");
		}
				// delete section if needed
		bool remove_first_section = false;
		
		if(section_node_to_delete != NULL)
		{
			if(section_node_to_delete == selected_section)
				selected_section = NULL;
			puts("line 6465");
			if(section_node_to_delete == (Dlnode *) area.curs_node->sections)// head section node
				remove_first_section = true; // will do it later
			else // not the head section node
				selected_section = (Dlnode *) area.curs_node->sections;
			
			MyButton * b = (MyButton *)section_node_to_delete->section_button;
			
			if(b->sect_name != NULL)
				delete ((Glib::ustring * ) b->sect_name);
			delete(b);
			puts("line 2033");
			Gtk::EventBox * eb = ( Gtk::EventBox*) section_node_to_delete->eventbox;
			puts("line 2034");
			//section_HBox.remove(*eb);
			puts("line 2035");
			delete((Gtk::EventBox*) section_node_to_delete->eventbox);
			puts("line 2037");
			area.curs_node->sections = Dlist::dl_delete_node( (Dlnode*)
							area.curs_node->sections, section_node_to_delete);
			puts("deleted section");
			puts("line 6477");				
			if(remove_first_section == true)
				selected_section = (Dlnode *) area.curs_node->sections;
			section_node_to_delete = NULL;
		} // end if
		
	} // end while
	
	// join section bases if needed
	if(ready_to_join_bases)
	{
		left_base->chord_end = right_base->chord_end;
		left_base->length = left_base->length + right_base->length;
		area.curs_node->section_bases = Dlist::dl_delete_node( (Dlnode *)
				area.curs_node->section_bases, right_base_node);
	}
	else
	{
		// no corresponding consecutive sections found - join cancelled
		Glib::ustring message(_("Cannot perform join, because there are \
 no consecutive sections that would correspond to the selected range.") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	
	recalculate_section_buttons();
	selected_section = NULL;
	copied_section = NULL;
	update_section_buttons();
	area.queue_draw();
	
} // end join_sections()

void ExampleWindow::name_sections()
{
		rename_sec_dialog = new Gtk::Window;
		Gtk::Box *r_vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0) );
		rename_sec_dialog->add(*r_vbox);
		Gtk::Grid *r_grid = Gtk::manage(new Gtk::Grid);
		r_grid->set_border_width(10);
		r_grid->set_row_spacing(5);
		r_vbox->add(*r_grid);
		Gtk::Label *r_lb = Gtk::manage(new Gtk::Label(_("Do you want to (re)name only this section \n\
or all similar sections?") ) );
		r_grid->attach(*r_lb, 0, 0, 3, 1);
		
		Gtk::Button * button_name_one = Gtk::manage(new Gtk::Button(_("Only this section") ) );
		button_name_one->set_size_request(150, 30);
		button_name_one->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
				(*this, &ExampleWindow::name_one_section), rename_sec_dialog) );
		r_grid->attach(*button_name_one, 0, 1, 1, 1);
		
		Gtk::Button * button_name_all_similar = Gtk::manage(new Gtk::Button(_("All similar sections") ) );
		button_name_all_similar->set_size_request(150, 30);
		button_name_all_similar->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
				(*this, &ExampleWindow::name_similar_sections), rename_sec_dialog) );
		r_grid->attach(*button_name_all_similar, 1, 1, 1, 1);	
		
		Gtk::Button * button_cancel = Gtk::manage(new Gtk::Button(_("Cancel") ) );
		button_cancel->set_size_request(80, 30);	
		button_cancel->signal_clicked().connect(sigc::bind<Gtk::Window*>(sigc::mem_fun 
				(*this, &ExampleWindow::cancel_rename_section), rename_sec_dialog) );
		r_grid->attach(*button_cancel, 2, 1, 1, 1);
		r_vbox->show_all();
		rename_sec_dialog->show();	
	
}

// This function displays dialog asking for a name to name or rename
// one section
void ExampleWindow::name_one_section(Gtk::Window* window)
{
	rename_section_dialog = new Gtk::Window;
	Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0) );
    rename_section_dialog->add(*vbox);
	Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    vbox->add(*grid);
	Gtk::Label *lb = Gtk::manage(new Gtk::Label(_("Please enter short name for this section: \n\
	( 1-7characters long )")));
    grid->attach(*lb, 0, 0, 1, 1);
	Gtk::Entry *name = Gtk::manage(new Gtk::Entry() );
    name->set_hexpand(true);
	grid->attach(*name, 0, 1, 1, 1);
	
	Gtk::Button *b_rename = Gtk::manage(new Gtk::Button(_("Rename section") ) );
    b_rename->signal_clicked().connect(sigc::bind<Gtk::Window*, Gtk::Entry*>(sigc::mem_fun 
				(*this, &ExampleWindow::actually_name_one_section), rename_section_dialog, name) );
    grid->attach(*b_rename, 0, 2, 1, 1);

    vbox->show_all();
	rename_section_dialog->show();
	
	window->hide();
}

void ExampleWindow::actually_name_one_section(Gtk::Window* window, 
												Gtk::Entry * name)
{
	puts("naming one");
	if(selected_section == NULL)
	{
		Glib::ustring message(_("No sections selected") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	copied_section = NULL;
	Glib::ustring * buffer = new Glib::ustring(name->get_text() );
	
	MyButton * but = (MyButton*) selected_section->section_button;
	if(but->sect_name != NULL)
		delete (Glib::ustring *)but->sect_name;
	
	but->sect_name = buffer;
	
	copied_section = NULL;
	selected_section = NULL;
	update_section_buttons();
	window->hide();
}

// This function displays dialog asking for a name to name or rename 
// section base and all corresponding sections
void ExampleWindow::name_similar_sections(Gtk::Window* window)
{
	puts("naming many");
	rename_sections_dialog = new Gtk::Window;
	Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0) );
    rename_sections_dialog->add(*vbox);
	Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    vbox->add(*grid);
    puts("line 6777");
	Gtk::Label *lb = Gtk::manage(new Gtk::Label(_("Please enter short name for these sections: \n\
	( 1-7characters long )")));
    grid->attach(*lb, 0, 0, 1, 1);
	Gtk::Entry *name = Gtk::manage(new Gtk::Entry() );
    name->set_hexpand(true);
	grid->attach(*name, 0, 1, 1, 1);
	
	Gtk::Button *b_rename = Gtk::manage(new Gtk::Button(_("Rename sections") ) );
    b_rename->signal_clicked().connect(sigc::bind<Gtk::Window*, Gtk::Entry*>(sigc::mem_fun 
				(*this, &ExampleWindow::actually_name_similar_sections), rename_sections_dialog, name) );
    grid->attach(*b_rename, 0, 2, 1, 1);

    vbox->show_all();
    puts("line 6792");
	rename_sections_dialog->show();
	
	
	window->hide();
}

void ExampleWindow::actually_name_similar_sections(Gtk::Window* window,
												 Gtk::Entry * name)
{
	if(selected_section == NULL)
	{
		Glib::ustring message(_("No sections selected") );
		Gtk::MessageDialog dialog(*this, message);
		dialog.run();
		return;
	}
	puts("naming many");
		
	Glib::ustring * buffer = new Glib::ustring(name->get_text() );
	MyButton * selected_button = (MyButton *) selected_section->section_button;
	puts("line 6811");
	// find corresponding section base and  (re)name it
	Dlnode * base_node = (Dlnode *) area.curs_node->section_bases;
	Section_base * buf_base;
	while(base_node != NULL)
	{
		buf_base = (Section_base *) base_node->data;
		puts("line 6818");
		if(buf_base->chord_start == selected_button->sect_chord_start &&
			buf_base->chord_end == selected_button->sect_chord_end)
		{
			if(buf_base->name != NULL)
				delete ((Glib::ustring*) buf_base->name);
			
			buf_base->name = buffer;
			puts("base renamed");
			break;
		}
		puts("line 6828");
		base_node = base_node->next;
	}

	// find corresponding sections and rename them
	Dlnode * buf_section = (Dlnode *) area.curs_node->sections;
	MyButton * buf_button;
	while(buf_section != NULL)
	{
		buf_button = (MyButton*) buf_section->section_button;
		puts("line 6838");
		printf("\nbuf_button->sect_chord_start = %d\n", buf_button->sect_chord_start);
		printf("buf_button->sect_chord_end = %d\n", buf_button->sect_chord_end);
		printf("selected_button->sect_chord_start = %d\n", selected_button->sect_chord_start);
		printf("selected_button->sect_chord_end = %d\n", selected_button->sect_chord_end);
		
		if(buf_button->sect_chord_start == selected_button->sect_chord_start && 
			buf_button->sect_chord_end == selected_button->sect_chord_end)
		{
			if(buf_button->sect_name != NULL)
			{
				puts("buf_button->sect_name != NULL");
				delete ((Glib::ustring*) buf_button->sect_name);
			}
			puts("line 6854");
			buf_button->sect_name = copy_ustring(buffer);
			buf_button->queue_draw();
			puts("button (re)named");
		}
		puts("line 6848");
		buf_section = buf_section->next;
	}
	copied_section = NULL;
	selected_section = NULL;
	update_section_buttons();
	window->hide();
}

void ExampleWindow::cancel_rename_section(Gtk::Window* window)
{
	puts("canceling...");
	window->hide();
}

Glib::ustring * ExampleWindow::copy_ustring(Glib::ustring * original)
{
	const  Glib::ustring& con_sect_name = *original;
	Glib::ustring * copy = new Glib::ustring(con_sect_name);
	return copy;
} 

void ExampleWindow::new_chord_before_selected()
{
	puts("inside new_first_chord");
	int length = Dlist::dl_count (area.current_sequence);
	
	// every chord has at least one note, dummy note, which 
	// is not counted or displayed
	Dlnode * new_chord = Dlist::dl_create();
	Note * dummy_note = new Note(-1000);
	new_chord->data = dummy_note;
	
	// find out which of the chords is selected:
	// and insert new chord BEFORE it.
	
	// this points to the next chord after selected
	Dlnode * selected_chord_link = Dlist::dl_nth_node (area.current_sequence,
												selected_chord_number - 1);
	// this returns the new start of the list
	area.curs_node->data = Dlist::dl_insert_before(area.current_sequence,
								selected_chord_link, new_chord);
	area.current_sequence = (Dlnode*) area.curs_node->data;
		
	// make new chord selected -- 
	// selected_chord_number does not change
	// 0 start notation
	area.current_chord = (Dlnode * ) Dlist::dl_nth_data (area.current_sequence,
										selected_chord_number - 1);
	
	// mark corresponding chord buttons - 0 start notation
	// since selected chord does not change, buttons remain the same too.
	
	// change position_x for all notes in all chords to the right of new one
	Dlnode * buffer;	
	Note * n;
	for(int i=selected_chord_number; i< Dlist::dl_count(area.current_sequence); i++)
	{
		buffer = (Dlnode *) Dlist::dl_nth_node (area.current_sequence, i)->data;
		for(int j=1; j< Dlist::dl_count(buffer); j++)
		{
			n = (Note *) (Dlist::dl_nth_node(buffer, j)->data);
			(n->position_x) += 53;
		}
	}

	// update all occupied fields in chord buttons
	int len = Dlist::dl_count(area.current_sequence);
	chord_radio_buttons[len - 1]->occupied = true;
	chord_radio_buttons[len - 1]->queue_draw();

	// update all section bases
	Dlnode * buf_base_node = (Dlnode *) area.curs_node->section_bases;
	Section_base * buf_base;
	while(buf_base_node != NULL)
	{
		// find which section new chord was located in and change it:
		buf_base = (Section_base *) buf_base_node->data;
		int s = buf_base->chord_start; // counted from 1
		int e = buf_base->chord_end;	// counted from 1
		printf("base's s is %d, e is %d\n", s, e);
		printf("selected chord number is %d\n", selected_chord_number);
		
		if(selected_chord_number >= s && selected_chord_number <= e)
		{
			(buf_base->chord_end)++;
			(buf_base->length)++;
		}
		else if(selected_chord_number < s)
		{
			// update all bases to the right of selected chord
			(buf_base->chord_start)++;
			(buf_base->chord_end)++;
		}
		
		buf_base_node = buf_base_node->next;
	}
	
	// update all section buttons
	Dlnode * buf_sect_node = (Dlnode *) area.curs_node->sections;
	MyButton * buf_button;
	while(buf_sect_node != NULL)
	{
		// find which section new chord was located in and change it:
		buf_button = (MyButton *) buf_sect_node->section_button;
		int s = buf_button->sect_chord_start; // counted from 1
		int e = buf_button->sect_chord_end;	// counted from 1
		
		printf("button's s is %d, e is %d\n", s, e);
		printf("selected chord number is %d\n", selected_chord_number);
		
		if(selected_chord_number >= s && selected_chord_number <= e)
		{
			(buf_button->sect_chord_end)++;
			(buf_button->sect_chord_length)++;
		}
		else if(selected_chord_number < s)
		{
			// update all section buttons to the right of selected chord
			(buf_button->sect_chord_start)++;
			(buf_button->sect_chord_end)++;
		}
		
		buf_sect_node = buf_sect_node->next;
	}
	
	recalculate_section_buttons();
	update_section_buttons();
	area.queue_draw();
	
} // end new_chord_before_selected()
