/* Copyright (c) 2017-2018 Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
 *		This file is part of Chord Sequencer.
 * 
 * 		Chord Sequencer is a program to create and interactively play
 * 		series of chords in the live performance, controlling chord
 * 		change by pedal (or other similar device). It uses midi and
 * 		must be connected to an external synthesizer. 
 *
 *    Chord Sequencer is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Chord Sequencer is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *   along with Chord Sequencer.  If not, see <https://www.gnu.org/licenses/>.
 * 
 * 		Author: Marvin Eagle <trailblazer77_2000@yahoo.com>
 * 
*/
#ifndef GTKMM_CUSTOM_DLLIST_H
#define GTKMM_CUSTOM_DLLIST_H
#include <iostream> 
#include <cstdio>  
#include <cstdlib> 
#include <glib.h> 
#include <glibmm/ustring.h>
typedef void* gpointer;


typedef struct Dlnode
{
	int info;
	Glib::ustring *name;
	gpointer data; // reserved for Dlnodes linked to area.sequences 
	gpointer section_bases;
	gpointer section_button;
	gpointer sections; // will not be used
	gpointer eventbox;
	
	struct Dlnode *next;
	struct Dlnode *prev;
} Dlnode;

typedef Dlnode Sequence;
 
class Dlist
{
public:
	
	Dlist();
	
	static Dlnode * dl_create();
	static Dlnode * dl_create(gpointer element);
	static Dlnode * dl_append(Dlnode * head, gpointer data);
	static Dlnode * dl_prepend(Dlnode * head, gpointer data);
	static int dl_count(Dlnode * head);
	static Dlnode * dl_last(Dlnode * anynode);
	static Dlnode * dl_delete_node(Dlnode * head, Dlnode * node);
	static Dlnode * dl_find(Dlnode * head, gpointer data);
	static Dlnode * dl_nth_node(Dlnode * head, guint position);
	static gpointer dl_nth_data(Dlnode * head, guint position);
	static Dlnode * dl_insert_before(Dlnode * head, Dlnode * sibling, gpointer data);
	static Dlnode * dl_insert_before_but(Dlnode * head, Dlnode * sibling, gpointer data);
	static Dlnode * dl_remove_node(Dlnode * head, Dlnode * node_to_remove);
	static int dl_index(Dlnode * head, gpointer data);
	static int dl_node_index(Dlnode * head, Dlnode * node_to_find);
	static Dlnode * dl_append_but(Dlnode * head, gpointer button);
	static Dlnode * dl_append_evbox(Dlnode * head, gpointer evbox);
	static Dlnode * dl_prepend_but(Dlnode * head, gpointer button);
	static Dlnode * dl_prepend_evbox(Dlnode * head, gpointer evbox);
	static Dlnode * dl_find_but(Dlnode * head, gpointer button);
	static Dlnode * dl_find_evbox(Dlnode * head, gpointer evbox);

};

// Delete everything below this line, except for #endif


#endif //GTKMM_CUSTOM_DLLIST_H
